/* systemd-interfaces.c generated by valac, the Vala compiler
 * generated from systemd-interfaces.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus.h>


#define TYPE_MANAGER (manager_get_type ())
#define MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MANAGER, Manager))
#define IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MANAGER))
#define MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MANAGER, ManagerIface))

typedef struct _Manager Manager;
typedef struct _ManagerIface ManagerIface;

#define MANAGER_TYPE_UNIT_INFO (manager_unit_info_get_type ())
typedef struct _ManagerUnitInfo ManagerUnitInfo;

#define MANAGER_TYPE_JOB_INFO (manager_job_info_get_type ())
typedef struct _ManagerJobInfo ManagerJobInfo;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ManagerDBusProxy ManagerDBusProxy;
typedef DBusGProxyClass ManagerDBusProxyClass;

#define TYPE_UNIT (unit_get_type ())
#define UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT, Unit))
#define IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT))
#define UNIT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_UNIT, UnitIface))

typedef struct _Unit Unit;
typedef struct _UnitIface UnitIface;

#define UNIT_TYPE_JOB_LINK (unit_job_link_get_type ())
typedef struct _UnitJobLink UnitJobLink;
typedef struct _UnitDBusProxy UnitDBusProxy;
typedef DBusGProxyClass UnitDBusProxyClass;

#define TYPE_JOB (job_get_type ())
#define JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JOB, Job))
#define IS_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JOB))
#define JOB_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_JOB, JobIface))

typedef struct _Job Job;
typedef struct _JobIface JobIface;

#define JOB_TYPE_UNIT_LINK (job_unit_link_get_type ())
typedef struct _JobUnitLink JobUnitLink;
typedef struct _JobDBusProxy JobDBusProxy;
typedef DBusGProxyClass JobDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _ManagerUnitInfo {
	char* id;
	char* description;
	char* load_state;
	char* active_state;
	char* sub_state;
	char* unit_path;
	guint32 job_id;
	char* job_type;
	char* job_path;
};

struct _ManagerJobInfo {
	guint32 id;
	char* name;
	char* type;
	char* state;
	char* job_path;
	char* unit_path;
};

struct _ManagerIface {
	GTypeInterface parent_iface;
	ManagerUnitInfo* (*list_units) (Manager* self, int* result_length1, GError** error);
	ManagerJobInfo* (*list_jobs) (Manager* self, int* result_length1, GError** error);
	char* (*get_unit) (Manager* self, const char* name, GError** error);
	char* (*load_unit) (Manager* self, const char* name, GError** error);
	char* (*get_job) (Manager* self, guint32 id, GError** error);
	char* (*start_unit) (Manager* self, const char* name, const char* mode, GError** error);
	char* (*stop_unit) (Manager* self, const char* name, const char* mode, GError** error);
	char* (*reload_unit) (Manager* self, const char* name, const char* mode, GError** error);
	char* (*restart_unit) (Manager* self, const char* name, const char* mode, GError** error);
	void (*clear_jobs) (Manager* self, GError** error);
	void (*subscribe) (Manager* self, GError** error);
	void (*unsubscribe) (Manager* self, GError** error);
	char* (*dump) (Manager* self, GError** error);
	void (*reload) (Manager* self, GError** error);
	void (*reexecute) (Manager* self, GError** error);
	void (*exit) (Manager* self, GError** error);
	char* (*create_snapshot) (Manager* self, const char* name, gboolean cleanup, GError** error);
	void (*set_environment) (Manager* self, char** names, int names_length1, GError** error);
	void (*unset_environment) (Manager* self, char** names, int names_length1, GError** error);
	char** (*get_environment) (Manager* self, int* result_length1);
};

struct _ManagerDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _UnitJobLink {
	guint32 id;
	char* path;
};

struct _UnitIface {
	GTypeInterface parent_iface;
	char* (*start) (Unit* self, const char* mode, GError** error);
	char* (*stop) (Unit* self, const char* mode, GError** error);
	char* (*restart) (Unit* self, const char* mode, GError** error);
	char* (*reload) (Unit* self, const char* mode, GError** error);
	char* (*get_id) (Unit* self);
	char** (*get_names) (Unit* self, int* result_length1);
	char** (*get_requires) (Unit* self, int* result_length1);
	char** (*get_requires_overridable) (Unit* self, int* result_length1);
	char** (*get_requisite) (Unit* self, int* result_length1);
	char** (*get_requisite_overridable) (Unit* self, int* result_length1);
	char** (*get_wants) (Unit* self, int* result_length1);
	char** (*get_required_by) (Unit* self, int* result_length1);
	char** (*get_required_by_overridable) (Unit* self, int* result_length1);
	char** (*get_wanted_by) (Unit* self, int* result_length1);
	char** (*get_conflicts) (Unit* self, int* result_length1);
	char** (*get_before) (Unit* self, int* result_length1);
	char** (*get_after) (Unit* self, int* result_length1);
	char* (*get_description) (Unit* self);
	char* (*get_load_state) (Unit* self);
	char* (*get_active_state) (Unit* self);
	char* (*get_sub_state) (Unit* self);
	char* (*get_fragment_path) (Unit* self);
	guint64 (*get_inactive_exit_timestamp) (Unit* self);
	guint64 (*get_active_enter_timestamp) (Unit* self);
	guint64 (*get_active_exit_timestamp) (Unit* self);
	guint64 (*get_inactive_enter_timestamp) (Unit* self);
	gboolean (*get_can_start) (Unit* self);
	gboolean (*get_can_reload) (Unit* self);
	void (*get_job) (Unit* self, UnitJobLink* value);
	gboolean (*get_recursive_stop) (Unit* self);
	gboolean (*get_stop_when_unneeded) (Unit* self);
	char* (*get_default_control_group) (Unit* self);
	char** (*get_control_groups) (Unit* self, int* result_length1);
};

struct _UnitDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _JobUnitLink {
	char* id;
	char* path;
};

struct _JobIface {
	GTypeInterface parent_iface;
	void (*cancel) (Job* self, GError** error);
	guint32 (*get_id) (Job* self);
	char* (*get_state) (Job* self);
	char* (*get_job_type) (Job* self);
	void (*get_unit) (Job* self, JobUnitLink* value);
};

struct _JobDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



GType manager_unit_info_get_type (void);
ManagerUnitInfo* manager_unit_info_dup (const ManagerUnitInfo* self);
void manager_unit_info_free (ManagerUnitInfo* self);
void manager_unit_info_copy (const ManagerUnitInfo* self, ManagerUnitInfo* dest);
void manager_unit_info_destroy (ManagerUnitInfo* self);
GType manager_job_info_get_type (void);
ManagerJobInfo* manager_job_info_dup (const ManagerJobInfo* self);
void manager_job_info_free (ManagerJobInfo* self);
void manager_job_info_copy (const ManagerJobInfo* self, ManagerJobInfo* dest);
void manager_job_info_destroy (ManagerJobInfo* self);
GType manager_get_type (void);
ManagerUnitInfo* manager_list_units (Manager* self, int* result_length1, GError** error);
ManagerJobInfo* manager_list_jobs (Manager* self, int* result_length1, GError** error);
char* manager_get_unit (Manager* self, const char* name, GError** error);
char* manager_load_unit (Manager* self, const char* name, GError** error);
char* manager_get_job (Manager* self, guint32 id, GError** error);
char* manager_start_unit (Manager* self, const char* name, const char* mode, GError** error);
char* manager_stop_unit (Manager* self, const char* name, const char* mode, GError** error);
char* manager_reload_unit (Manager* self, const char* name, const char* mode, GError** error);
char* manager_restart_unit (Manager* self, const char* name, const char* mode, GError** error);
void manager_clear_jobs (Manager* self, GError** error);
void manager_subscribe (Manager* self, GError** error);
void manager_unsubscribe (Manager* self, GError** error);
char* manager_dump (Manager* self, GError** error);
void manager_reload (Manager* self, GError** error);
void manager_reexecute (Manager* self, GError** error);
void manager_exit (Manager* self, GError** error);
char* manager_create_snapshot (Manager* self, const char* name, gboolean cleanup, GError** error);
void manager_set_environment (Manager* self, char** names, int names_length1, GError** error);
void manager_unset_environment (Manager* self, char** names, int names_length1, GError** error);
char** manager_get_environment (Manager* self, int* result_length1);
void manager_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _manager_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult manager_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_manager_introspect (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_property_get (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_property_get_all (Manager* self, DBusConnection* connection, DBusMessage* message);
static void _vala_ManagerUnitInfo_array_free (ManagerUnitInfo* array, gint array_length);
static DBusHandlerResult _dbus_manager_list_units (Manager* self, DBusConnection* connection, DBusMessage* message);
static void _vala_ManagerJobInfo_array_free (ManagerJobInfo* array, gint array_length);
static DBusHandlerResult _dbus_manager_list_jobs (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_get_unit (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_load_unit (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_get_job (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_start_unit (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_stop_unit (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_reload_unit (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_restart_unit (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_clear_jobs (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_subscribe (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_unsubscribe (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_dump (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_reload (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_reexecute (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_exit (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_create_snapshot (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_set_environment (Manager* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_manager_unset_environment (Manager* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_manager_unit_new (GObject* _sender, const char* id, const char* path, DBusConnection* _connection);
static void _dbus_manager_unit_removed (GObject* _sender, const char* id, const char* path, DBusConnection* _connection);
static void _dbus_manager_job_new (GObject* _sender, guint32 id, const char* path, DBusConnection* _connection);
static void _dbus_manager_job_removed (GObject* _sender, guint32 id, const char* path, gboolean success, DBusConnection* _connection);
GType manager_dbus_proxy_get_type (void);
Manager* manager_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_manager_unit_new (Manager* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_manager_unit_removed (Manager* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_manager_job_new (Manager* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_handle_manager_job_removed (Manager* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult manager_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	MANAGER_DBUS_PROXY_DUMMY_PROPERTY,
	MANAGER_DBUS_PROXY_ENVIRONMENT
};
static ManagerUnitInfo* manager_dbus_proxy_list_units (Manager* self, int* result_length1, GError** error);
static ManagerJobInfo* manager_dbus_proxy_list_jobs (Manager* self, int* result_length1, GError** error);
static char* manager_dbus_proxy_get_unit (Manager* self, const char* name, GError** error);
static char* manager_dbus_proxy_load_unit (Manager* self, const char* name, GError** error);
static char* manager_dbus_proxy_get_job (Manager* self, guint32 id, GError** error);
static char* manager_dbus_proxy_start_unit (Manager* self, const char* name, const char* mode, GError** error);
static char* manager_dbus_proxy_stop_unit (Manager* self, const char* name, const char* mode, GError** error);
static char* manager_dbus_proxy_reload_unit (Manager* self, const char* name, const char* mode, GError** error);
static char* manager_dbus_proxy_restart_unit (Manager* self, const char* name, const char* mode, GError** error);
static void manager_dbus_proxy_clear_jobs (Manager* self, GError** error);
static void manager_dbus_proxy_subscribe (Manager* self, GError** error);
static void manager_dbus_proxy_unsubscribe (Manager* self, GError** error);
static char* manager_dbus_proxy_dump (Manager* self, GError** error);
static void manager_dbus_proxy_reload (Manager* self, GError** error);
static void manager_dbus_proxy_reexecute (Manager* self, GError** error);
static void manager_dbus_proxy_exit (Manager* self, GError** error);
static char* manager_dbus_proxy_create_snapshot (Manager* self, const char* name, gboolean cleanup, GError** error);
static void manager_dbus_proxy_set_environment (Manager* self, char** names, int names_length1, GError** error);
static void manager_dbus_proxy_unset_environment (Manager* self, char** names, int names_length1, GError** error);
static char** manager_dbus_proxy_get_environment (Manager* self, int* result_length1);
static void manager_dbus_proxy_manager__interface_init (ManagerIface* iface);
static void manager_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void manager_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unit_job_link_get_type (void);
UnitJobLink* unit_job_link_dup (const UnitJobLink* self);
void unit_job_link_free (UnitJobLink* self);
void unit_job_link_copy (const UnitJobLink* self, UnitJobLink* dest);
void unit_job_link_destroy (UnitJobLink* self);
GType unit_get_type (void);
char* unit_start (Unit* self, const char* mode, GError** error);
char* unit_stop (Unit* self, const char* mode, GError** error);
char* unit_restart (Unit* self, const char* mode, GError** error);
char* unit_reload (Unit* self, const char* mode, GError** error);
char* unit_get_id (Unit* self);
char** unit_get_names (Unit* self, int* result_length1);
char** unit_get_requires (Unit* self, int* result_length1);
char** unit_get_requires_overridable (Unit* self, int* result_length1);
char** unit_get_requisite (Unit* self, int* result_length1);
char** unit_get_requisite_overridable (Unit* self, int* result_length1);
char** unit_get_wants (Unit* self, int* result_length1);
char** unit_get_required_by (Unit* self, int* result_length1);
char** unit_get_required_by_overridable (Unit* self, int* result_length1);
char** unit_get_wanted_by (Unit* self, int* result_length1);
char** unit_get_conflicts (Unit* self, int* result_length1);
char** unit_get_before (Unit* self, int* result_length1);
char** unit_get_after (Unit* self, int* result_length1);
char* unit_get_description (Unit* self);
char* unit_get_load_state (Unit* self);
char* unit_get_active_state (Unit* self);
char* unit_get_sub_state (Unit* self);
char* unit_get_fragment_path (Unit* self);
guint64 unit_get_inactive_exit_timestamp (Unit* self);
guint64 unit_get_active_enter_timestamp (Unit* self);
guint64 unit_get_active_exit_timestamp (Unit* self);
guint64 unit_get_inactive_enter_timestamp (Unit* self);
gboolean unit_get_can_start (Unit* self);
gboolean unit_get_can_reload (Unit* self);
void unit_get_job (Unit* self, UnitJobLink* result);
gboolean unit_get_recursive_stop (Unit* self);
gboolean unit_get_stop_when_unneeded (Unit* self);
char* unit_get_default_control_group (Unit* self);
char** unit_get_control_groups (Unit* self, int* result_length1);
void unit_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _unit_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult unit_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_unit_introspect (Unit* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unit_property_get (Unit* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unit_property_get_all (Unit* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unit_start (Unit* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unit_stop (Unit* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unit_restart (Unit* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_unit_reload (Unit* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_unit_changed (GObject* _sender, DBusConnection* _connection);
GType unit_dbus_proxy_get_type (void);
Unit* unit_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_unit_changed (Unit* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult unit_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	UNIT_DBUS_PROXY_DUMMY_PROPERTY,
	UNIT_DBUS_PROXY_ID,
	UNIT_DBUS_PROXY_NAMES,
	UNIT_DBUS_PROXY_REQUIRES,
	UNIT_DBUS_PROXY_REQUIRES_OVERRIDABLE,
	UNIT_DBUS_PROXY_REQUISITE,
	UNIT_DBUS_PROXY_REQUISITE_OVERRIDABLE,
	UNIT_DBUS_PROXY_WANTS,
	UNIT_DBUS_PROXY_REQUIRED_BY,
	UNIT_DBUS_PROXY_REQUIRED_BY_OVERRIDABLE,
	UNIT_DBUS_PROXY_WANTED_BY,
	UNIT_DBUS_PROXY_CONFLICTS,
	UNIT_DBUS_PROXY_BEFORE,
	UNIT_DBUS_PROXY_AFTER,
	UNIT_DBUS_PROXY_DESCRIPTION,
	UNIT_DBUS_PROXY_LOAD_STATE,
	UNIT_DBUS_PROXY_ACTIVE_STATE,
	UNIT_DBUS_PROXY_SUB_STATE,
	UNIT_DBUS_PROXY_FRAGMENT_PATH,
	UNIT_DBUS_PROXY_INACTIVE_EXIT_TIMESTAMP,
	UNIT_DBUS_PROXY_ACTIVE_ENTER_TIMESTAMP,
	UNIT_DBUS_PROXY_ACTIVE_EXIT_TIMESTAMP,
	UNIT_DBUS_PROXY_INACTIVE_ENTER_TIMESTAMP,
	UNIT_DBUS_PROXY_CAN_START,
	UNIT_DBUS_PROXY_CAN_RELOAD,
	UNIT_DBUS_PROXY_JOB,
	UNIT_DBUS_PROXY_RECURSIVE_STOP,
	UNIT_DBUS_PROXY_STOP_WHEN_UNNEEDED,
	UNIT_DBUS_PROXY_DEFAULT_CONTROL_GROUP,
	UNIT_DBUS_PROXY_CONTROL_GROUPS
};
static char* unit_dbus_proxy_start (Unit* self, const char* mode, GError** error);
static char* unit_dbus_proxy_stop (Unit* self, const char* mode, GError** error);
static char* unit_dbus_proxy_restart (Unit* self, const char* mode, GError** error);
static char* unit_dbus_proxy_reload (Unit* self, const char* mode, GError** error);
static char* unit_dbus_proxy_get_id (Unit* self);
static char** unit_dbus_proxy_get_names (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_requires (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_requires_overridable (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_requisite (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_requisite_overridable (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_wants (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_required_by (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_required_by_overridable (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_wanted_by (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_conflicts (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_before (Unit* self, int* result_length1);
static char** unit_dbus_proxy_get_after (Unit* self, int* result_length1);
static char* unit_dbus_proxy_get_description (Unit* self);
static char* unit_dbus_proxy_get_load_state (Unit* self);
static char* unit_dbus_proxy_get_active_state (Unit* self);
static char* unit_dbus_proxy_get_sub_state (Unit* self);
static char* unit_dbus_proxy_get_fragment_path (Unit* self);
static guint64 unit_dbus_proxy_get_inactive_exit_timestamp (Unit* self);
static guint64 unit_dbus_proxy_get_active_enter_timestamp (Unit* self);
static guint64 unit_dbus_proxy_get_active_exit_timestamp (Unit* self);
static guint64 unit_dbus_proxy_get_inactive_enter_timestamp (Unit* self);
static gboolean unit_dbus_proxy_get_can_start (Unit* self);
static gboolean unit_dbus_proxy_get_can_reload (Unit* self);
static void unit_dbus_proxy_get_job (Unit* self, UnitJobLink* result);
static gboolean unit_dbus_proxy_get_recursive_stop (Unit* self);
static gboolean unit_dbus_proxy_get_stop_when_unneeded (Unit* self);
static char* unit_dbus_proxy_get_default_control_group (Unit* self);
static char** unit_dbus_proxy_get_control_groups (Unit* self, int* result_length1);
static void unit_dbus_proxy_unit__interface_init (UnitIface* iface);
static void unit_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unit_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType job_unit_link_get_type (void);
JobUnitLink* job_unit_link_dup (const JobUnitLink* self);
void job_unit_link_free (JobUnitLink* self);
void job_unit_link_copy (const JobUnitLink* self, JobUnitLink* dest);
void job_unit_link_destroy (JobUnitLink* self);
GType job_get_type (void);
void job_cancel (Job* self, GError** error);
guint32 job_get_id (Job* self);
char* job_get_state (Job* self);
char* job_get_job_type (Job* self);
void job_get_unit (Job* self, JobUnitLink* result);
void job_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _job_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult job_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_job_introspect (Job* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_job_property_get (Job* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_job_property_get_all (Job* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_job_cancel (Job* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_job_changed (GObject* _sender, DBusConnection* _connection);
GType job_dbus_proxy_get_type (void);
Job* job_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
static void _dbus_handle_job_changed (Job* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult job_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	JOB_DBUS_PROXY_DUMMY_PROPERTY,
	JOB_DBUS_PROXY_ID,
	JOB_DBUS_PROXY_STATE,
	JOB_DBUS_PROXY_JOB_TYPE,
	JOB_DBUS_PROXY_UNIT
};
static void job_dbus_proxy_cancel (Job* self, GError** error);
static guint32 job_dbus_proxy_get_id (Job* self);
static char* job_dbus_proxy_get_state (Job* self);
static char* job_dbus_proxy_get_job_type (Job* self);
static void job_dbus_proxy_get_unit (Job* self, JobUnitLink* result);
static void job_dbus_proxy_job__interface_init (JobIface* iface);
static void job_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void job_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _manager_dbus_path_vtable = {_manager_dbus_unregister, manager_dbus_message};
static const _DBusObjectVTable _manager_dbus_vtable = {manager_dbus_register_object};
static const DBusObjectPathVTable _unit_dbus_path_vtable = {_unit_dbus_unregister, unit_dbus_message};
static const _DBusObjectVTable _unit_dbus_vtable = {unit_dbus_register_object};
static const DBusObjectPathVTable _job_dbus_path_vtable = {_job_dbus_unregister, job_dbus_message};
static const _DBusObjectVTable _job_dbus_vtable = {job_dbus_register_object};

static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__UINT_BOXED_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

#line 48 "systemd-interfaces.vala"
ManagerUnitInfo* manager_list_units (Manager* self, int* result_length1, GError** error) {
#line 48 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->list_units (self, result_length1, error);
#line 457 "systemd-interfaces.c"
}


#line 49 "systemd-interfaces.vala"
ManagerJobInfo* manager_list_jobs (Manager* self, int* result_length1, GError** error) {
#line 49 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->list_jobs (self, result_length1, error);
#line 465 "systemd-interfaces.c"
}


#line 51 "systemd-interfaces.vala"
char* manager_get_unit (Manager* self, const char* name, GError** error) {
#line 51 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->get_unit (self, name, error);
#line 473 "systemd-interfaces.c"
}


#line 52 "systemd-interfaces.vala"
char* manager_load_unit (Manager* self, const char* name, GError** error) {
#line 52 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->load_unit (self, name, error);
#line 481 "systemd-interfaces.c"
}


#line 53 "systemd-interfaces.vala"
char* manager_get_job (Manager* self, guint32 id, GError** error) {
#line 53 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->get_job (self, id, error);
#line 489 "systemd-interfaces.c"
}


#line 55 "systemd-interfaces.vala"
char* manager_start_unit (Manager* self, const char* name, const char* mode, GError** error) {
#line 55 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->start_unit (self, name, mode, error);
#line 497 "systemd-interfaces.c"
}


#line 56 "systemd-interfaces.vala"
char* manager_stop_unit (Manager* self, const char* name, const char* mode, GError** error) {
#line 56 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->stop_unit (self, name, mode, error);
#line 505 "systemd-interfaces.c"
}


#line 57 "systemd-interfaces.vala"
char* manager_reload_unit (Manager* self, const char* name, const char* mode, GError** error) {
#line 57 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->reload_unit (self, name, mode, error);
#line 513 "systemd-interfaces.c"
}


#line 58 "systemd-interfaces.vala"
char* manager_restart_unit (Manager* self, const char* name, const char* mode, GError** error) {
#line 58 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->restart_unit (self, name, mode, error);
#line 521 "systemd-interfaces.c"
}


#line 60 "systemd-interfaces.vala"
void manager_clear_jobs (Manager* self, GError** error) {
#line 60 "systemd-interfaces.vala"
	MANAGER_GET_INTERFACE (self)->clear_jobs (self, error);
#line 529 "systemd-interfaces.c"
}


#line 62 "systemd-interfaces.vala"
void manager_subscribe (Manager* self, GError** error) {
#line 62 "systemd-interfaces.vala"
	MANAGER_GET_INTERFACE (self)->subscribe (self, error);
#line 537 "systemd-interfaces.c"
}


#line 63 "systemd-interfaces.vala"
void manager_unsubscribe (Manager* self, GError** error) {
#line 63 "systemd-interfaces.vala"
	MANAGER_GET_INTERFACE (self)->unsubscribe (self, error);
#line 545 "systemd-interfaces.c"
}


#line 65 "systemd-interfaces.vala"
char* manager_dump (Manager* self, GError** error) {
#line 65 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->dump (self, error);
#line 553 "systemd-interfaces.c"
}


#line 67 "systemd-interfaces.vala"
void manager_reload (Manager* self, GError** error) {
#line 67 "systemd-interfaces.vala"
	MANAGER_GET_INTERFACE (self)->reload (self, error);
#line 561 "systemd-interfaces.c"
}


#line 68 "systemd-interfaces.vala"
void manager_reexecute (Manager* self, GError** error) {
#line 68 "systemd-interfaces.vala"
	MANAGER_GET_INTERFACE (self)->reexecute (self, error);
#line 569 "systemd-interfaces.c"
}


#line 69 "systemd-interfaces.vala"
void manager_exit (Manager* self, GError** error) {
#line 69 "systemd-interfaces.vala"
	MANAGER_GET_INTERFACE (self)->exit (self, error);
#line 577 "systemd-interfaces.c"
}


#line 71 "systemd-interfaces.vala"
char* manager_create_snapshot (Manager* self, const char* name, gboolean cleanup, GError** error) {
#line 71 "systemd-interfaces.vala"
	return MANAGER_GET_INTERFACE (self)->create_snapshot (self, name, cleanup, error);
#line 585 "systemd-interfaces.c"
}


#line 73 "systemd-interfaces.vala"
void manager_set_environment (Manager* self, char** names, int names_length1, GError** error) {
#line 73 "systemd-interfaces.vala"
	MANAGER_GET_INTERFACE (self)->set_environment (self, names, names_length1, error);
#line 593 "systemd-interfaces.c"
}


#line 74 "systemd-interfaces.vala"
void manager_unset_environment (Manager* self, char** names, int names_length1, GError** error) {
#line 74 "systemd-interfaces.vala"
	MANAGER_GET_INTERFACE (self)->unset_environment (self, names, names_length1, error);
#line 601 "systemd-interfaces.c"
}


char** manager_get_environment (Manager* self, int* result_length1) {
	return MANAGER_GET_INTERFACE (self)->get_environment (self, result_length1);
}


void manager_unit_info_copy (const ManagerUnitInfo* self, ManagerUnitInfo* dest) {
	dest->id = g_strdup (self->id);
	dest->description = g_strdup (self->description);
	dest->load_state = g_strdup (self->load_state);
	dest->active_state = g_strdup (self->active_state);
	dest->sub_state = g_strdup (self->sub_state);
	dest->unit_path = g_strdup (self->unit_path);
	dest->job_id = self->job_id;
	dest->job_type = g_strdup (self->job_type);
	dest->job_path = g_strdup (self->job_path);
}


void manager_unit_info_destroy (ManagerUnitInfo* self) {
	_g_free0 (self->id);
	_g_free0 (self->description);
	_g_free0 (self->load_state);
	_g_free0 (self->active_state);
	_g_free0 (self->sub_state);
	_g_free0 (self->unit_path);
	_g_free0 (self->job_type);
	_g_free0 (self->job_path);
}


ManagerUnitInfo* manager_unit_info_dup (const ManagerUnitInfo* self) {
	ManagerUnitInfo* dup;
	dup = g_new0 (ManagerUnitInfo, 1);
	manager_unit_info_copy (self, dup);
	return dup;
}


void manager_unit_info_free (ManagerUnitInfo* self) {
	manager_unit_info_destroy (self);
	g_free (self);
}


GType manager_unit_info_get_type (void) {
	static volatile gsize manager_unit_info_type_id__volatile = 0;
	if (g_once_init_enter (&manager_unit_info_type_id__volatile)) {
		GType manager_unit_info_type_id;
		manager_unit_info_type_id = g_boxed_type_register_static ("ManagerUnitInfo", (GBoxedCopyFunc) manager_unit_info_dup, (GBoxedFreeFunc) manager_unit_info_free);
		g_once_init_leave (&manager_unit_info_type_id__volatile, manager_unit_info_type_id);
	}
	return manager_unit_info_type_id__volatile;
}


void manager_job_info_copy (const ManagerJobInfo* self, ManagerJobInfo* dest) {
	dest->id = self->id;
	dest->name = g_strdup (self->name);
	dest->type = g_strdup (self->type);
	dest->state = g_strdup (self->state);
	dest->job_path = g_strdup (self->job_path);
	dest->unit_path = g_strdup (self->unit_path);
}


void manager_job_info_destroy (ManagerJobInfo* self) {
	_g_free0 (self->name);
	_g_free0 (self->type);
	_g_free0 (self->state);
	_g_free0 (self->job_path);
	_g_free0 (self->unit_path);
}


ManagerJobInfo* manager_job_info_dup (const ManagerJobInfo* self) {
	ManagerJobInfo* dup;
	dup = g_new0 (ManagerJobInfo, 1);
	manager_job_info_copy (self, dup);
	return dup;
}


void manager_job_info_free (ManagerJobInfo* self) {
	manager_job_info_destroy (self);
	g_free (self);
}


GType manager_job_info_get_type (void) {
	static volatile gsize manager_job_info_type_id__volatile = 0;
	if (g_once_init_enter (&manager_job_info_type_id__volatile)) {
		GType manager_job_info_type_id;
		manager_job_info_type_id = g_boxed_type_register_static ("ManagerJobInfo", (GBoxedCopyFunc) manager_job_info_dup, (GBoxedFreeFunc) manager_job_info_free);
		g_once_init_leave (&manager_job_info_type_id__volatile, manager_job_info_type_id);
	}
	return manager_job_info_type_id__volatile;
}


void _manager_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_manager_introspect (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.systemd1.Manager\">\n  <method name=\"ListUnits\">\n    <arg name=\"result\" type=\"a(sssssouso)\" direction=\"out\"/>\n  </method>\n  <method name=\"ListJobs\">\n    <arg name=\"result\" type=\"a(usssoo)\" direction=\"out\"/>\n  </method>\n  <method name=\"GetUnit\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"LoadUnit\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"GetJob\">\n    <arg name=\"id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"StartUnit\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"mode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"StopUnit\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"mode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"ReloadUnit\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"mode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"RestartUnit\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"mode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"ClearJobs\">\n  </method>\n  <method name=\"Subscribe\">\n  </method>\n  <method name=\"Unsubscribe\">\n  </method>\n  <method name=\"Dump\">\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"Reload\">\n  </method>\n  <method name=\"Reexecute\">\n  </method>\n  <method name=\"Exit\">\n  </method>\n  <method name=\"CreateSnapshot\">\n    <arg name=\"name\" type=\"s\" direction=\"in\"/>\n    <arg name=\"cleanup\" type=\"b\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"SetEnvironment\">\n    <arg name=\"names\" type=\"as\" direction=\"in\"/>\n  </method>\n  <method name=\"UnsetEnvironment\">\n    <arg name=\"names\" type=\"as\" direction=\"in\"/>\n  </method>\n  <property name=\"Environment\" type=\"as\" access=\"read\"/>\n  <signal name=\"UnitNew\">\n    <arg name=\"id\" type=\"s\"/>\n    <arg name=\"path\" type=\"o\"/>\n  </signal>\n  <signal name=\"UnitRemoved\">\n    <arg name=\"id\" type=\"s\"/>\n    <arg name=\"path\" type=\"o\"/>\n  </signal>\n  <signal name=\"JobNew\">\n    <arg name=\"id\" type=\"u\"/>\n    <arg name=\"path\" type=\"o\"/>\n  </signal>\n  <signal name=\"JobRemoved\">\n    <arg name=\"id\" type=\"u\"/>\n    <arg name=\"path\" type=\"o\"/>\n    <arg name=\"success\" type=\"b\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_property_get (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	char* property_name;
	const char* _tmp1_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp1_);
	if ((strcmp (interface_name, "org.freedesktop.systemd1.Manager") == 0) && (strcmp (property_name, "Environment") == 0)) {
		char** result;
		int result_length1;
		char** _tmp2_;
		DBusMessageIter _tmp3_;
		int _tmp4_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = manager_get_environment (self, &result_length1);
		_tmp2_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp3_);
		for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
			const char* _tmp5_;
			_tmp5_ = *_tmp2_;
			dbus_message_iter_append_basic (&_tmp3_, DBUS_TYPE_STRING, &_tmp5_);
			_tmp2_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp3_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_property_get_all (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp6_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp6_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp6_);
	if (strcmp (interface_name, "org.freedesktop.systemd1.Manager") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char** result;
			int result_length1;
			char** _tmp7_;
			DBusMessageIter _tmp8_;
			int _tmp9_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Environment";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = manager_get_environment (self, &result_length1);
			_tmp7_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp8_);
			for (_tmp9_ = 0; _tmp9_ < result_length1; _tmp9_++) {
				const char* _tmp10_;
				_tmp10_ = *_tmp7_;
				dbus_message_iter_append_basic (&_tmp8_, DBUS_TYPE_STRING, &_tmp10_);
				_tmp7_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp8_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _vala_ManagerUnitInfo_array_free (ManagerUnitInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			manager_unit_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DBusHandlerResult _dbus_manager_list_units (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	ManagerUnitInfo* result;
	int result_length1;
	DBusMessage* reply;
	ManagerUnitInfo* _tmp11_;
	DBusMessageIter _tmp12_;
	int _tmp13_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = manager_list_units (self, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp11_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "(sssssouso)", &_tmp12_);
	for (_tmp13_ = 0; _tmp13_ < result_length1; _tmp13_++) {
		DBusMessageIter _tmp14_;
		const char* _tmp15_;
		const char* _tmp16_;
		const char* _tmp17_;
		const char* _tmp18_;
		const char* _tmp19_;
		const char* _tmp20_;
		dbus_uint32_t _tmp21_;
		const char* _tmp22_;
		const char* _tmp23_;
		dbus_message_iter_open_container (&_tmp12_, DBUS_TYPE_STRUCT, NULL, &_tmp14_);
		_tmp15_ = (*_tmp11_).id;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_STRING, &_tmp15_);
		_tmp16_ = (*_tmp11_).description;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_STRING, &_tmp16_);
		_tmp17_ = (*_tmp11_).load_state;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_STRING, &_tmp17_);
		_tmp18_ = (*_tmp11_).active_state;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_STRING, &_tmp18_);
		_tmp19_ = (*_tmp11_).sub_state;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_STRING, &_tmp19_);
		_tmp20_ = (*_tmp11_).unit_path;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_OBJECT_PATH, &_tmp20_);
		_tmp21_ = (*_tmp11_).job_id;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_UINT32, &_tmp21_);
		_tmp22_ = (*_tmp11_).job_type;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_STRING, &_tmp22_);
		_tmp23_ = (*_tmp11_).job_path;
		dbus_message_iter_append_basic (&_tmp14_, DBUS_TYPE_OBJECT_PATH, &_tmp23_);
		dbus_message_iter_close_container (&_tmp12_, &_tmp14_);
		_tmp11_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp12_);
	result = (_vala_ManagerUnitInfo_array_free (result,  result_length1), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _vala_ManagerJobInfo_array_free (ManagerJobInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			manager_job_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DBusHandlerResult _dbus_manager_list_jobs (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	ManagerJobInfo* result;
	int result_length1;
	DBusMessage* reply;
	ManagerJobInfo* _tmp24_;
	DBusMessageIter _tmp25_;
	int _tmp26_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = manager_list_jobs (self, &result_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp24_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "(usssoo)", &_tmp25_);
	for (_tmp26_ = 0; _tmp26_ < result_length1; _tmp26_++) {
		DBusMessageIter _tmp27_;
		dbus_uint32_t _tmp28_;
		const char* _tmp29_;
		const char* _tmp30_;
		const char* _tmp31_;
		const char* _tmp32_;
		const char* _tmp33_;
		dbus_message_iter_open_container (&_tmp25_, DBUS_TYPE_STRUCT, NULL, &_tmp27_);
		_tmp28_ = (*_tmp24_).id;
		dbus_message_iter_append_basic (&_tmp27_, DBUS_TYPE_UINT32, &_tmp28_);
		_tmp29_ = (*_tmp24_).name;
		dbus_message_iter_append_basic (&_tmp27_, DBUS_TYPE_STRING, &_tmp29_);
		_tmp30_ = (*_tmp24_).type;
		dbus_message_iter_append_basic (&_tmp27_, DBUS_TYPE_STRING, &_tmp30_);
		_tmp31_ = (*_tmp24_).state;
		dbus_message_iter_append_basic (&_tmp27_, DBUS_TYPE_STRING, &_tmp31_);
		_tmp32_ = (*_tmp24_).job_path;
		dbus_message_iter_append_basic (&_tmp27_, DBUS_TYPE_OBJECT_PATH, &_tmp32_);
		_tmp33_ = (*_tmp24_).unit_path;
		dbus_message_iter_append_basic (&_tmp27_, DBUS_TYPE_OBJECT_PATH, &_tmp33_);
		dbus_message_iter_close_container (&_tmp25_, &_tmp27_);
		_tmp24_++;
	}
	dbus_message_iter_close_container (&iter, &_tmp25_);
	result = (_vala_ManagerJobInfo_array_free (result,  result_length1), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_get_unit (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* name = NULL;
	const char* _tmp34_;
	char* result;
	DBusMessage* reply;
	const char* _tmp35_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp34_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp34_);
	result = manager_get_unit (self, name, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (name);
	_tmp35_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp35_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_load_unit (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* name = NULL;
	const char* _tmp36_;
	char* result;
	DBusMessage* reply;
	const char* _tmp37_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp36_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp36_);
	result = manager_load_unit (self, name, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (name);
	_tmp37_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp37_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_get_job (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 id = 0U;
	dbus_uint32_t _tmp38_;
	char* result;
	DBusMessage* reply;
	const char* _tmp39_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp38_);
	dbus_message_iter_next (&iter);
	id = _tmp38_;
	result = manager_get_job (self, id, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp39_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp39_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_start_unit (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* name = NULL;
	const char* _tmp40_;
	char* mode = NULL;
	const char* _tmp41_;
	char* result;
	DBusMessage* reply;
	const char* _tmp42_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp40_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp40_);
	dbus_message_iter_get_basic (&iter, &_tmp41_);
	dbus_message_iter_next (&iter);
	mode = g_strdup (_tmp41_);
	result = manager_start_unit (self, name, mode, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (name);
	_g_free0 (mode);
	_tmp42_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp42_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_stop_unit (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* name = NULL;
	const char* _tmp43_;
	char* mode = NULL;
	const char* _tmp44_;
	char* result;
	DBusMessage* reply;
	const char* _tmp45_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp43_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp43_);
	dbus_message_iter_get_basic (&iter, &_tmp44_);
	dbus_message_iter_next (&iter);
	mode = g_strdup (_tmp44_);
	result = manager_stop_unit (self, name, mode, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (name);
	_g_free0 (mode);
	_tmp45_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp45_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_reload_unit (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* name = NULL;
	const char* _tmp46_;
	char* mode = NULL;
	const char* _tmp47_;
	char* result;
	DBusMessage* reply;
	const char* _tmp48_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp46_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp46_);
	dbus_message_iter_get_basic (&iter, &_tmp47_);
	dbus_message_iter_next (&iter);
	mode = g_strdup (_tmp47_);
	result = manager_reload_unit (self, name, mode, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (name);
	_g_free0 (mode);
	_tmp48_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp48_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_restart_unit (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* name = NULL;
	const char* _tmp49_;
	char* mode = NULL;
	const char* _tmp50_;
	char* result;
	DBusMessage* reply;
	const char* _tmp51_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp49_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp49_);
	dbus_message_iter_get_basic (&iter, &_tmp50_);
	dbus_message_iter_next (&iter);
	mode = g_strdup (_tmp50_);
	result = manager_restart_unit (self, name, mode, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (name);
	_g_free0 (mode);
	_tmp51_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp51_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_clear_jobs (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	manager_clear_jobs (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_subscribe (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	manager_subscribe (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_unsubscribe (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	manager_unsubscribe (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_dump (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* result;
	DBusMessage* reply;
	const char* _tmp52_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	result = manager_dump (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp52_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp52_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_reload (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	manager_reload (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_reexecute (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	manager_reexecute (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_exit (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	manager_exit (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_create_snapshot (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* name = NULL;
	const char* _tmp53_;
	gboolean cleanup = FALSE;
	dbus_bool_t _tmp54_;
	char* result;
	DBusMessage* reply;
	const char* _tmp55_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "sb")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp53_);
	dbus_message_iter_next (&iter);
	name = g_strdup (_tmp53_);
	dbus_message_iter_get_basic (&iter, &_tmp54_);
	dbus_message_iter_next (&iter);
	cleanup = _tmp54_;
	result = manager_create_snapshot (self, name, cleanup, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (name);
	_tmp55_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp55_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_set_environment (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** names = NULL;
	int names_length1;
	char** _tmp56_;
	int _tmp56__length;
	int _tmp56__size;
	int _tmp56__length1;
	DBusMessageIter _tmp57_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "as")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	names_length1 = 0;
	_tmp56_ = g_new (char*, 5);
	_tmp56__length = 0;
	_tmp56__size = 4;
	_tmp56__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp57_);
	for (; dbus_message_iter_get_arg_type (&_tmp57_); _tmp56__length1++) {
		const char* _tmp58_;
		if (_tmp56__size == _tmp56__length) {
			_tmp56__size = 2 * _tmp56__size;
			_tmp56_ = g_renew (char*, _tmp56_, _tmp56__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp57_, &_tmp58_);
		dbus_message_iter_next (&_tmp57_);
		_tmp56_[_tmp56__length++] = g_strdup (_tmp58_);
	}
	names_length1 = _tmp56__length1;
	_tmp56_[_tmp56__length] = NULL;
	dbus_message_iter_next (&iter);
	names = _tmp56_;
	manager_set_environment (self, names, names_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_manager_unset_environment (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char** names = NULL;
	int names_length1;
	char** _tmp59_;
	int _tmp59__length;
	int _tmp59__size;
	int _tmp59__length1;
	DBusMessageIter _tmp60_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "as")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	names_length1 = 0;
	_tmp59_ = g_new (char*, 5);
	_tmp59__length = 0;
	_tmp59__size = 4;
	_tmp59__length1 = 0;
	dbus_message_iter_recurse (&iter, &_tmp60_);
	for (; dbus_message_iter_get_arg_type (&_tmp60_); _tmp59__length1++) {
		const char* _tmp61_;
		if (_tmp59__size == _tmp59__length) {
			_tmp59__size = 2 * _tmp59__size;
			_tmp59_ = g_renew (char*, _tmp59_, _tmp59__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp60_, &_tmp61_);
		dbus_message_iter_next (&_tmp60_);
		_tmp59_[_tmp59__length++] = g_strdup (_tmp61_);
	}
	names_length1 = _tmp59__length1;
	_tmp59_[_tmp59__length] = NULL;
	dbus_message_iter_next (&iter);
	names = _tmp59_;
	manager_unset_environment (self, names, names_length1, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	names = (_vala_array_free (names, names_length1, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult manager_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_manager_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_manager_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_manager_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "ListUnits")) {
		result = _dbus_manager_list_units (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "ListJobs")) {
		result = _dbus_manager_list_jobs (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "GetUnit")) {
		result = _dbus_manager_get_unit (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "LoadUnit")) {
		result = _dbus_manager_load_unit (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "GetJob")) {
		result = _dbus_manager_get_job (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "StartUnit")) {
		result = _dbus_manager_start_unit (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "StopUnit")) {
		result = _dbus_manager_stop_unit (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "ReloadUnit")) {
		result = _dbus_manager_reload_unit (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "RestartUnit")) {
		result = _dbus_manager_restart_unit (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "ClearJobs")) {
		result = _dbus_manager_clear_jobs (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "Subscribe")) {
		result = _dbus_manager_subscribe (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "Unsubscribe")) {
		result = _dbus_manager_unsubscribe (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "Dump")) {
		result = _dbus_manager_dump (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "Reload")) {
		result = _dbus_manager_reload (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "Reexecute")) {
		result = _dbus_manager_reexecute (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "Exit")) {
		result = _dbus_manager_exit (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "CreateSnapshot")) {
		result = _dbus_manager_create_snapshot (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "SetEnvironment")) {
		result = _dbus_manager_set_environment (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Manager", "UnsetEnvironment")) {
		result = _dbus_manager_unset_environment (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_manager_unit_new (GObject* _sender, const char* id, const char* path, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp62_;
	const char* _tmp63_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.systemd1.Manager", "UnitNew");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp62_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp62_);
	_tmp63_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp63_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_manager_unit_removed (GObject* _sender, const char* id, const char* path, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	const char* _tmp64_;
	const char* _tmp65_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.systemd1.Manager", "UnitRemoved");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp64_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp64_);
	_tmp65_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp65_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_manager_job_new (GObject* _sender, guint32 id, const char* path, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp66_;
	const char* _tmp67_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.systemd1.Manager", "JobNew");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp66_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp66_);
	_tmp67_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp67_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


static void _dbus_manager_job_removed (GObject* _sender, guint32 id, const char* path, gboolean success, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp68_;
	const char* _tmp69_;
	dbus_bool_t _tmp70_;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.systemd1.Manager", "JobRemoved");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp68_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp68_);
	_tmp69_ = path;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_OBJECT_PATH, &_tmp69_);
	_tmp70_ = success;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp70_);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void manager_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_manager_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "unit-new", (GCallback) _dbus_manager_unit_new, connection);
	g_signal_connect (object, "unit-removed", (GCallback) _dbus_manager_unit_removed, connection);
	g_signal_connect (object, "job-new", (GCallback) _dbus_manager_job_new, connection);
	g_signal_connect (object, "job-removed", (GCallback) _dbus_manager_job_removed, connection);
}


static void manager_base_init (ManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_boxed ("environment", "environment", "environment", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("unit_new", TYPE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, DBUS_TYPE_G_OBJECT_PATH);
		g_signal_new ("unit_removed", TYPE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED, G_TYPE_NONE, 2, G_TYPE_STRING, DBUS_TYPE_G_OBJECT_PATH);
		g_signal_new ("job_new", TYPE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED, G_TYPE_NONE, 2, G_TYPE_UINT, DBUS_TYPE_G_OBJECT_PATH);
		g_signal_new ("job_removed", TYPE_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED_BOOLEAN, G_TYPE_NONE, 3, G_TYPE_UINT, DBUS_TYPE_G_OBJECT_PATH, G_TYPE_BOOLEAN);
		g_type_set_qdata (TYPE_MANAGER, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_manager_dbus_vtable));
	}
}


GType manager_get_type (void) {
	static volatile gsize manager_type_id__volatile = 0;
	if (g_once_init_enter (&manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ManagerIface), (GBaseInitFunc) manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType manager_type_id;
		manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "Manager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (manager_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (manager_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &manager_dbus_proxy_get_type);
		g_once_init_leave (&manager_type_id__volatile, manager_type_id);
	}
	return manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (ManagerDBusProxy, manager_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_MANAGER, manager_dbus_proxy_manager__interface_init) );
Manager* manager_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Manager* self;
	self = g_object_new (manager_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.systemd1.Manager", NULL);
	return self;
}


static GObject* manager_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (manager_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), manager_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_manager_unit_new (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* id = NULL;
	const char* _tmp71_;
	char* path = NULL;
	const char* _tmp72_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "so")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp71_);
	dbus_message_iter_next (&iter);
	id = g_strdup (_tmp71_);
	dbus_message_iter_get_basic (&iter, &_tmp72_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp72_);
	g_signal_emit_by_name (self, "unit-new", id, path);
	_g_free0 (id);
	_g_free0 (path);
}


static void _dbus_handle_manager_unit_removed (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	char* id = NULL;
	const char* _tmp73_;
	char* path = NULL;
	const char* _tmp74_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "so")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp73_);
	dbus_message_iter_next (&iter);
	id = g_strdup (_tmp73_);
	dbus_message_iter_get_basic (&iter, &_tmp74_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp74_);
	g_signal_emit_by_name (self, "unit-removed", id, path);
	_g_free0 (id);
	_g_free0 (path);
}


static void _dbus_handle_manager_job_new (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 id = 0U;
	dbus_uint32_t _tmp75_;
	char* path = NULL;
	const char* _tmp76_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uo")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp75_);
	dbus_message_iter_next (&iter);
	id = _tmp75_;
	dbus_message_iter_get_basic (&iter, &_tmp76_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp76_);
	g_signal_emit_by_name (self, "job-new", id, path);
	_g_free0 (path);
}


static void _dbus_handle_manager_job_removed (Manager* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint32 id = 0U;
	dbus_uint32_t _tmp77_;
	char* path = NULL;
	const char* _tmp78_;
	gboolean success = FALSE;
	dbus_bool_t _tmp79_;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uob")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp77_);
	dbus_message_iter_next (&iter);
	id = _tmp77_;
	dbus_message_iter_get_basic (&iter, &_tmp78_);
	dbus_message_iter_next (&iter);
	path = g_strdup (_tmp78_);
	dbus_message_iter_get_basic (&iter, &_tmp79_);
	dbus_message_iter_next (&iter);
	success = _tmp79_;
	g_signal_emit_by_name (self, "job-removed", id, path, success);
	_g_free0 (path);
}


DBusHandlerResult manager_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.systemd1.Manager", "UnitNew")) {
			_dbus_handle_manager_unit_new (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.freedesktop.systemd1.Manager", "UnitRemoved")) {
			_dbus_handle_manager_unit_removed (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.freedesktop.systemd1.Manager", "JobNew")) {
			_dbus_handle_manager_job_new (user_data, connection, message);
		} else if (dbus_message_is_signal (message, "org.freedesktop.systemd1.Manager", "JobRemoved")) {
			_dbus_handle_manager_job_removed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void manager_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((ManagerDBusProxy*) self)->disposed) {
		return;
	}
	((ManagerDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), manager_dbus_proxy_filter, self);
	G_OBJECT_CLASS (manager_dbus_proxy_parent_class)->dispose (self);
}


static void manager_dbus_proxy_class_init (ManagerDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = manager_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = manager_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = manager_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = manager_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), MANAGER_DBUS_PROXY_ENVIRONMENT, "environment");
}


static void manager_dbus_proxy_init (ManagerDBusProxy* self) {
}


static ManagerUnitInfo* manager_dbus_proxy_list_units (Manager* self, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	ManagerUnitInfo* _result;
	int _result_length1;
	ManagerUnitInfo* _tmp80_;
	int _tmp80__length;
	int _tmp80__size;
	int _tmp80__length1;
	DBusMessageIter _tmp81_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "ListUnits");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp93_;
			_edomain = DBUS_GERROR;
			_tmp93_ = _dbus_error.name + 27;
			if (strcmp (_tmp93_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp93_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp93_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp93_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp93_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp93_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp93_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp93_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp93_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp93_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp93_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp93_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp93_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp93_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp93_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp93_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp93_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp93_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp93_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp93_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp93_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp93_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp93_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp93_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp93_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp93_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp93_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp93_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp93_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp93_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp93_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp93_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp93_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "a(sssssouso)")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "a(sssssouso)", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp80_ = g_new (ManagerUnitInfo, 5);
	_tmp80__length = 0;
	_tmp80__size = 4;
	_tmp80__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp81_);
	for (; dbus_message_iter_get_arg_type (&_tmp81_); _tmp80__length1++) {
		ManagerUnitInfo _tmp82_;
		DBusMessageIter _tmp83_;
		const char* _tmp84_;
		const char* _tmp85_;
		const char* _tmp86_;
		const char* _tmp87_;
		const char* _tmp88_;
		const char* _tmp89_;
		dbus_uint32_t _tmp90_;
		const char* _tmp91_;
		const char* _tmp92_;
		if (_tmp80__size == _tmp80__length) {
			_tmp80__size = 2 * _tmp80__size;
			_tmp80_ = g_renew (ManagerUnitInfo, _tmp80_, _tmp80__size + 1);
		}
		dbus_message_iter_recurse (&_tmp81_, &_tmp83_);
		dbus_message_iter_get_basic (&_tmp83_, &_tmp84_);
		dbus_message_iter_next (&_tmp83_);
		_tmp82_.id = g_strdup (_tmp84_);
		dbus_message_iter_get_basic (&_tmp83_, &_tmp85_);
		dbus_message_iter_next (&_tmp83_);
		_tmp82_.description = g_strdup (_tmp85_);
		dbus_message_iter_get_basic (&_tmp83_, &_tmp86_);
		dbus_message_iter_next (&_tmp83_);
		_tmp82_.load_state = g_strdup (_tmp86_);
		dbus_message_iter_get_basic (&_tmp83_, &_tmp87_);
		dbus_message_iter_next (&_tmp83_);
		_tmp82_.active_state = g_strdup (_tmp87_);
		dbus_message_iter_get_basic (&_tmp83_, &_tmp88_);
		dbus_message_iter_next (&_tmp83_);
		_tmp82_.sub_state = g_strdup (_tmp88_);
		dbus_message_iter_get_basic (&_tmp83_, &_tmp89_);
		dbus_message_iter_next (&_tmp83_);
		_tmp82_.unit_path = g_strdup (_tmp89_);
		dbus_message_iter_get_basic (&_tmp83_, &_tmp90_);
		dbus_message_iter_next (&_tmp83_);
		_tmp82_.job_id = _tmp90_;
		dbus_message_iter_get_basic (&_tmp83_, &_tmp91_);
		dbus_message_iter_next (&_tmp83_);
		_tmp82_.job_type = g_strdup (_tmp91_);
		dbus_message_iter_get_basic (&_tmp83_, &_tmp92_);
		dbus_message_iter_next (&_tmp83_);
		_tmp82_.job_path = g_strdup (_tmp92_);
		dbus_message_iter_next (&_tmp81_);
		_tmp80_[_tmp80__length++] = _tmp82_;
	}
	_result_length1 = _tmp80__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp80_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static ManagerJobInfo* manager_dbus_proxy_list_jobs (Manager* self, int* result_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	ManagerJobInfo* _result;
	int _result_length1;
	ManagerJobInfo* _tmp94_;
	int _tmp94__length;
	int _tmp94__size;
	int _tmp94__length1;
	DBusMessageIter _tmp95_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "ListJobs");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp104_;
			_edomain = DBUS_GERROR;
			_tmp104_ = _dbus_error.name + 27;
			if (strcmp (_tmp104_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp104_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp104_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp104_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp104_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp104_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp104_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp104_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp104_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp104_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp104_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp104_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp104_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp104_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp104_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp104_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp104_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp104_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp104_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp104_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp104_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp104_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp104_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp104_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp104_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp104_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp104_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp104_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp104_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp104_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp104_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp104_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp104_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "a(usssoo)")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "a(usssoo)", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp94_ = g_new (ManagerJobInfo, 5);
	_tmp94__length = 0;
	_tmp94__size = 4;
	_tmp94__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp95_);
	for (; dbus_message_iter_get_arg_type (&_tmp95_); _tmp94__length1++) {
		ManagerJobInfo _tmp96_;
		DBusMessageIter _tmp97_;
		dbus_uint32_t _tmp98_;
		const char* _tmp99_;
		const char* _tmp100_;
		const char* _tmp101_;
		const char* _tmp102_;
		const char* _tmp103_;
		if (_tmp94__size == _tmp94__length) {
			_tmp94__size = 2 * _tmp94__size;
			_tmp94_ = g_renew (ManagerJobInfo, _tmp94_, _tmp94__size + 1);
		}
		dbus_message_iter_recurse (&_tmp95_, &_tmp97_);
		dbus_message_iter_get_basic (&_tmp97_, &_tmp98_);
		dbus_message_iter_next (&_tmp97_);
		_tmp96_.id = _tmp98_;
		dbus_message_iter_get_basic (&_tmp97_, &_tmp99_);
		dbus_message_iter_next (&_tmp97_);
		_tmp96_.name = g_strdup (_tmp99_);
		dbus_message_iter_get_basic (&_tmp97_, &_tmp100_);
		dbus_message_iter_next (&_tmp97_);
		_tmp96_.type = g_strdup (_tmp100_);
		dbus_message_iter_get_basic (&_tmp97_, &_tmp101_);
		dbus_message_iter_next (&_tmp97_);
		_tmp96_.state = g_strdup (_tmp101_);
		dbus_message_iter_get_basic (&_tmp97_, &_tmp102_);
		dbus_message_iter_next (&_tmp97_);
		_tmp96_.job_path = g_strdup (_tmp102_);
		dbus_message_iter_get_basic (&_tmp97_, &_tmp103_);
		dbus_message_iter_next (&_tmp97_);
		_tmp96_.unit_path = g_strdup (_tmp103_);
		dbus_message_iter_next (&_tmp95_);
		_tmp94_[_tmp94__length++] = _tmp96_;
	}
	_result_length1 = _tmp94__length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp94_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* manager_dbus_proxy_get_unit (Manager* self, const char* name, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp105_;
	char* _result;
	const char* _tmp106_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "GetUnit");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp105_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp105_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp107_;
			_edomain = DBUS_GERROR;
			_tmp107_ = _dbus_error.name + 27;
			if (strcmp (_tmp107_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp107_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp107_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp107_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp107_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp107_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp107_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp107_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp107_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp107_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp107_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp107_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp107_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp107_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp107_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp107_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp107_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp107_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp107_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp107_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp107_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp107_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp107_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp107_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp107_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp107_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp107_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp107_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp107_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp107_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp107_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp107_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp107_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp106_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp106_);
	dbus_message_unref (_reply);
	return _result;
}


static char* manager_dbus_proxy_load_unit (Manager* self, const char* name, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp108_;
	char* _result;
	const char* _tmp109_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "LoadUnit");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp108_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp108_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp110_;
			_edomain = DBUS_GERROR;
			_tmp110_ = _dbus_error.name + 27;
			if (strcmp (_tmp110_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp110_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp110_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp110_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp110_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp110_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp110_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp110_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp110_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp110_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp110_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp110_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp110_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp110_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp110_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp110_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp110_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp110_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp110_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp110_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp110_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp110_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp110_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp110_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp110_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp110_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp110_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp110_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp110_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp110_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp110_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp110_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp110_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp109_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp109_);
	dbus_message_unref (_reply);
	return _result;
}


static char* manager_dbus_proxy_get_job (Manager* self, guint32 id, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp111_;
	char* _result;
	const char* _tmp112_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "GetJob");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp111_ = id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp111_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp113_;
			_edomain = DBUS_GERROR;
			_tmp113_ = _dbus_error.name + 27;
			if (strcmp (_tmp113_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp113_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp113_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp113_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp113_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp113_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp113_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp113_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp113_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp113_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp113_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp113_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp113_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp113_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp113_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp113_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp113_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp113_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp113_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp113_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp113_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp113_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp113_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp113_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp113_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp113_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp113_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp113_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp113_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp113_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp113_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp113_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp113_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp112_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp112_);
	dbus_message_unref (_reply);
	return _result;
}


static char* manager_dbus_proxy_start_unit (Manager* self, const char* name, const char* mode, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp114_;
	const char* _tmp115_;
	char* _result;
	const char* _tmp116_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "StartUnit");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp114_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp114_);
	_tmp115_ = mode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp115_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp117_;
			_edomain = DBUS_GERROR;
			_tmp117_ = _dbus_error.name + 27;
			if (strcmp (_tmp117_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp117_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp117_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp117_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp117_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp117_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp117_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp117_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp117_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp117_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp117_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp117_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp117_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp117_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp117_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp117_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp117_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp117_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp117_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp117_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp117_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp117_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp117_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp117_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp117_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp117_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp117_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp117_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp117_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp117_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp117_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp117_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp117_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp116_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp116_);
	dbus_message_unref (_reply);
	return _result;
}


static char* manager_dbus_proxy_stop_unit (Manager* self, const char* name, const char* mode, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp118_;
	const char* _tmp119_;
	char* _result;
	const char* _tmp120_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "StopUnit");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp118_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp118_);
	_tmp119_ = mode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp119_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp121_;
			_edomain = DBUS_GERROR;
			_tmp121_ = _dbus_error.name + 27;
			if (strcmp (_tmp121_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp121_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp121_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp121_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp121_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp121_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp121_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp121_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp121_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp121_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp121_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp121_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp121_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp121_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp121_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp121_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp121_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp121_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp121_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp121_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp121_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp121_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp121_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp121_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp121_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp121_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp121_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp121_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp121_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp121_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp121_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp121_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp121_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp120_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp120_);
	dbus_message_unref (_reply);
	return _result;
}


static char* manager_dbus_proxy_reload_unit (Manager* self, const char* name, const char* mode, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp122_;
	const char* _tmp123_;
	char* _result;
	const char* _tmp124_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "ReloadUnit");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp122_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp122_);
	_tmp123_ = mode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp123_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp125_;
			_edomain = DBUS_GERROR;
			_tmp125_ = _dbus_error.name + 27;
			if (strcmp (_tmp125_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp125_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp125_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp125_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp125_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp125_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp125_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp125_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp125_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp125_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp125_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp125_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp125_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp125_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp125_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp125_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp125_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp125_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp125_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp125_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp125_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp125_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp125_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp125_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp125_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp125_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp125_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp125_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp125_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp125_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp125_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp125_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp125_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp124_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp124_);
	dbus_message_unref (_reply);
	return _result;
}


static char* manager_dbus_proxy_restart_unit (Manager* self, const char* name, const char* mode, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp126_;
	const char* _tmp127_;
	char* _result;
	const char* _tmp128_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "RestartUnit");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp126_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp126_);
	_tmp127_ = mode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp127_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp129_;
			_edomain = DBUS_GERROR;
			_tmp129_ = _dbus_error.name + 27;
			if (strcmp (_tmp129_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp129_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp129_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp129_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp129_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp129_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp129_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp129_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp129_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp129_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp129_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp129_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp129_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp129_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp129_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp129_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp129_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp129_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp129_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp129_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp129_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp129_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp129_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp129_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp129_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp129_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp129_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp129_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp129_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp129_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp129_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp129_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp129_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp128_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp128_);
	dbus_message_unref (_reply);
	return _result;
}


static void manager_dbus_proxy_clear_jobs (Manager* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "ClearJobs");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp130_;
			_edomain = DBUS_GERROR;
			_tmp130_ = _dbus_error.name + 27;
			if (strcmp (_tmp130_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp130_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp130_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp130_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp130_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp130_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp130_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp130_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp130_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp130_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp130_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp130_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp130_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp130_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp130_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp130_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp130_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp130_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp130_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp130_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp130_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp130_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp130_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp130_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp130_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp130_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp130_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp130_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp130_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp130_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp130_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp130_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp130_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void manager_dbus_proxy_subscribe (Manager* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "Subscribe");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp131_;
			_edomain = DBUS_GERROR;
			_tmp131_ = _dbus_error.name + 27;
			if (strcmp (_tmp131_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp131_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp131_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp131_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp131_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp131_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp131_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp131_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp131_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp131_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp131_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp131_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp131_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp131_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp131_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp131_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp131_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp131_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp131_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp131_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp131_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp131_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp131_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp131_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp131_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp131_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp131_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp131_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp131_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp131_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp131_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp131_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp131_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void manager_dbus_proxy_unsubscribe (Manager* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "Unsubscribe");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp132_;
			_edomain = DBUS_GERROR;
			_tmp132_ = _dbus_error.name + 27;
			if (strcmp (_tmp132_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp132_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp132_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp132_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp132_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp132_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp132_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp132_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp132_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp132_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp132_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp132_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp132_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp132_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp132_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp132_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp132_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp132_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp132_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp132_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp132_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp132_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp132_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp132_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp132_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp132_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp132_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp132_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp132_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp132_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp132_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp132_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp132_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* manager_dbus_proxy_dump (Manager* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char* _result;
	const char* _tmp133_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "Dump");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp134_;
			_edomain = DBUS_GERROR;
			_tmp134_ = _dbus_error.name + 27;
			if (strcmp (_tmp134_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp134_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp134_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp134_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp134_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp134_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp134_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp134_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp134_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp134_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp134_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp134_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp134_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp134_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp134_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp134_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp134_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp134_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp134_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp134_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp134_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp134_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp134_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp134_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp134_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp134_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp134_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp134_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp134_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp134_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp134_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp134_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp134_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "s")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "s", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp133_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp133_);
	dbus_message_unref (_reply);
	return _result;
}


static void manager_dbus_proxy_reload (Manager* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "Reload");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp135_;
			_edomain = DBUS_GERROR;
			_tmp135_ = _dbus_error.name + 27;
			if (strcmp (_tmp135_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp135_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp135_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp135_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp135_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp135_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp135_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp135_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp135_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp135_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp135_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp135_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp135_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp135_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp135_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp135_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp135_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp135_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp135_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp135_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp135_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp135_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp135_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp135_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp135_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp135_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp135_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp135_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp135_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp135_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp135_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp135_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp135_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void manager_dbus_proxy_reexecute (Manager* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "Reexecute");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp136_;
			_edomain = DBUS_GERROR;
			_tmp136_ = _dbus_error.name + 27;
			if (strcmp (_tmp136_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp136_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp136_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp136_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp136_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp136_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp136_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp136_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp136_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp136_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp136_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp136_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp136_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp136_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp136_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp136_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp136_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp136_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp136_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp136_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp136_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp136_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp136_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp136_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp136_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp136_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp136_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp136_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp136_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp136_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp136_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp136_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp136_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void manager_dbus_proxy_exit (Manager* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "Exit");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp137_;
			_edomain = DBUS_GERROR;
			_tmp137_ = _dbus_error.name + 27;
			if (strcmp (_tmp137_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp137_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp137_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp137_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp137_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp137_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp137_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp137_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp137_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp137_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp137_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp137_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp137_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp137_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp137_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp137_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp137_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp137_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp137_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp137_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp137_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp137_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp137_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp137_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp137_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp137_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp137_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp137_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp137_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp137_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp137_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp137_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp137_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char* manager_dbus_proxy_create_snapshot (Manager* self, const char* name, gboolean cleanup, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp138_;
	dbus_bool_t _tmp139_;
	char* _result;
	const char* _tmp140_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "CreateSnapshot");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp138_ = name;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp138_);
	_tmp139_ = cleanup;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_BOOLEAN, &_tmp139_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp141_;
			_edomain = DBUS_GERROR;
			_tmp141_ = _dbus_error.name + 27;
			if (strcmp (_tmp141_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp141_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp141_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp141_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp141_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp141_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp141_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp141_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp141_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp141_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp141_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp141_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp141_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp141_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp141_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp141_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp141_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp141_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp141_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp141_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp141_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp141_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp141_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp141_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp141_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp141_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp141_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp141_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp141_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp141_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp141_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp141_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp141_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp140_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp140_);
	dbus_message_unref (_reply);
	return _result;
}


static void manager_dbus_proxy_set_environment (Manager* self, char** names, int names_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _tmp142_;
	DBusMessageIter _tmp143_;
	int _tmp144_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "SetEnvironment");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp142_ = names;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp143_);
	for (_tmp144_ = 0; _tmp144_ < names_length1; _tmp144_++) {
		const char* _tmp145_;
		_tmp145_ = *_tmp142_;
		dbus_message_iter_append_basic (&_tmp143_, DBUS_TYPE_STRING, &_tmp145_);
		_tmp142_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp143_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp146_;
			_edomain = DBUS_GERROR;
			_tmp146_ = _dbus_error.name + 27;
			if (strcmp (_tmp146_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp146_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp146_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp146_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp146_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp146_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp146_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp146_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp146_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp146_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp146_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp146_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp146_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp146_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp146_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp146_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp146_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp146_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp146_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp146_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp146_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp146_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp146_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp146_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp146_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp146_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp146_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp146_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp146_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp146_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp146_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp146_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp146_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void manager_dbus_proxy_unset_environment (Manager* self, char** names, int names_length1, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	char** _tmp147_;
	DBusMessageIter _tmp148_;
	int _tmp149_;
	if (((ManagerDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Manager", "UnsetEnvironment");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp147_ = names;
	dbus_message_iter_open_container (&_iter, DBUS_TYPE_ARRAY, "s", &_tmp148_);
	for (_tmp149_ = 0; _tmp149_ < names_length1; _tmp149_++) {
		const char* _tmp150_;
		_tmp150_ = *_tmp147_;
		dbus_message_iter_append_basic (&_tmp148_, DBUS_TYPE_STRING, &_tmp150_);
		_tmp147_++;
	}
	dbus_message_iter_close_container (&_iter, &_tmp148_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp151_;
			_edomain = DBUS_GERROR;
			_tmp151_ = _dbus_error.name + 27;
			if (strcmp (_tmp151_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp151_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp151_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp151_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp151_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp151_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp151_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp151_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp151_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp151_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp151_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp151_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp151_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp151_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp151_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp151_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp151_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp151_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp151_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp151_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp151_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp151_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp151_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp151_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp151_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp151_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp151_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp151_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp151_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp151_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp151_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp151_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp151_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static char** manager_dbus_proxy_get_environment (Manager* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp152_;
	const char* _tmp153_;
	char** _result;
	int _result_length1;
	char** _tmp154_;
	int _tmp154__length;
	int _tmp154__size;
	int _tmp154__length1;
	DBusMessageIter _tmp155_;
	if (((ManagerDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp152_ = "org.freedesktop.systemd1.Manager";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp152_);
	_tmp153_ = "Environment";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp153_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp154_ = g_new (char*, 5);
	_tmp154__length = 0;
	_tmp154__size = 4;
	_tmp154__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp155_);
	for (; dbus_message_iter_get_arg_type (&_tmp155_); _tmp154__length1++) {
		const char* _tmp156_;
		if (_tmp154__size == _tmp154__length) {
			_tmp154__size = 2 * _tmp154__size;
			_tmp154_ = g_renew (char*, _tmp154_, _tmp154__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp155_, &_tmp156_);
		dbus_message_iter_next (&_tmp155_);
		_tmp154_[_tmp154__length++] = g_strdup (_tmp156_);
	}
	_result_length1 = _tmp154__length1;
	_tmp154_[_tmp154__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp154_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void manager_dbus_proxy_manager__interface_init (ManagerIface* iface) {
	iface->list_units = manager_dbus_proxy_list_units;
	iface->list_jobs = manager_dbus_proxy_list_jobs;
	iface->get_unit = manager_dbus_proxy_get_unit;
	iface->load_unit = manager_dbus_proxy_load_unit;
	iface->get_job = manager_dbus_proxy_get_job;
	iface->start_unit = manager_dbus_proxy_start_unit;
	iface->stop_unit = manager_dbus_proxy_stop_unit;
	iface->reload_unit = manager_dbus_proxy_reload_unit;
	iface->restart_unit = manager_dbus_proxy_restart_unit;
	iface->clear_jobs = manager_dbus_proxy_clear_jobs;
	iface->subscribe = manager_dbus_proxy_subscribe;
	iface->unsubscribe = manager_dbus_proxy_unsubscribe;
	iface->dump = manager_dbus_proxy_dump;
	iface->reload = manager_dbus_proxy_reload;
	iface->reexecute = manager_dbus_proxy_reexecute;
	iface->exit = manager_dbus_proxy_exit;
	iface->create_snapshot = manager_dbus_proxy_create_snapshot;
	iface->set_environment = manager_dbus_proxy_set_environment;
	iface->unset_environment = manager_dbus_proxy_unset_environment;
	iface->get_environment = manager_dbus_proxy_get_environment;
}


static void manager_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void manager_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


#line 119 "systemd-interfaces.vala"
char* unit_start (Unit* self, const char* mode, GError** error) {
#line 119 "systemd-interfaces.vala"
	return UNIT_GET_INTERFACE (self)->start (self, mode, error);
#line 6264 "systemd-interfaces.c"
}


#line 120 "systemd-interfaces.vala"
char* unit_stop (Unit* self, const char* mode, GError** error) {
#line 120 "systemd-interfaces.vala"
	return UNIT_GET_INTERFACE (self)->stop (self, mode, error);
#line 6272 "systemd-interfaces.c"
}


#line 121 "systemd-interfaces.vala"
char* unit_restart (Unit* self, const char* mode, GError** error) {
#line 121 "systemd-interfaces.vala"
	return UNIT_GET_INTERFACE (self)->restart (self, mode, error);
#line 6280 "systemd-interfaces.c"
}


#line 122 "systemd-interfaces.vala"
char* unit_reload (Unit* self, const char* mode, GError** error) {
#line 122 "systemd-interfaces.vala"
	return UNIT_GET_INTERFACE (self)->reload (self, mode, error);
#line 6288 "systemd-interfaces.c"
}


char* unit_get_id (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_id (self);
}


char** unit_get_names (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_names (self, result_length1);
}


char** unit_get_requires (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_requires (self, result_length1);
}


char** unit_get_requires_overridable (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_requires_overridable (self, result_length1);
}


char** unit_get_requisite (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_requisite (self, result_length1);
}


char** unit_get_requisite_overridable (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_requisite_overridable (self, result_length1);
}


char** unit_get_wants (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_wants (self, result_length1);
}


char** unit_get_required_by (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_required_by (self, result_length1);
}


char** unit_get_required_by_overridable (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_required_by_overridable (self, result_length1);
}


char** unit_get_wanted_by (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_wanted_by (self, result_length1);
}


char** unit_get_conflicts (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_conflicts (self, result_length1);
}


char** unit_get_before (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_before (self, result_length1);
}


char** unit_get_after (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_after (self, result_length1);
}


char* unit_get_description (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_description (self);
}


char* unit_get_load_state (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_load_state (self);
}


char* unit_get_active_state (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_active_state (self);
}


char* unit_get_sub_state (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_sub_state (self);
}


char* unit_get_fragment_path (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_fragment_path (self);
}


guint64 unit_get_inactive_exit_timestamp (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_inactive_exit_timestamp (self);
}


guint64 unit_get_active_enter_timestamp (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_active_enter_timestamp (self);
}


guint64 unit_get_active_exit_timestamp (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_active_exit_timestamp (self);
}


guint64 unit_get_inactive_enter_timestamp (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_inactive_enter_timestamp (self);
}


gboolean unit_get_can_start (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_can_start (self);
}


gboolean unit_get_can_reload (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_can_reload (self);
}


void unit_get_job (Unit* self, UnitJobLink* result) {
	UNIT_GET_INTERFACE (self)->get_job (self, result);
}


gboolean unit_get_recursive_stop (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_recursive_stop (self);
}


gboolean unit_get_stop_when_unneeded (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_stop_when_unneeded (self);
}


char* unit_get_default_control_group (Unit* self) {
	return UNIT_GET_INTERFACE (self)->get_default_control_group (self);
}


char** unit_get_control_groups (Unit* self, int* result_length1) {
	return UNIT_GET_INTERFACE (self)->get_control_groups (self, result_length1);
}


void unit_job_link_copy (const UnitJobLink* self, UnitJobLink* dest) {
	dest->id = self->id;
	dest->path = g_strdup (self->path);
}


void unit_job_link_destroy (UnitJobLink* self) {
	_g_free0 (self->path);
}


UnitJobLink* unit_job_link_dup (const UnitJobLink* self) {
	UnitJobLink* dup;
	dup = g_new0 (UnitJobLink, 1);
	unit_job_link_copy (self, dup);
	return dup;
}


void unit_job_link_free (UnitJobLink* self) {
	unit_job_link_destroy (self);
	g_free (self);
}


GType unit_job_link_get_type (void) {
	static volatile gsize unit_job_link_type_id__volatile = 0;
	if (g_once_init_enter (&unit_job_link_type_id__volatile)) {
		GType unit_job_link_type_id;
		unit_job_link_type_id = g_boxed_type_register_static ("UnitJobLink", (GBoxedCopyFunc) unit_job_link_dup, (GBoxedFreeFunc) unit_job_link_free);
		g_once_init_leave (&unit_job_link_type_id__volatile, unit_job_link_type_id);
	}
	return unit_job_link_type_id__volatile;
}


void _unit_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_unit_introspect (Unit* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.systemd1.Unit\">\n  <method name=\"Start\">\n    <arg name=\"mode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"Stop\">\n    <arg name=\"mode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"Restart\">\n    <arg name=\"mode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <method name=\"Reload\">\n    <arg name=\"mode\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"o\" direction=\"out\"/>\n  </method>\n  <property name=\"Id\" type=\"s\" access=\"read\"/>\n  <property name=\"Names\" type=\"as\" access=\"read\"/>\n  <property name=\"Requires\" type=\"as\" access=\"read\"/>\n  <property name=\"RequiresOverridable\" type=\"as\" access=\"read\"/>\n  <property name=\"Requisite\" type=\"as\" access=\"read\"/>\n  <property name=\"RequisiteOverridable\" type=\"as\" access=\"read\"/>\n  <property name=\"Wants\" type=\"as\" access=\"read\"/>\n  <property name=\"RequiredBy\" type=\"as\" access=\"read\"/>\n  <property name=\"RequiredByOverridable\" type=\"as\" access=\"read\"/>\n  <property name=\"WantedBy\" type=\"as\" access=\"read\"/>\n  <property name=\"Conflicts\" type=\"as\" access=\"read\"/>\n  <property name=\"Before\" type=\"as\" access=\"read\"/>\n  <property name=\"After\" type=\"as\" access=\"read\"/>\n  <property name=\"Description\" type=\"s\" access=\"read\"/>\n  <property name=\"LoadState\" type=\"s\" access=\"read\"/>\n  <property name=\"ActiveState\" type=\"s\" access=\"read\"/>\n  <property name=\"SubState\" type=\"s\" access=\"read\"/>\n  <property name=\"FragmentPath\" type=\"s\" access=\"read\"/>\n  <property name=\"InactiveExitTimestamp\" type=\"t\" access=\"read\"/>\n  <property name=\"ActiveEnterTimestamp\" type=\"t\" access=\"read\"/>\n  <property name=\"ActiveExitTimestamp\" type=\"t\" access=\"read\"/>\n  <property name=\"InactiveEnterTimestamp\" type=\"t\" access=\"read\"/>\n  <property name=\"CanStart\" type=\"b\" access=\"read\"/>\n  <property name=\"CanReload\" type=\"b\" access=\"read\"/>\n  <property name=\"Job\" type=\"(uo)\" access=\"read\"/>\n  <property name=\"RecursiveStop\" type=\"b\" access=\"read\"/>\n  <property name=\"StopWhenUnneeded\" type=\"b\" access=\"read\"/>\n  <property name=\"DefaultControlGroup\" type=\"s\" access=\"read\"/>\n  <property name=\"ControlGroups\" type=\"as\" access=\"read\"/>\n  <signal name=\"Changed\">\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unit_property_get (Unit* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp157_;
	char* property_name;
	const char* _tmp158_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp157_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp157_);
	dbus_message_iter_get_basic (&iter, &_tmp158_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp158_);
	if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "Id") == 0)) {
		char* result;
		const char* _tmp159_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = unit_get_id (self);
		_tmp159_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp159_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "Names") == 0)) {
		char** result;
		int result_length1;
		char** _tmp160_;
		DBusMessageIter _tmp161_;
		int _tmp162_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_names (self, &result_length1);
		_tmp160_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp161_);
		for (_tmp162_ = 0; _tmp162_ < result_length1; _tmp162_++) {
			const char* _tmp163_;
			_tmp163_ = *_tmp160_;
			dbus_message_iter_append_basic (&_tmp161_, DBUS_TYPE_STRING, &_tmp163_);
			_tmp160_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp161_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "Requires") == 0)) {
		char** result;
		int result_length1;
		char** _tmp164_;
		DBusMessageIter _tmp165_;
		int _tmp166_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_requires (self, &result_length1);
		_tmp164_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp165_);
		for (_tmp166_ = 0; _tmp166_ < result_length1; _tmp166_++) {
			const char* _tmp167_;
			_tmp167_ = *_tmp164_;
			dbus_message_iter_append_basic (&_tmp165_, DBUS_TYPE_STRING, &_tmp167_);
			_tmp164_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp165_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "RequiresOverridable") == 0)) {
		char** result;
		int result_length1;
		char** _tmp168_;
		DBusMessageIter _tmp169_;
		int _tmp170_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_requires_overridable (self, &result_length1);
		_tmp168_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp169_);
		for (_tmp170_ = 0; _tmp170_ < result_length1; _tmp170_++) {
			const char* _tmp171_;
			_tmp171_ = *_tmp168_;
			dbus_message_iter_append_basic (&_tmp169_, DBUS_TYPE_STRING, &_tmp171_);
			_tmp168_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp169_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "Requisite") == 0)) {
		char** result;
		int result_length1;
		char** _tmp172_;
		DBusMessageIter _tmp173_;
		int _tmp174_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_requisite (self, &result_length1);
		_tmp172_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp173_);
		for (_tmp174_ = 0; _tmp174_ < result_length1; _tmp174_++) {
			const char* _tmp175_;
			_tmp175_ = *_tmp172_;
			dbus_message_iter_append_basic (&_tmp173_, DBUS_TYPE_STRING, &_tmp175_);
			_tmp172_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp173_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "RequisiteOverridable") == 0)) {
		char** result;
		int result_length1;
		char** _tmp176_;
		DBusMessageIter _tmp177_;
		int _tmp178_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_requisite_overridable (self, &result_length1);
		_tmp176_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp177_);
		for (_tmp178_ = 0; _tmp178_ < result_length1; _tmp178_++) {
			const char* _tmp179_;
			_tmp179_ = *_tmp176_;
			dbus_message_iter_append_basic (&_tmp177_, DBUS_TYPE_STRING, &_tmp179_);
			_tmp176_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp177_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "Wants") == 0)) {
		char** result;
		int result_length1;
		char** _tmp180_;
		DBusMessageIter _tmp181_;
		int _tmp182_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_wants (self, &result_length1);
		_tmp180_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp181_);
		for (_tmp182_ = 0; _tmp182_ < result_length1; _tmp182_++) {
			const char* _tmp183_;
			_tmp183_ = *_tmp180_;
			dbus_message_iter_append_basic (&_tmp181_, DBUS_TYPE_STRING, &_tmp183_);
			_tmp180_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp181_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "RequiredBy") == 0)) {
		char** result;
		int result_length1;
		char** _tmp184_;
		DBusMessageIter _tmp185_;
		int _tmp186_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_required_by (self, &result_length1);
		_tmp184_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp185_);
		for (_tmp186_ = 0; _tmp186_ < result_length1; _tmp186_++) {
			const char* _tmp187_;
			_tmp187_ = *_tmp184_;
			dbus_message_iter_append_basic (&_tmp185_, DBUS_TYPE_STRING, &_tmp187_);
			_tmp184_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp185_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "RequiredByOverridable") == 0)) {
		char** result;
		int result_length1;
		char** _tmp188_;
		DBusMessageIter _tmp189_;
		int _tmp190_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_required_by_overridable (self, &result_length1);
		_tmp188_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp189_);
		for (_tmp190_ = 0; _tmp190_ < result_length1; _tmp190_++) {
			const char* _tmp191_;
			_tmp191_ = *_tmp188_;
			dbus_message_iter_append_basic (&_tmp189_, DBUS_TYPE_STRING, &_tmp191_);
			_tmp188_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp189_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "WantedBy") == 0)) {
		char** result;
		int result_length1;
		char** _tmp192_;
		DBusMessageIter _tmp193_;
		int _tmp194_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_wanted_by (self, &result_length1);
		_tmp192_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp193_);
		for (_tmp194_ = 0; _tmp194_ < result_length1; _tmp194_++) {
			const char* _tmp195_;
			_tmp195_ = *_tmp192_;
			dbus_message_iter_append_basic (&_tmp193_, DBUS_TYPE_STRING, &_tmp195_);
			_tmp192_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp193_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "Conflicts") == 0)) {
		char** result;
		int result_length1;
		char** _tmp196_;
		DBusMessageIter _tmp197_;
		int _tmp198_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_conflicts (self, &result_length1);
		_tmp196_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp197_);
		for (_tmp198_ = 0; _tmp198_ < result_length1; _tmp198_++) {
			const char* _tmp199_;
			_tmp199_ = *_tmp196_;
			dbus_message_iter_append_basic (&_tmp197_, DBUS_TYPE_STRING, &_tmp199_);
			_tmp196_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp197_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "Before") == 0)) {
		char** result;
		int result_length1;
		char** _tmp200_;
		DBusMessageIter _tmp201_;
		int _tmp202_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_before (self, &result_length1);
		_tmp200_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp201_);
		for (_tmp202_ = 0; _tmp202_ < result_length1; _tmp202_++) {
			const char* _tmp203_;
			_tmp203_ = *_tmp200_;
			dbus_message_iter_append_basic (&_tmp201_, DBUS_TYPE_STRING, &_tmp203_);
			_tmp200_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp201_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "After") == 0)) {
		char** result;
		int result_length1;
		char** _tmp204_;
		DBusMessageIter _tmp205_;
		int _tmp206_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_after (self, &result_length1);
		_tmp204_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp205_);
		for (_tmp206_ = 0; _tmp206_ < result_length1; _tmp206_++) {
			const char* _tmp207_;
			_tmp207_ = *_tmp204_;
			dbus_message_iter_append_basic (&_tmp205_, DBUS_TYPE_STRING, &_tmp207_);
			_tmp204_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp205_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "Description") == 0)) {
		char* result;
		const char* _tmp208_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = unit_get_description (self);
		_tmp208_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp208_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "LoadState") == 0)) {
		char* result;
		const char* _tmp209_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = unit_get_load_state (self);
		_tmp209_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp209_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "ActiveState") == 0)) {
		char* result;
		const char* _tmp210_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = unit_get_active_state (self);
		_tmp210_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp210_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "SubState") == 0)) {
		char* result;
		const char* _tmp211_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = unit_get_sub_state (self);
		_tmp211_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp211_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "FragmentPath") == 0)) {
		char* result;
		const char* _tmp212_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = unit_get_fragment_path (self);
		_tmp212_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp212_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "InactiveExitTimestamp") == 0)) {
		guint64 result;
		dbus_uint64_t _tmp213_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "t", &subiter);
		result = unit_get_inactive_exit_timestamp (self);
		_tmp213_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT64, &_tmp213_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "ActiveEnterTimestamp") == 0)) {
		guint64 result;
		dbus_uint64_t _tmp214_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "t", &subiter);
		result = unit_get_active_enter_timestamp (self);
		_tmp214_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT64, &_tmp214_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "ActiveExitTimestamp") == 0)) {
		guint64 result;
		dbus_uint64_t _tmp215_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "t", &subiter);
		result = unit_get_active_exit_timestamp (self);
		_tmp215_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT64, &_tmp215_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "InactiveEnterTimestamp") == 0)) {
		guint64 result;
		dbus_uint64_t _tmp216_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "t", &subiter);
		result = unit_get_inactive_enter_timestamp (self);
		_tmp216_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT64, &_tmp216_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "CanStart") == 0)) {
		gboolean result;
		dbus_bool_t _tmp217_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = unit_get_can_start (self);
		_tmp217_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp217_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "CanReload") == 0)) {
		gboolean result;
		dbus_bool_t _tmp218_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = unit_get_can_reload (self);
		_tmp218_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp218_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "Job") == 0)) {
		UnitJobLink result;
		DBusMessageIter _tmp219_;
		dbus_uint32_t _tmp220_;
		const char* _tmp221_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "(uo)", &subiter);
		unit_get_job (self, &result);
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_STRUCT, NULL, &_tmp219_);
		_tmp220_ = result.id;
		dbus_message_iter_append_basic (&_tmp219_, DBUS_TYPE_UINT32, &_tmp220_);
		_tmp221_ = result.path;
		dbus_message_iter_append_basic (&_tmp219_, DBUS_TYPE_OBJECT_PATH, &_tmp221_);
		dbus_message_iter_close_container (&subiter, &_tmp219_);
		unit_job_link_destroy (&result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "RecursiveStop") == 0)) {
		gboolean result;
		dbus_bool_t _tmp222_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = unit_get_recursive_stop (self);
		_tmp222_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp222_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "StopWhenUnneeded") == 0)) {
		gboolean result;
		dbus_bool_t _tmp223_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "b", &subiter);
		result = unit_get_stop_when_unneeded (self);
		_tmp223_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_BOOLEAN, &_tmp223_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "DefaultControlGroup") == 0)) {
		char* result;
		const char* _tmp224_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = unit_get_default_control_group (self);
		_tmp224_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp224_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) && (strcmp (property_name, "ControlGroups") == 0)) {
		char** result;
		int result_length1;
		char** _tmp225_;
		DBusMessageIter _tmp226_;
		int _tmp227_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "as", &subiter);
		result = unit_get_control_groups (self, &result_length1);
		_tmp225_ = result;
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_ARRAY, "s", &_tmp226_);
		for (_tmp227_ = 0; _tmp227_ < result_length1; _tmp227_++) {
			const char* _tmp228_;
			_tmp228_ = *_tmp225_;
			dbus_message_iter_append_basic (&_tmp226_, DBUS_TYPE_STRING, &_tmp228_);
			_tmp225_++;
		}
		dbus_message_iter_close_container (&subiter, &_tmp226_);
		result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unit_property_get_all (Unit* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp229_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp229_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp229_);
	if (strcmp (interface_name, "org.freedesktop.systemd1.Unit") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			char* result;
			const char* _tmp230_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Id";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = unit_get_id (self);
			_tmp230_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp230_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp231_;
			DBusMessageIter _tmp232_;
			int _tmp233_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Names";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_names (self, &result_length1);
			_tmp231_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp232_);
			for (_tmp233_ = 0; _tmp233_ < result_length1; _tmp233_++) {
				const char* _tmp234_;
				_tmp234_ = *_tmp231_;
				dbus_message_iter_append_basic (&_tmp232_, DBUS_TYPE_STRING, &_tmp234_);
				_tmp231_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp232_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp235_;
			DBusMessageIter _tmp236_;
			int _tmp237_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Requires";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_requires (self, &result_length1);
			_tmp235_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp236_);
			for (_tmp237_ = 0; _tmp237_ < result_length1; _tmp237_++) {
				const char* _tmp238_;
				_tmp238_ = *_tmp235_;
				dbus_message_iter_append_basic (&_tmp236_, DBUS_TYPE_STRING, &_tmp238_);
				_tmp235_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp236_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp239_;
			DBusMessageIter _tmp240_;
			int _tmp241_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "RequiresOverridable";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_requires_overridable (self, &result_length1);
			_tmp239_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp240_);
			for (_tmp241_ = 0; _tmp241_ < result_length1; _tmp241_++) {
				const char* _tmp242_;
				_tmp242_ = *_tmp239_;
				dbus_message_iter_append_basic (&_tmp240_, DBUS_TYPE_STRING, &_tmp242_);
				_tmp239_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp240_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp243_;
			DBusMessageIter _tmp244_;
			int _tmp245_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Requisite";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_requisite (self, &result_length1);
			_tmp243_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp244_);
			for (_tmp245_ = 0; _tmp245_ < result_length1; _tmp245_++) {
				const char* _tmp246_;
				_tmp246_ = *_tmp243_;
				dbus_message_iter_append_basic (&_tmp244_, DBUS_TYPE_STRING, &_tmp246_);
				_tmp243_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp244_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp247_;
			DBusMessageIter _tmp248_;
			int _tmp249_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "RequisiteOverridable";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_requisite_overridable (self, &result_length1);
			_tmp247_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp248_);
			for (_tmp249_ = 0; _tmp249_ < result_length1; _tmp249_++) {
				const char* _tmp250_;
				_tmp250_ = *_tmp247_;
				dbus_message_iter_append_basic (&_tmp248_, DBUS_TYPE_STRING, &_tmp250_);
				_tmp247_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp248_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp251_;
			DBusMessageIter _tmp252_;
			int _tmp253_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Wants";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_wants (self, &result_length1);
			_tmp251_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp252_);
			for (_tmp253_ = 0; _tmp253_ < result_length1; _tmp253_++) {
				const char* _tmp254_;
				_tmp254_ = *_tmp251_;
				dbus_message_iter_append_basic (&_tmp252_, DBUS_TYPE_STRING, &_tmp254_);
				_tmp251_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp252_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp255_;
			DBusMessageIter _tmp256_;
			int _tmp257_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "RequiredBy";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_required_by (self, &result_length1);
			_tmp255_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp256_);
			for (_tmp257_ = 0; _tmp257_ < result_length1; _tmp257_++) {
				const char* _tmp258_;
				_tmp258_ = *_tmp255_;
				dbus_message_iter_append_basic (&_tmp256_, DBUS_TYPE_STRING, &_tmp258_);
				_tmp255_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp256_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp259_;
			DBusMessageIter _tmp260_;
			int _tmp261_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "RequiredByOverridable";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_required_by_overridable (self, &result_length1);
			_tmp259_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp260_);
			for (_tmp261_ = 0; _tmp261_ < result_length1; _tmp261_++) {
				const char* _tmp262_;
				_tmp262_ = *_tmp259_;
				dbus_message_iter_append_basic (&_tmp260_, DBUS_TYPE_STRING, &_tmp262_);
				_tmp259_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp260_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp263_;
			DBusMessageIter _tmp264_;
			int _tmp265_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "WantedBy";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_wanted_by (self, &result_length1);
			_tmp263_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp264_);
			for (_tmp265_ = 0; _tmp265_ < result_length1; _tmp265_++) {
				const char* _tmp266_;
				_tmp266_ = *_tmp263_;
				dbus_message_iter_append_basic (&_tmp264_, DBUS_TYPE_STRING, &_tmp266_);
				_tmp263_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp264_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp267_;
			DBusMessageIter _tmp268_;
			int _tmp269_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Conflicts";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_conflicts (self, &result_length1);
			_tmp267_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp268_);
			for (_tmp269_ = 0; _tmp269_ < result_length1; _tmp269_++) {
				const char* _tmp270_;
				_tmp270_ = *_tmp267_;
				dbus_message_iter_append_basic (&_tmp268_, DBUS_TYPE_STRING, &_tmp270_);
				_tmp267_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp268_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp271_;
			DBusMessageIter _tmp272_;
			int _tmp273_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Before";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_before (self, &result_length1);
			_tmp271_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp272_);
			for (_tmp273_ = 0; _tmp273_ < result_length1; _tmp273_++) {
				const char* _tmp274_;
				_tmp274_ = *_tmp271_;
				dbus_message_iter_append_basic (&_tmp272_, DBUS_TYPE_STRING, &_tmp274_);
				_tmp271_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp272_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp275_;
			DBusMessageIter _tmp276_;
			int _tmp277_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "After";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_after (self, &result_length1);
			_tmp275_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp276_);
			for (_tmp277_ = 0; _tmp277_ < result_length1; _tmp277_++) {
				const char* _tmp278_;
				_tmp278_ = *_tmp275_;
				dbus_message_iter_append_basic (&_tmp276_, DBUS_TYPE_STRING, &_tmp278_);
				_tmp275_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp276_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp279_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Description";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = unit_get_description (self);
			_tmp279_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp279_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp280_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "LoadState";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = unit_get_load_state (self);
			_tmp280_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp280_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp281_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ActiveState";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = unit_get_active_state (self);
			_tmp281_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp281_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp282_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "SubState";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = unit_get_sub_state (self);
			_tmp282_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp282_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp283_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "FragmentPath";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = unit_get_fragment_path (self);
			_tmp283_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp283_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint64 result;
			dbus_uint64_t _tmp284_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "InactiveExitTimestamp";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "t", &value_iter);
			result = unit_get_inactive_exit_timestamp (self);
			_tmp284_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT64, &_tmp284_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint64 result;
			dbus_uint64_t _tmp285_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ActiveEnterTimestamp";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "t", &value_iter);
			result = unit_get_active_enter_timestamp (self);
			_tmp285_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT64, &_tmp285_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint64 result;
			dbus_uint64_t _tmp286_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ActiveExitTimestamp";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "t", &value_iter);
			result = unit_get_active_exit_timestamp (self);
			_tmp286_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT64, &_tmp286_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			guint64 result;
			dbus_uint64_t _tmp287_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "InactiveEnterTimestamp";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "t", &value_iter);
			result = unit_get_inactive_enter_timestamp (self);
			_tmp287_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT64, &_tmp287_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp288_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "CanStart";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = unit_get_can_start (self);
			_tmp288_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp288_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp289_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "CanReload";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = unit_get_can_reload (self);
			_tmp289_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp289_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			UnitJobLink result;
			DBusMessageIter _tmp290_;
			dbus_uint32_t _tmp291_;
			const char* _tmp292_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Job";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "(uo)", &value_iter);
			unit_get_job (self, &result);
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_STRUCT, NULL, &_tmp290_);
			_tmp291_ = result.id;
			dbus_message_iter_append_basic (&_tmp290_, DBUS_TYPE_UINT32, &_tmp291_);
			_tmp292_ = result.path;
			dbus_message_iter_append_basic (&_tmp290_, DBUS_TYPE_OBJECT_PATH, &_tmp292_);
			dbus_message_iter_close_container (&value_iter, &_tmp290_);
			unit_job_link_destroy (&result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp293_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "RecursiveStop";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = unit_get_recursive_stop (self);
			_tmp293_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp293_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			gboolean result;
			dbus_bool_t _tmp294_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "StopWhenUnneeded";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "b", &value_iter);
			result = unit_get_stop_when_unneeded (self);
			_tmp294_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_BOOLEAN, &_tmp294_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp295_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "DefaultControlGroup";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = unit_get_default_control_group (self);
			_tmp295_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp295_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char** result;
			int result_length1;
			char** _tmp296_;
			DBusMessageIter _tmp297_;
			int _tmp298_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "ControlGroups";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "as", &value_iter);
			result = unit_get_control_groups (self, &result_length1);
			_tmp296_ = result;
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_ARRAY, "s", &_tmp297_);
			for (_tmp298_ = 0; _tmp298_ < result_length1; _tmp298_++) {
				const char* _tmp299_;
				_tmp299_ = *_tmp296_;
				dbus_message_iter_append_basic (&_tmp297_, DBUS_TYPE_STRING, &_tmp299_);
				_tmp296_++;
			}
			dbus_message_iter_close_container (&value_iter, &_tmp297_);
			result = (_vala_array_free (result,  result_length1, (GDestroyNotify) g_free), NULL);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unit_start (Unit* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* mode = NULL;
	const char* _tmp300_;
	char* result;
	DBusMessage* reply;
	const char* _tmp301_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp300_);
	dbus_message_iter_next (&iter);
	mode = g_strdup (_tmp300_);
	result = unit_start (self, mode, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (mode);
	_tmp301_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp301_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unit_stop (Unit* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* mode = NULL;
	const char* _tmp302_;
	char* result;
	DBusMessage* reply;
	const char* _tmp303_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp302_);
	dbus_message_iter_next (&iter);
	mode = g_strdup (_tmp302_);
	result = unit_stop (self, mode, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (mode);
	_tmp303_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp303_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unit_restart (Unit* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* mode = NULL;
	const char* _tmp304_;
	char* result;
	DBusMessage* reply;
	const char* _tmp305_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp304_);
	dbus_message_iter_next (&iter);
	mode = g_strdup (_tmp304_);
	result = unit_restart (self, mode, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (mode);
	_tmp305_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp305_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_unit_reload (Unit* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* mode = NULL;
	const char* _tmp306_;
	char* result;
	DBusMessage* reply;
	const char* _tmp307_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp306_);
	dbus_message_iter_next (&iter);
	mode = g_strdup (_tmp306_);
	result = unit_reload (self, mode, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (mode);
	_tmp307_ = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_OBJECT_PATH, &_tmp307_);
	_g_free0 (result);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult unit_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_unit_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_unit_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_unit_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Unit", "Start")) {
		result = _dbus_unit_start (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Unit", "Stop")) {
		result = _dbus_unit_stop (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Unit", "Restart")) {
		result = _dbus_unit_restart (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Unit", "Reload")) {
		result = _dbus_unit_reload (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_unit_changed (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.systemd1.Unit", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void unit_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_unit_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_unit_changed, connection);
}


static void unit_base_init (UnitIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("names", "names", "names", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("requires", "requires", "requires", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("requires-overridable", "requires-overridable", "requires-overridable", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("requisite", "requisite", "requisite", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("requisite-overridable", "requisite-overridable", "requisite-overridable", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("wants", "wants", "wants", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("required-by", "required-by", "required-by", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("required-by-overridable", "required-by-overridable", "required-by-overridable", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("wanted-by", "wanted-by", "wanted-by", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("conflicts", "conflicts", "conflicts", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("before", "before", "before", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("after", "after", "after", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("description", "description", "description", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("load-state", "load-state", "load-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("active-state", "active-state", "active-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("sub-state", "sub-state", "sub-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("fragment-path", "fragment-path", "fragment-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_uint64 ("inactive-exit-timestamp", "inactive-exit-timestamp", "inactive-exit-timestamp", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_uint64 ("active-enter-timestamp", "active-enter-timestamp", "active-enter-timestamp", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_uint64 ("active-exit-timestamp", "active-exit-timestamp", "active-exit-timestamp", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_uint64 ("inactive-enter-timestamp", "inactive-enter-timestamp", "inactive-enter-timestamp", 0, G_MAXUINT64, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("can-start", "can-start", "can-start", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("can-reload", "can-reload", "can-reload", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("job", "job", "job", UNIT_TYPE_JOB_LINK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("recursive-stop", "recursive-stop", "recursive-stop", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boolean ("stop-when-unneeded", "stop-when-unneeded", "stop-when-unneeded", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("default-control-group", "default-control-group", "default-control-group", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("control-groups", "control-groups", "control-groups", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("changed", TYPE_UNIT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_type_set_qdata (TYPE_UNIT, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_unit_dbus_vtable));
	}
}


GType unit_get_type (void) {
	static volatile gsize unit_type_id__volatile = 0;
	if (g_once_init_enter (&unit_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitIface), (GBaseInitFunc) unit_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unit_type_id;
		unit_type_id = g_type_register_static (G_TYPE_INTERFACE, "Unit", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unit_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (unit_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &unit_dbus_proxy_get_type);
		g_once_init_leave (&unit_type_id__volatile, unit_type_id);
	}
	return unit_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnitDBusProxy, unit_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_UNIT, unit_dbus_proxy_unit__interface_init) );
Unit* unit_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Unit* self;
	self = g_object_new (unit_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.systemd1.Unit", NULL);
	return self;
}


static GObject* unit_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (unit_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), unit_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_unit_changed (Unit* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "changed");
}


DBusHandlerResult unit_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.systemd1.Unit", "Changed")) {
			_dbus_handle_unit_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void unit_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((UnitDBusProxy*) self)->disposed) {
		return;
	}
	((UnitDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), unit_dbus_proxy_filter, self);
	G_OBJECT_CLASS (unit_dbus_proxy_parent_class)->dispose (self);
}


static void unit_dbus_proxy_class_init (UnitDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = unit_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = unit_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = unit_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = unit_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_ID, "id");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_NAMES, "names");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_REQUIRES, "requires");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_REQUIRES_OVERRIDABLE, "requires-overridable");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_REQUISITE, "requisite");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_REQUISITE_OVERRIDABLE, "requisite-overridable");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_WANTS, "wants");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_REQUIRED_BY, "required-by");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_REQUIRED_BY_OVERRIDABLE, "required-by-overridable");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_WANTED_BY, "wanted-by");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_CONFLICTS, "conflicts");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_BEFORE, "before");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_AFTER, "after");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_DESCRIPTION, "description");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_LOAD_STATE, "load-state");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_ACTIVE_STATE, "active-state");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_SUB_STATE, "sub-state");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_FRAGMENT_PATH, "fragment-path");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_INACTIVE_EXIT_TIMESTAMP, "inactive-exit-timestamp");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_ACTIVE_ENTER_TIMESTAMP, "active-enter-timestamp");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_ACTIVE_EXIT_TIMESTAMP, "active-exit-timestamp");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_INACTIVE_ENTER_TIMESTAMP, "inactive-enter-timestamp");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_CAN_START, "can-start");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_CAN_RELOAD, "can-reload");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_JOB, "job");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_RECURSIVE_STOP, "recursive-stop");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_STOP_WHEN_UNNEEDED, "stop-when-unneeded");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_DEFAULT_CONTROL_GROUP, "default-control-group");
	g_object_class_override_property (G_OBJECT_CLASS (klass), UNIT_DBUS_PROXY_CONTROL_GROUPS, "control-groups");
}


static void unit_dbus_proxy_init (UnitDBusProxy* self) {
}


static char* unit_dbus_proxy_start (Unit* self, const char* mode, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp308_;
	char* _result;
	const char* _tmp309_;
	if (((UnitDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Unit", "Start");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp308_ = mode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp308_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp310_;
			_edomain = DBUS_GERROR;
			_tmp310_ = _dbus_error.name + 27;
			if (strcmp (_tmp310_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp310_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp310_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp310_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp310_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp310_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp310_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp310_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp310_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp310_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp310_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp310_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp310_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp310_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp310_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp310_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp310_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp310_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp310_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp310_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp310_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp310_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp310_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp310_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp310_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp310_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp310_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp310_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp310_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp310_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp310_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp310_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp310_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp309_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp309_);
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_stop (Unit* self, const char* mode, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp311_;
	char* _result;
	const char* _tmp312_;
	if (((UnitDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Unit", "Stop");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp311_ = mode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp311_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp313_;
			_edomain = DBUS_GERROR;
			_tmp313_ = _dbus_error.name + 27;
			if (strcmp (_tmp313_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp313_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp313_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp313_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp313_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp313_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp313_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp313_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp313_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp313_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp313_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp313_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp313_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp313_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp313_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp313_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp313_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp313_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp313_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp313_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp313_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp313_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp313_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp313_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp313_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp313_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp313_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp313_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp313_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp313_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp313_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp313_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp313_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp312_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp312_);
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_restart (Unit* self, const char* mode, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp314_;
	char* _result;
	const char* _tmp315_;
	if (((UnitDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Unit", "Restart");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp314_ = mode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp314_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp316_;
			_edomain = DBUS_GERROR;
			_tmp316_ = _dbus_error.name + 27;
			if (strcmp (_tmp316_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp316_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp316_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp316_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp316_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp316_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp316_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp316_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp316_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp316_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp316_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp316_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp316_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp316_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp316_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp316_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp316_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp316_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp316_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp316_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp316_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp316_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp316_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp316_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp316_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp316_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp316_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp316_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp316_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp316_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp316_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp316_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp316_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp315_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp315_);
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_reload (Unit* self, const char* mode, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp317_;
	char* _result;
	const char* _tmp318_;
	if (((UnitDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Unit", "Reload");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp317_ = mode;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp317_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp319_;
			_edomain = DBUS_GERROR;
			_tmp319_ = _dbus_error.name + 27;
			if (strcmp (_tmp319_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp319_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp319_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp319_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp319_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp319_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp319_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp319_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp319_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp319_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp319_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp319_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp319_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp319_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp319_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp319_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp319_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp319_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp319_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp319_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp319_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp319_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp319_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp319_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp319_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp319_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp319_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp319_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp319_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp319_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp319_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp319_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp319_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "o")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "o", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp318_);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp318_);
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_get_id (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp320_;
	const char* _tmp321_;
	char* _result;
	const char* _tmp322_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp320_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp320_);
	_tmp321_ = "Id";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp321_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp322_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp322_);
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_names (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp323_;
	const char* _tmp324_;
	char** _result;
	int _result_length1;
	char** _tmp325_;
	int _tmp325__length;
	int _tmp325__size;
	int _tmp325__length1;
	DBusMessageIter _tmp326_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp323_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp323_);
	_tmp324_ = "Names";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp324_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp325_ = g_new (char*, 5);
	_tmp325__length = 0;
	_tmp325__size = 4;
	_tmp325__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp326_);
	for (; dbus_message_iter_get_arg_type (&_tmp326_); _tmp325__length1++) {
		const char* _tmp327_;
		if (_tmp325__size == _tmp325__length) {
			_tmp325__size = 2 * _tmp325__size;
			_tmp325_ = g_renew (char*, _tmp325_, _tmp325__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp326_, &_tmp327_);
		dbus_message_iter_next (&_tmp326_);
		_tmp325_[_tmp325__length++] = g_strdup (_tmp327_);
	}
	_result_length1 = _tmp325__length1;
	_tmp325_[_tmp325__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp325_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_requires (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp328_;
	const char* _tmp329_;
	char** _result;
	int _result_length1;
	char** _tmp330_;
	int _tmp330__length;
	int _tmp330__size;
	int _tmp330__length1;
	DBusMessageIter _tmp331_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp328_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp328_);
	_tmp329_ = "Requires";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp329_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp330_ = g_new (char*, 5);
	_tmp330__length = 0;
	_tmp330__size = 4;
	_tmp330__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp331_);
	for (; dbus_message_iter_get_arg_type (&_tmp331_); _tmp330__length1++) {
		const char* _tmp332_;
		if (_tmp330__size == _tmp330__length) {
			_tmp330__size = 2 * _tmp330__size;
			_tmp330_ = g_renew (char*, _tmp330_, _tmp330__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp331_, &_tmp332_);
		dbus_message_iter_next (&_tmp331_);
		_tmp330_[_tmp330__length++] = g_strdup (_tmp332_);
	}
	_result_length1 = _tmp330__length1;
	_tmp330_[_tmp330__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp330_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_requires_overridable (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp333_;
	const char* _tmp334_;
	char** _result;
	int _result_length1;
	char** _tmp335_;
	int _tmp335__length;
	int _tmp335__size;
	int _tmp335__length1;
	DBusMessageIter _tmp336_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp333_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp333_);
	_tmp334_ = "RequiresOverridable";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp334_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp335_ = g_new (char*, 5);
	_tmp335__length = 0;
	_tmp335__size = 4;
	_tmp335__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp336_);
	for (; dbus_message_iter_get_arg_type (&_tmp336_); _tmp335__length1++) {
		const char* _tmp337_;
		if (_tmp335__size == _tmp335__length) {
			_tmp335__size = 2 * _tmp335__size;
			_tmp335_ = g_renew (char*, _tmp335_, _tmp335__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp336_, &_tmp337_);
		dbus_message_iter_next (&_tmp336_);
		_tmp335_[_tmp335__length++] = g_strdup (_tmp337_);
	}
	_result_length1 = _tmp335__length1;
	_tmp335_[_tmp335__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp335_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_requisite (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp338_;
	const char* _tmp339_;
	char** _result;
	int _result_length1;
	char** _tmp340_;
	int _tmp340__length;
	int _tmp340__size;
	int _tmp340__length1;
	DBusMessageIter _tmp341_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp338_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp338_);
	_tmp339_ = "Requisite";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp339_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp340_ = g_new (char*, 5);
	_tmp340__length = 0;
	_tmp340__size = 4;
	_tmp340__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp341_);
	for (; dbus_message_iter_get_arg_type (&_tmp341_); _tmp340__length1++) {
		const char* _tmp342_;
		if (_tmp340__size == _tmp340__length) {
			_tmp340__size = 2 * _tmp340__size;
			_tmp340_ = g_renew (char*, _tmp340_, _tmp340__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp341_, &_tmp342_);
		dbus_message_iter_next (&_tmp341_);
		_tmp340_[_tmp340__length++] = g_strdup (_tmp342_);
	}
	_result_length1 = _tmp340__length1;
	_tmp340_[_tmp340__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp340_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_requisite_overridable (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp343_;
	const char* _tmp344_;
	char** _result;
	int _result_length1;
	char** _tmp345_;
	int _tmp345__length;
	int _tmp345__size;
	int _tmp345__length1;
	DBusMessageIter _tmp346_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp343_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp343_);
	_tmp344_ = "RequisiteOverridable";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp344_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp345_ = g_new (char*, 5);
	_tmp345__length = 0;
	_tmp345__size = 4;
	_tmp345__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp346_);
	for (; dbus_message_iter_get_arg_type (&_tmp346_); _tmp345__length1++) {
		const char* _tmp347_;
		if (_tmp345__size == _tmp345__length) {
			_tmp345__size = 2 * _tmp345__size;
			_tmp345_ = g_renew (char*, _tmp345_, _tmp345__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp346_, &_tmp347_);
		dbus_message_iter_next (&_tmp346_);
		_tmp345_[_tmp345__length++] = g_strdup (_tmp347_);
	}
	_result_length1 = _tmp345__length1;
	_tmp345_[_tmp345__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp345_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_wants (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp348_;
	const char* _tmp349_;
	char** _result;
	int _result_length1;
	char** _tmp350_;
	int _tmp350__length;
	int _tmp350__size;
	int _tmp350__length1;
	DBusMessageIter _tmp351_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp348_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp348_);
	_tmp349_ = "Wants";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp349_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp350_ = g_new (char*, 5);
	_tmp350__length = 0;
	_tmp350__size = 4;
	_tmp350__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp351_);
	for (; dbus_message_iter_get_arg_type (&_tmp351_); _tmp350__length1++) {
		const char* _tmp352_;
		if (_tmp350__size == _tmp350__length) {
			_tmp350__size = 2 * _tmp350__size;
			_tmp350_ = g_renew (char*, _tmp350_, _tmp350__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp351_, &_tmp352_);
		dbus_message_iter_next (&_tmp351_);
		_tmp350_[_tmp350__length++] = g_strdup (_tmp352_);
	}
	_result_length1 = _tmp350__length1;
	_tmp350_[_tmp350__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp350_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_required_by (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp353_;
	const char* _tmp354_;
	char** _result;
	int _result_length1;
	char** _tmp355_;
	int _tmp355__length;
	int _tmp355__size;
	int _tmp355__length1;
	DBusMessageIter _tmp356_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp353_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp353_);
	_tmp354_ = "RequiredBy";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp354_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp355_ = g_new (char*, 5);
	_tmp355__length = 0;
	_tmp355__size = 4;
	_tmp355__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp356_);
	for (; dbus_message_iter_get_arg_type (&_tmp356_); _tmp355__length1++) {
		const char* _tmp357_;
		if (_tmp355__size == _tmp355__length) {
			_tmp355__size = 2 * _tmp355__size;
			_tmp355_ = g_renew (char*, _tmp355_, _tmp355__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp356_, &_tmp357_);
		dbus_message_iter_next (&_tmp356_);
		_tmp355_[_tmp355__length++] = g_strdup (_tmp357_);
	}
	_result_length1 = _tmp355__length1;
	_tmp355_[_tmp355__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp355_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_required_by_overridable (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp358_;
	const char* _tmp359_;
	char** _result;
	int _result_length1;
	char** _tmp360_;
	int _tmp360__length;
	int _tmp360__size;
	int _tmp360__length1;
	DBusMessageIter _tmp361_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp358_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp358_);
	_tmp359_ = "RequiredByOverridable";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp359_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp360_ = g_new (char*, 5);
	_tmp360__length = 0;
	_tmp360__size = 4;
	_tmp360__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp361_);
	for (; dbus_message_iter_get_arg_type (&_tmp361_); _tmp360__length1++) {
		const char* _tmp362_;
		if (_tmp360__size == _tmp360__length) {
			_tmp360__size = 2 * _tmp360__size;
			_tmp360_ = g_renew (char*, _tmp360_, _tmp360__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp361_, &_tmp362_);
		dbus_message_iter_next (&_tmp361_);
		_tmp360_[_tmp360__length++] = g_strdup (_tmp362_);
	}
	_result_length1 = _tmp360__length1;
	_tmp360_[_tmp360__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp360_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_wanted_by (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp363_;
	const char* _tmp364_;
	char** _result;
	int _result_length1;
	char** _tmp365_;
	int _tmp365__length;
	int _tmp365__size;
	int _tmp365__length1;
	DBusMessageIter _tmp366_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp363_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp363_);
	_tmp364_ = "WantedBy";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp364_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp365_ = g_new (char*, 5);
	_tmp365__length = 0;
	_tmp365__size = 4;
	_tmp365__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp366_);
	for (; dbus_message_iter_get_arg_type (&_tmp366_); _tmp365__length1++) {
		const char* _tmp367_;
		if (_tmp365__size == _tmp365__length) {
			_tmp365__size = 2 * _tmp365__size;
			_tmp365_ = g_renew (char*, _tmp365_, _tmp365__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp366_, &_tmp367_);
		dbus_message_iter_next (&_tmp366_);
		_tmp365_[_tmp365__length++] = g_strdup (_tmp367_);
	}
	_result_length1 = _tmp365__length1;
	_tmp365_[_tmp365__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp365_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_conflicts (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp368_;
	const char* _tmp369_;
	char** _result;
	int _result_length1;
	char** _tmp370_;
	int _tmp370__length;
	int _tmp370__size;
	int _tmp370__length1;
	DBusMessageIter _tmp371_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp368_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp368_);
	_tmp369_ = "Conflicts";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp369_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp370_ = g_new (char*, 5);
	_tmp370__length = 0;
	_tmp370__size = 4;
	_tmp370__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp371_);
	for (; dbus_message_iter_get_arg_type (&_tmp371_); _tmp370__length1++) {
		const char* _tmp372_;
		if (_tmp370__size == _tmp370__length) {
			_tmp370__size = 2 * _tmp370__size;
			_tmp370_ = g_renew (char*, _tmp370_, _tmp370__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp371_, &_tmp372_);
		dbus_message_iter_next (&_tmp371_);
		_tmp370_[_tmp370__length++] = g_strdup (_tmp372_);
	}
	_result_length1 = _tmp370__length1;
	_tmp370_[_tmp370__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp370_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_before (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp373_;
	const char* _tmp374_;
	char** _result;
	int _result_length1;
	char** _tmp375_;
	int _tmp375__length;
	int _tmp375__size;
	int _tmp375__length1;
	DBusMessageIter _tmp376_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp373_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp373_);
	_tmp374_ = "Before";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp374_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp375_ = g_new (char*, 5);
	_tmp375__length = 0;
	_tmp375__size = 4;
	_tmp375__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp376_);
	for (; dbus_message_iter_get_arg_type (&_tmp376_); _tmp375__length1++) {
		const char* _tmp377_;
		if (_tmp375__size == _tmp375__length) {
			_tmp375__size = 2 * _tmp375__size;
			_tmp375_ = g_renew (char*, _tmp375_, _tmp375__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp376_, &_tmp377_);
		dbus_message_iter_next (&_tmp376_);
		_tmp375_[_tmp375__length++] = g_strdup (_tmp377_);
	}
	_result_length1 = _tmp375__length1;
	_tmp375_[_tmp375__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp375_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_after (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp378_;
	const char* _tmp379_;
	char** _result;
	int _result_length1;
	char** _tmp380_;
	int _tmp380__length;
	int _tmp380__size;
	int _tmp380__length1;
	DBusMessageIter _tmp381_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp378_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp378_);
	_tmp379_ = "After";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp379_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp380_ = g_new (char*, 5);
	_tmp380__length = 0;
	_tmp380__size = 4;
	_tmp380__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp381_);
	for (; dbus_message_iter_get_arg_type (&_tmp381_); _tmp380__length1++) {
		const char* _tmp382_;
		if (_tmp380__size == _tmp380__length) {
			_tmp380__size = 2 * _tmp380__size;
			_tmp380_ = g_renew (char*, _tmp380_, _tmp380__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp381_, &_tmp382_);
		dbus_message_iter_next (&_tmp381_);
		_tmp380_[_tmp380__length++] = g_strdup (_tmp382_);
	}
	_result_length1 = _tmp380__length1;
	_tmp380_[_tmp380__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp380_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_get_description (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp383_;
	const char* _tmp384_;
	char* _result;
	const char* _tmp385_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp383_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp383_);
	_tmp384_ = "Description";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp384_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp385_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp385_);
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_get_load_state (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp386_;
	const char* _tmp387_;
	char* _result;
	const char* _tmp388_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp386_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp386_);
	_tmp387_ = "LoadState";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp387_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp388_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp388_);
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_get_active_state (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp389_;
	const char* _tmp390_;
	char* _result;
	const char* _tmp391_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp389_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp389_);
	_tmp390_ = "ActiveState";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp390_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp391_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp391_);
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_get_sub_state (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp392_;
	const char* _tmp393_;
	char* _result;
	const char* _tmp394_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp392_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp392_);
	_tmp393_ = "SubState";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp393_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp394_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp394_);
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_get_fragment_path (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp395_;
	const char* _tmp396_;
	char* _result;
	const char* _tmp397_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp395_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp395_);
	_tmp396_ = "FragmentPath";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp396_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp397_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp397_);
	dbus_message_unref (_reply);
	return _result;
}


static guint64 unit_dbus_proxy_get_inactive_exit_timestamp (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp398_;
	const char* _tmp399_;
	guint64 _result;
	dbus_uint64_t _tmp400_;
	if (((UnitDBusProxy*) self)->disposed) {
		return 0ULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp398_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp398_);
	_tmp399_ = "InactiveExitTimestamp";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp399_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0ULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0ULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "t")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "t", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0ULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp400_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp400_;
	dbus_message_unref (_reply);
	return _result;
}


static guint64 unit_dbus_proxy_get_active_enter_timestamp (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp401_;
	const char* _tmp402_;
	guint64 _result;
	dbus_uint64_t _tmp403_;
	if (((UnitDBusProxy*) self)->disposed) {
		return 0ULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp401_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp401_);
	_tmp402_ = "ActiveEnterTimestamp";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp402_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0ULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0ULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "t")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "t", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0ULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp403_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp403_;
	dbus_message_unref (_reply);
	return _result;
}


static guint64 unit_dbus_proxy_get_active_exit_timestamp (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp404_;
	const char* _tmp405_;
	guint64 _result;
	dbus_uint64_t _tmp406_;
	if (((UnitDBusProxy*) self)->disposed) {
		return 0ULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp404_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp404_);
	_tmp405_ = "ActiveExitTimestamp";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp405_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0ULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0ULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "t")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "t", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0ULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp406_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp406_;
	dbus_message_unref (_reply);
	return _result;
}


static guint64 unit_dbus_proxy_get_inactive_enter_timestamp (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp407_;
	const char* _tmp408_;
	guint64 _result;
	dbus_uint64_t _tmp409_;
	if (((UnitDBusProxy*) self)->disposed) {
		return 0ULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp407_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp407_);
	_tmp408_ = "InactiveEnterTimestamp";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp408_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0ULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0ULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "t")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "t", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0ULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp409_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp409_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean unit_dbus_proxy_get_can_start (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp410_;
	const char* _tmp411_;
	gboolean _result;
	dbus_bool_t _tmp412_;
	if (((UnitDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp410_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp410_);
	_tmp411_ = "CanStart";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp411_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp412_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp412_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean unit_dbus_proxy_get_can_reload (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp413_;
	const char* _tmp414_;
	gboolean _result;
	dbus_bool_t _tmp415_;
	if (((UnitDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp413_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp413_);
	_tmp414_ = "CanReload";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp414_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp415_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp415_;
	dbus_message_unref (_reply);
	return _result;
}


static void unit_dbus_proxy_get_job (Unit* self, UnitJobLink* result) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp416_;
	const char* _tmp417_;
	UnitJobLink _tmp418_;
	DBusMessageIter _tmp419_;
	dbus_uint32_t _tmp420_;
	const char* _tmp421_;
	if (((UnitDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp416_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp416_);
	_tmp417_ = "Job";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp417_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "(uo)")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "(uo)", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_recurse (&_subiter, &_tmp419_);
	dbus_message_iter_get_basic (&_tmp419_, &_tmp420_);
	dbus_message_iter_next (&_tmp419_);
	_tmp418_.id = _tmp420_;
	dbus_message_iter_get_basic (&_tmp419_, &_tmp421_);
	dbus_message_iter_next (&_tmp419_);
	_tmp418_.path = g_strdup (_tmp421_);
	dbus_message_iter_next (&_subiter);
	*result = _tmp418_;
	dbus_message_unref (_reply);
	return;
}


static gboolean unit_dbus_proxy_get_recursive_stop (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp422_;
	const char* _tmp423_;
	gboolean _result;
	dbus_bool_t _tmp424_;
	if (((UnitDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp422_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp422_);
	_tmp423_ = "RecursiveStop";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp423_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp424_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp424_;
	dbus_message_unref (_reply);
	return _result;
}


static gboolean unit_dbus_proxy_get_stop_when_unneeded (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp425_;
	const char* _tmp426_;
	gboolean _result;
	dbus_bool_t _tmp427_;
	if (((UnitDBusProxy*) self)->disposed) {
		return FALSE;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp425_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp425_);
	_tmp426_ = "StopWhenUnneeded";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp426_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return FALSE;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "b")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "b", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return FALSE;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp427_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp427_;
	dbus_message_unref (_reply);
	return _result;
}


static char* unit_dbus_proxy_get_default_control_group (Unit* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp428_;
	const char* _tmp429_;
	char* _result;
	const char* _tmp430_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp428_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp428_);
	_tmp429_ = "DefaultControlGroup";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp429_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp430_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp430_);
	dbus_message_unref (_reply);
	return _result;
}


static char** unit_dbus_proxy_get_control_groups (Unit* self, int* result_length1) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp431_;
	const char* _tmp432_;
	char** _result;
	int _result_length1;
	char** _tmp433_;
	int _tmp433__length;
	int _tmp433__size;
	int _tmp433__length1;
	DBusMessageIter _tmp434_;
	if (((UnitDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp431_ = "org.freedesktop.systemd1.Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp431_);
	_tmp432_ = "ControlGroups";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp432_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "as")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "as", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	_result_length1 = 0;
	_tmp433_ = g_new (char*, 5);
	_tmp433__length = 0;
	_tmp433__size = 4;
	_tmp433__length1 = 0;
	dbus_message_iter_recurse (&_subiter, &_tmp434_);
	for (; dbus_message_iter_get_arg_type (&_tmp434_); _tmp433__length1++) {
		const char* _tmp435_;
		if (_tmp433__size == _tmp433__length) {
			_tmp433__size = 2 * _tmp433__size;
			_tmp433_ = g_renew (char*, _tmp433_, _tmp433__size + 1);
		}
		dbus_message_iter_get_basic (&_tmp434_, &_tmp435_);
		dbus_message_iter_next (&_tmp434_);
		_tmp433_[_tmp433__length++] = g_strdup (_tmp435_);
	}
	_result_length1 = _tmp433__length1;
	_tmp433_[_tmp433__length] = NULL;
	dbus_message_iter_next (&_subiter);
	_result = _tmp433_;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static void unit_dbus_proxy_unit__interface_init (UnitIface* iface) {
	iface->start = unit_dbus_proxy_start;
	iface->stop = unit_dbus_proxy_stop;
	iface->restart = unit_dbus_proxy_restart;
	iface->reload = unit_dbus_proxy_reload;
	iface->get_id = unit_dbus_proxy_get_id;
	iface->get_names = unit_dbus_proxy_get_names;
	iface->get_requires = unit_dbus_proxy_get_requires;
	iface->get_requires_overridable = unit_dbus_proxy_get_requires_overridable;
	iface->get_requisite = unit_dbus_proxy_get_requisite;
	iface->get_requisite_overridable = unit_dbus_proxy_get_requisite_overridable;
	iface->get_wants = unit_dbus_proxy_get_wants;
	iface->get_required_by = unit_dbus_proxy_get_required_by;
	iface->get_required_by_overridable = unit_dbus_proxy_get_required_by_overridable;
	iface->get_wanted_by = unit_dbus_proxy_get_wanted_by;
	iface->get_conflicts = unit_dbus_proxy_get_conflicts;
	iface->get_before = unit_dbus_proxy_get_before;
	iface->get_after = unit_dbus_proxy_get_after;
	iface->get_description = unit_dbus_proxy_get_description;
	iface->get_load_state = unit_dbus_proxy_get_load_state;
	iface->get_active_state = unit_dbus_proxy_get_active_state;
	iface->get_sub_state = unit_dbus_proxy_get_sub_state;
	iface->get_fragment_path = unit_dbus_proxy_get_fragment_path;
	iface->get_inactive_exit_timestamp = unit_dbus_proxy_get_inactive_exit_timestamp;
	iface->get_active_enter_timestamp = unit_dbus_proxy_get_active_enter_timestamp;
	iface->get_active_exit_timestamp = unit_dbus_proxy_get_active_exit_timestamp;
	iface->get_inactive_enter_timestamp = unit_dbus_proxy_get_inactive_enter_timestamp;
	iface->get_can_start = unit_dbus_proxy_get_can_start;
	iface->get_can_reload = unit_dbus_proxy_get_can_reload;
	iface->get_job = unit_dbus_proxy_get_job;
	iface->get_recursive_stop = unit_dbus_proxy_get_recursive_stop;
	iface->get_stop_when_unneeded = unit_dbus_proxy_get_stop_when_unneeded;
	iface->get_default_control_group = unit_dbus_proxy_get_default_control_group;
	iface->get_control_groups = unit_dbus_proxy_get_control_groups;
}


static void unit_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void unit_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


#line 139 "systemd-interfaces.vala"
void job_cancel (Job* self, GError** error) {
#line 139 "systemd-interfaces.vala"
	JOB_GET_INTERFACE (self)->cancel (self, error);
#line 10465 "systemd-interfaces.c"
}


guint32 job_get_id (Job* self) {
	return JOB_GET_INTERFACE (self)->get_id (self);
}


char* job_get_state (Job* self) {
	return JOB_GET_INTERFACE (self)->get_state (self);
}


char* job_get_job_type (Job* self) {
	return JOB_GET_INTERFACE (self)->get_job_type (self);
}


void job_get_unit (Job* self, JobUnitLink* result) {
	JOB_GET_INTERFACE (self)->get_unit (self, result);
}


void job_unit_link_copy (const JobUnitLink* self, JobUnitLink* dest) {
	dest->id = g_strdup (self->id);
	dest->path = g_strdup (self->path);
}


void job_unit_link_destroy (JobUnitLink* self) {
	_g_free0 (self->id);
	_g_free0 (self->path);
}


JobUnitLink* job_unit_link_dup (const JobUnitLink* self) {
	JobUnitLink* dup;
	dup = g_new0 (JobUnitLink, 1);
	job_unit_link_copy (self, dup);
	return dup;
}


void job_unit_link_free (JobUnitLink* self) {
	job_unit_link_destroy (self);
	g_free (self);
}


GType job_unit_link_get_type (void) {
	static volatile gsize job_unit_link_type_id__volatile = 0;
	if (g_once_init_enter (&job_unit_link_type_id__volatile)) {
		GType job_unit_link_type_id;
		job_unit_link_type_id = g_boxed_type_register_static ("JobUnitLink", (GBoxedCopyFunc) job_unit_link_dup, (GBoxedFreeFunc) job_unit_link_free);
		g_once_init_leave (&job_unit_link_type_id__volatile, job_unit_link_type_id);
	}
	return job_unit_link_type_id__volatile;
}


void _job_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_job_introspect (Job* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.systemd1.Job\">\n  <method name=\"Cancel\">\n  </method>\n  <property name=\"Id\" type=\"u\" access=\"read\"/>\n  <property name=\"State\" type=\"s\" access=\"read\"/>\n  <property name=\"JobType\" type=\"s\" access=\"read\"/>\n  <property name=\"Unit\" type=\"(so)\" access=\"read\"/>\n  <signal name=\"Changed\">\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_job_property_get (Job* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp436_;
	char* property_name;
	const char* _tmp437_;
	if (strcmp (dbus_message_get_signature (message), "ss")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp436_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp436_);
	dbus_message_iter_get_basic (&iter, &_tmp437_);
	dbus_message_iter_next (&iter);
	property_name = g_strdup (_tmp437_);
	if ((strcmp (interface_name, "org.freedesktop.systemd1.Job") == 0) && (strcmp (property_name, "Id") == 0)) {
		guint32 result;
		dbus_uint32_t _tmp438_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "u", &subiter);
		result = job_get_id (self);
		_tmp438_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_UINT32, &_tmp438_);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Job") == 0) && (strcmp (property_name, "State") == 0)) {
		char* result;
		const char* _tmp439_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = job_get_state (self);
		_tmp439_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp439_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Job") == 0) && (strcmp (property_name, "JobType") == 0)) {
		char* result;
		const char* _tmp440_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "s", &subiter);
		result = job_get_job_type (self);
		_tmp440_ = result;
		dbus_message_iter_append_basic (&subiter, DBUS_TYPE_STRING, &_tmp440_);
		_g_free0 (result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else if ((strcmp (interface_name, "org.freedesktop.systemd1.Job") == 0) && (strcmp (property_name, "Unit") == 0)) {
		JobUnitLink result;
		DBusMessageIter _tmp441_;
		const char* _tmp442_;
		const char* _tmp443_;
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_VARIANT, "(so)", &subiter);
		job_get_unit (self, &result);
		dbus_message_iter_open_container (&subiter, DBUS_TYPE_STRUCT, NULL, &_tmp441_);
		_tmp442_ = result.id;
		dbus_message_iter_append_basic (&_tmp441_, DBUS_TYPE_STRING, &_tmp442_);
		_tmp443_ = result.path;
		dbus_message_iter_append_basic (&_tmp441_, DBUS_TYPE_OBJECT_PATH, &_tmp443_);
		dbus_message_iter_close_container (&subiter, &_tmp441_);
		job_unit_link_destroy (&result);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	g_free (property_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_job_property_get_all (Job* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter, entry_iter, value_iter;
	char* interface_name;
	const char* _tmp444_;
	const char* property_name;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp444_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp444_);
	if (strcmp (interface_name, "org.freedesktop.systemd1.Job") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		{
			guint32 result;
			dbus_uint32_t _tmp445_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Id";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "u", &value_iter);
			result = job_get_id (self);
			_tmp445_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_UINT32, &_tmp445_);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp446_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "State";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = job_get_state (self);
			_tmp446_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp446_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			char* result;
			const char* _tmp447_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "JobType";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "s", &value_iter);
			result = job_get_job_type (self);
			_tmp447_ = result;
			dbus_message_iter_append_basic (&value_iter, DBUS_TYPE_STRING, &_tmp447_);
			_g_free0 (result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		{
			JobUnitLink result;
			DBusMessageIter _tmp448_;
			const char* _tmp449_;
			const char* _tmp450_;
			dbus_message_iter_open_container (&subiter, DBUS_TYPE_DICT_ENTRY, NULL, &entry_iter);
			property_name = "Unit";
			dbus_message_iter_append_basic (&entry_iter, DBUS_TYPE_STRING, &property_name);
			dbus_message_iter_open_container (&entry_iter, DBUS_TYPE_VARIANT, "(so)", &value_iter);
			job_get_unit (self, &result);
			dbus_message_iter_open_container (&value_iter, DBUS_TYPE_STRUCT, NULL, &_tmp448_);
			_tmp449_ = result.id;
			dbus_message_iter_append_basic (&_tmp448_, DBUS_TYPE_STRING, &_tmp449_);
			_tmp450_ = result.path;
			dbus_message_iter_append_basic (&_tmp448_, DBUS_TYPE_OBJECT_PATH, &_tmp450_);
			dbus_message_iter_close_container (&value_iter, &_tmp448_);
			job_unit_link_destroy (&result);
			dbus_message_iter_close_container (&entry_iter, &value_iter);
			dbus_message_iter_close_container (&subiter, &entry_iter);
		}
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_job_cancel (Job* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	job_cancel (self, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult job_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_job_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "Get")) {
		result = _dbus_job_property_get (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_job_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.systemd1.Job", "Cancel")) {
		result = _dbus_job_cancel (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_job_changed (GObject* _sender, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.freedesktop.systemd1.Job", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void job_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_job_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_job_changed, connection);
}


static void job_base_init (JobIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_uint ("id", "id", "id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("state", "state", "state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_string ("job-type", "job-type", "job-type", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_object_interface_install_property (iface, g_param_spec_boxed ("unit", "unit", "unit", JOB_TYPE_UNIT_LINK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
		g_signal_new ("changed", TYPE_JOB, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_type_set_qdata (TYPE_JOB, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_job_dbus_vtable));
	}
}


GType job_get_type (void) {
	static volatile gsize job_type_id__volatile = 0;
	if (g_once_init_enter (&job_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (JobIface), (GBaseInitFunc) job_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType job_type_id;
		job_type_id = g_type_register_static (G_TYPE_INTERFACE, "Job", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (job_type_id, DBUS_TYPE_G_PROXY);
		g_type_set_qdata (job_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &job_dbus_proxy_get_type);
		g_once_init_leave (&job_type_id__volatile, job_type_id);
	}
	return job_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (JobDBusProxy, job_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_JOB, job_dbus_proxy_job__interface_init) );
Job* job_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Job* self;
	self = g_object_new (job_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.systemd1.Job", NULL);
	return self;
}


static GObject* job_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (job_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), job_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


static void _dbus_handle_job_changed (Job* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	g_signal_emit_by_name (self, "changed");
}


DBusHandlerResult job_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.freedesktop.systemd1.Job", "Changed")) {
			_dbus_handle_job_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void job_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((JobDBusProxy*) self)->disposed) {
		return;
	}
	((JobDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), job_dbus_proxy_filter, self);
	G_OBJECT_CLASS (job_dbus_proxy_parent_class)->dispose (self);
}


static void job_dbus_proxy_class_init (JobDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = job_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = job_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = job_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = job_dbus_proxy_set_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), JOB_DBUS_PROXY_ID, "id");
	g_object_class_override_property (G_OBJECT_CLASS (klass), JOB_DBUS_PROXY_STATE, "state");
	g_object_class_override_property (G_OBJECT_CLASS (klass), JOB_DBUS_PROXY_JOB_TYPE, "job-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), JOB_DBUS_PROXY_UNIT, "unit");
}


static void job_dbus_proxy_init (JobDBusProxy* self) {
}


static void job_dbus_proxy_cancel (Job* self, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	if (((JobDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.systemd1.Job", "Cancel");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp451_;
			_edomain = DBUS_GERROR;
			_tmp451_ = _dbus_error.name + 27;
			if (strcmp (_tmp451_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp451_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp451_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp451_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp451_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp451_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp451_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp451_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp451_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp451_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp451_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp451_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp451_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp451_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp451_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp451_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp451_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp451_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp451_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp451_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp451_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp451_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp451_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp451_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp451_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp451_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp451_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp451_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp451_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp451_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp451_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp451_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp451_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static guint32 job_dbus_proxy_get_id (Job* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp452_;
	const char* _tmp453_;
	guint32 _result;
	dbus_uint32_t _tmp454_;
	if (((JobDBusProxy*) self)->disposed) {
		return 0U;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp452_ = "org.freedesktop.systemd1.Job";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp452_);
	_tmp453_ = "Id";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp453_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return 0U;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "u")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "u", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return 0U;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp454_);
	dbus_message_iter_next (&_subiter);
	_result = _tmp454_;
	dbus_message_unref (_reply);
	return _result;
}


static char* job_dbus_proxy_get_state (Job* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp455_;
	const char* _tmp456_;
	char* _result;
	const char* _tmp457_;
	if (((JobDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp455_ = "org.freedesktop.systemd1.Job";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp455_);
	_tmp456_ = "State";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp456_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp457_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp457_);
	dbus_message_unref (_reply);
	return _result;
}


static char* job_dbus_proxy_get_job_type (Job* self) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp458_;
	const char* _tmp459_;
	char* _result;
	const char* _tmp460_;
	if (((JobDBusProxy*) self)->disposed) {
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp458_ = "org.freedesktop.systemd1.Job";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp458_);
	_tmp459_ = "JobType";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp459_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return NULL;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "s")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "s", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return NULL;
	}
	dbus_message_iter_get_basic (&_subiter, &_tmp460_);
	dbus_message_iter_next (&_subiter);
	_result = g_strdup (_tmp460_);
	dbus_message_unref (_reply);
	return _result;
}


static void job_dbus_proxy_get_unit (Job* self, JobUnitLink* result) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter, _subiter;
	const char* _tmp461_;
	const char* _tmp462_;
	JobUnitLink _tmp463_;
	DBusMessageIter _tmp464_;
	const char* _tmp465_;
	const char* _tmp466_;
	if (((JobDBusProxy*) self)->disposed) {
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.DBus.Properties", "Get");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp461_ = "org.freedesktop.systemd1.Job";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp461_);
	_tmp462_ = "Unit";
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp462_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s)", __FILE__, __LINE__, _dbus_error.message, _dbus_error.name);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "v")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "v", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_recurse (&_iter, &_subiter);
	if (strcmp (dbus_message_iter_get_signature (&_subiter), "(so)")) {
		g_critical ("file %s: line %d: Invalid signature, expected \"%s\", got \"%s\"", __FILE__, __LINE__, "(so)", dbus_message_iter_get_signature (&_subiter));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_recurse (&_subiter, &_tmp464_);
	dbus_message_iter_get_basic (&_tmp464_, &_tmp465_);
	dbus_message_iter_next (&_tmp464_);
	_tmp463_.id = g_strdup (_tmp465_);
	dbus_message_iter_get_basic (&_tmp464_, &_tmp466_);
	dbus_message_iter_next (&_tmp464_);
	_tmp463_.path = g_strdup (_tmp466_);
	dbus_message_iter_next (&_subiter);
	*result = _tmp463_;
	dbus_message_unref (_reply);
	return;
}


static void job_dbus_proxy_job__interface_init (JobIface* iface) {
	iface->cancel = job_dbus_proxy_cancel;
	iface->get_id = job_dbus_proxy_get_id;
	iface->get_state = job_dbus_proxy_get_state;
	iface->get_job_type = job_dbus_proxy_get_job_type;
	iface->get_unit = job_dbus_proxy_get_unit;
}


static void job_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void job_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__STRING_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_BOXED) (gpointer data1, guint32 arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__UINT_BOXED_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_BOXED_BOOLEAN) (gpointer data1, guint32 arg_1, gpointer arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_boolean (param_values + 3), data2);
}



