/* systemadm.c generated by valac, the Vala compiler
 * generated from systemadm.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <time.h>


#define TYPE_LEFT_LABEL (left_label_get_type ())
#define LEFT_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEFT_LABEL, LeftLabel))
#define LEFT_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEFT_LABEL, LeftLabelClass))
#define IS_LEFT_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEFT_LABEL))
#define IS_LEFT_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEFT_LABEL))
#define LEFT_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEFT_LABEL, LeftLabelClass))

typedef struct _LeftLabel LeftLabel;
typedef struct _LeftLabelClass LeftLabelClass;
typedef struct _LeftLabelPrivate LeftLabelPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_RIGHT_LABEL (right_label_get_type ())
#define RIGHT_LABEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RIGHT_LABEL, RightLabel))
#define RIGHT_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RIGHT_LABEL, RightLabelClass))
#define IS_RIGHT_LABEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RIGHT_LABEL))
#define IS_RIGHT_LABEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RIGHT_LABEL))
#define RIGHT_LABEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RIGHT_LABEL, RightLabelClass))

typedef struct _RightLabel RightLabel;
typedef struct _RightLabelClass RightLabelClass;
typedef struct _RightLabelPrivate RightLabelPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MANAGER (manager_get_type ())
#define MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MANAGER, Manager))
#define IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MANAGER))
#define MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MANAGER, ManagerIface))

typedef struct _Manager Manager;
typedef struct _ManagerIface ManagerIface;

#define MANAGER_TYPE_UNIT_INFO (manager_unit_info_get_type ())
typedef struct _ManagerUnitInfo ManagerUnitInfo;

#define MANAGER_TYPE_JOB_INFO (manager_job_info_get_type ())
typedef struct _ManagerJobInfo ManagerJobInfo;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))

#define TYPE_UNIT (unit_get_type ())
#define UNIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNIT, Unit))
#define IS_UNIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNIT))
#define UNIT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_UNIT, UnitIface))

typedef struct _Unit Unit;
typedef struct _UnitIface UnitIface;

#define UNIT_TYPE_JOB_LINK (unit_job_link_get_type ())
typedef struct _UnitJobLink UnitJobLink;

#define TYPE_JOB (job_get_type ())
#define JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_JOB, Job))
#define IS_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_JOB))
#define JOB_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_JOB, JobIface))

typedef struct _Job Job;
typedef struct _JobIface JobIface;

#define JOB_TYPE_UNIT_LINK (job_unit_link_get_type ())
typedef struct _JobUnitLink JobUnitLink;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _LeftLabel {
	GtkLabel parent_instance;
	LeftLabelPrivate * priv;
};

struct _LeftLabelClass {
	GtkLabelClass parent_class;
};

struct _RightLabel {
	GtkLabel parent_instance;
	RightLabelPrivate * priv;
};

struct _RightLabelClass {
	GtkLabelClass parent_class;
};

struct _MainWindow {
	GtkWindow parent_instance;
	MainWindowPrivate * priv;
};

struct _MainWindowClass {
	GtkWindowClass parent_class;
};

struct _ManagerUnitInfo {
	char* id;
	char* description;
	char* load_state;
	char* active_state;
	char* sub_state;
	char* unit_path;
	guint32 job_id;
	char* job_type;
	char* job_path;
};

struct _ManagerJobInfo {
	guint32 id;
	char* name;
	char* type;
	char* state;
	char* job_path;
	char* unit_path;
};

struct _ManagerIface {
	GTypeInterface parent_iface;
	ManagerUnitInfo* (*list_units) (Manager* self, int* result_length1, GError** error);
	ManagerJobInfo* (*list_jobs) (Manager* self, int* result_length1, GError** error);
	char* (*get_unit) (Manager* self, const char* name, GError** error);
	char* (*load_unit) (Manager* self, const char* name, GError** error);
	char* (*get_job) (Manager* self, guint32 id, GError** error);
	char* (*start_unit) (Manager* self, const char* name, const char* mode, GError** error);
	char* (*stop_unit) (Manager* self, const char* name, const char* mode, GError** error);
	char* (*reload_unit) (Manager* self, const char* name, const char* mode, GError** error);
	char* (*restart_unit) (Manager* self, const char* name, const char* mode, GError** error);
	void (*clear_jobs) (Manager* self, GError** error);
	void (*subscribe) (Manager* self, GError** error);
	void (*unsubscribe) (Manager* self, GError** error);
	char* (*dump) (Manager* self, GError** error);
	void (*reload) (Manager* self, GError** error);
	void (*reexecute) (Manager* self, GError** error);
	void (*exit) (Manager* self, GError** error);
	char* (*create_snapshot) (Manager* self, const char* name, gboolean cleanup, GError** error);
	void (*set_environment) (Manager* self, char** names, int names_length1, GError** error);
	void (*unset_environment) (Manager* self, char** names, int names_length1, GError** error);
	char** (*get_environment) (Manager* self, int* result_length1);
};

struct _MainWindowPrivate {
	char* current_unit_id;
	guint32 current_job_id;
	GtkTreeView* unit_view;
	GtkTreeView* job_view;
	GtkListStore* unit_model;
	GtkListStore* job_model;
	GtkButton* start_button;
	GtkButton* stop_button;
	GtkButton* restart_button;
	GtkButton* reload_button;
	GtkButton* cancel_button;
	GtkEntry* unit_load_entry;
	GtkButton* unit_load_button;
	GtkButton* server_snapshot_button;
	GtkButton* server_reload_button;
	DBusGConnection* bus;
	Manager* manager;
	RightLabel* unit_id_label;
	RightLabel* unit_aliases_label;
	RightLabel* unit_dependency_label;
	RightLabel* unit_description_label;
	RightLabel* unit_load_state_label;
	RightLabel* unit_active_state_label;
	RightLabel* unit_sub_state_label;
	RightLabel* unit_fragment_path_label;
	RightLabel* unit_active_enter_timestamp_label;
	RightLabel* unit_active_exit_timestamp_label;
	RightLabel* unit_can_start_label;
	RightLabel* unit_can_reload_label;
	RightLabel* unit_cgroup_label;
	RightLabel* job_id_label;
	RightLabel* job_state_label;
	RightLabel* job_type_label;
	GtkComboBox* unit_type_combo_box;
};

struct _UnitJobLink {
	guint32 id;
	char* path;
};

struct _UnitIface {
	GTypeInterface parent_iface;
	char* (*start) (Unit* self, const char* mode, GError** error);
	char* (*stop) (Unit* self, const char* mode, GError** error);
	char* (*restart) (Unit* self, const char* mode, GError** error);
	char* (*reload) (Unit* self, const char* mode, GError** error);
	char* (*get_id) (Unit* self);
	char** (*get_names) (Unit* self, int* result_length1);
	char** (*get_requires) (Unit* self, int* result_length1);
	char** (*get_requires_overridable) (Unit* self, int* result_length1);
	char** (*get_requisite) (Unit* self, int* result_length1);
	char** (*get_requisite_overridable) (Unit* self, int* result_length1);
	char** (*get_wants) (Unit* self, int* result_length1);
	char** (*get_required_by) (Unit* self, int* result_length1);
	char** (*get_required_by_overridable) (Unit* self, int* result_length1);
	char** (*get_wanted_by) (Unit* self, int* result_length1);
	char** (*get_conflicts) (Unit* self, int* result_length1);
	char** (*get_before) (Unit* self, int* result_length1);
	char** (*get_after) (Unit* self, int* result_length1);
	char* (*get_description) (Unit* self);
	char* (*get_load_state) (Unit* self);
	char* (*get_active_state) (Unit* self);
	char* (*get_sub_state) (Unit* self);
	char* (*get_fragment_path) (Unit* self);
	guint64 (*get_inactive_exit_timestamp) (Unit* self);
	guint64 (*get_active_enter_timestamp) (Unit* self);
	guint64 (*get_active_exit_timestamp) (Unit* self);
	guint64 (*get_inactive_enter_timestamp) (Unit* self);
	gboolean (*get_can_start) (Unit* self);
	gboolean (*get_can_reload) (Unit* self);
	void (*get_job) (Unit* self, UnitJobLink* value);
	gboolean (*get_recursive_stop) (Unit* self);
	gboolean (*get_stop_when_unneeded) (Unit* self);
	char* (*get_default_control_group) (Unit* self);
	char** (*get_control_groups) (Unit* self, int* result_length1);
};

struct _JobUnitLink {
	char* id;
	char* path;
};

struct _JobIface {
	GTypeInterface parent_iface;
	void (*cancel) (Job* self, GError** error);
	guint32 (*get_id) (Job* self);
	char* (*get_state) (Job* self);
	char* (*get_job_type) (Job* self);
	void (*get_unit) (Job* self, JobUnitLink* value);
};


extern gboolean session;
gboolean session = FALSE;
static gpointer left_label_parent_class = NULL;
static gpointer right_label_parent_class = NULL;
static gpointer main_window_parent_class = NULL;

GType left_label_get_type (void);
enum  {
	LEFT_LABEL_DUMMY_PROPERTY
};
LeftLabel* left_label_new (const char* text);
LeftLabel* left_label_construct (GType object_type, const char* text);
GType right_label_get_type (void);
enum  {
	RIGHT_LABEL_DUMMY_PROPERTY
};
void right_label_set_text_or_na (RightLabel* self, const char* text);
RightLabel* right_label_new (const char* text);
RightLabel* right_label_construct (GType object_type, const char* text);
void right_label_set_markup_or_na (RightLabel* self, const char* text);
GType main_window_get_type (void);
GType manager_unit_info_get_type (void);
ManagerUnitInfo* manager_unit_info_dup (const ManagerUnitInfo* self);
void manager_unit_info_free (ManagerUnitInfo* self);
void manager_unit_info_copy (const ManagerUnitInfo* self, ManagerUnitInfo* dest);
void manager_unit_info_destroy (ManagerUnitInfo* self);
GType manager_job_info_get_type (void);
ManagerJobInfo* manager_job_info_dup (const ManagerJobInfo* self);
void manager_job_info_free (ManagerJobInfo* self);
void manager_job_info_copy (const ManagerJobInfo* self, ManagerJobInfo* dest);
void manager_job_info_destroy (ManagerJobInfo* self);
GType manager_get_type (void);
#define MAIN_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MAIN_WINDOW, MainWindowPrivate))
enum  {
	MAIN_WINDOW_DUMMY_PROPERTY
};
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self);
void main_window_unit_type_changed (MainWindow* self);
static void _main_window_unit_type_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
void main_window_on_unit_load_entry_changed (MainWindow* self);
static void _main_window_on_unit_load_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
void main_window_on_unit_load (MainWindow* self);
static void _main_window_on_unit_load_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static void _main_window_on_unit_load_gtk_button_clicked (GtkButton* _sender, gpointer self);
void main_window_on_server_snapshot (MainWindow* self);
static void _main_window_on_server_snapshot_gtk_button_clicked (GtkButton* _sender, gpointer self);
void main_window_on_server_reload (MainWindow* self);
static void _main_window_on_server_reload_gtk_button_clicked (GtkButton* _sender, gpointer self);
GType unit_job_link_get_type (void);
UnitJobLink* unit_job_link_dup (const UnitJobLink* self);
void unit_job_link_free (UnitJobLink* self);
void unit_job_link_copy (const UnitJobLink* self, UnitJobLink* dest);
void unit_job_link_destroy (UnitJobLink* self);
GType unit_get_type (void);
GType job_unit_link_get_type (void);
JobUnitLink* job_unit_link_dup (const JobUnitLink* self);
void job_unit_link_free (JobUnitLink* self);
void job_unit_link_copy (const JobUnitLink* self, JobUnitLink* dest);
void job_unit_link_destroy (JobUnitLink* self);
GType job_get_type (void);
gboolean main_window_unit_filter (MainWindow* self, GtkTreeModel* model, GtkTreeIter* iter);
static gboolean _main_window_unit_filter_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self);
void main_window_unit_changed (MainWindow* self);
static void _main_window_unit_changed_gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self);
void main_window_job_changed (MainWindow* self);
static void _main_window_job_changed_gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self);
gboolean main_window_on_activate_link (MainWindow* self, const char* uri);
static gboolean _main_window_on_activate_link_gtk_label_activate_link (GtkLabel* _sender, const char* uri, gpointer self);
void main_window_on_start (MainWindow* self);
static void _main_window_on_start_gtk_button_clicked (GtkButton* _sender, gpointer self);
void main_window_on_stop (MainWindow* self);
static void _main_window_on_stop_gtk_button_clicked (GtkButton* _sender, gpointer self);
void main_window_on_reload (MainWindow* self);
static void _main_window_on_reload_gtk_button_clicked (GtkButton* _sender, gpointer self);
void main_window_on_restart (MainWindow* self);
static void _main_window_on_restart_gtk_button_clicked (GtkButton* _sender, gpointer self);
void main_window_on_cancel (MainWindow* self);
static void _main_window_on_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self);
void main_window_on_unit_new (MainWindow* self, const char* id, const char* path);
static void _main_window_on_unit_new_manager_unit_new (Manager* _sender, const char* id, const char* path, gpointer self);
void main_window_on_job_new (MainWindow* self, guint32 id, const char* path);
static void _main_window_on_job_new_manager_job_new (Manager* _sender, guint32 id, const char* path, gpointer self);
void main_window_on_unit_removed (MainWindow* self, const char* id, const char* path);
static void _main_window_on_unit_removed_manager_unit_removed (Manager* _sender, const char* id, const char* path, gpointer self);
void main_window_on_job_removed (MainWindow* self, guint32 id, const char* path, gboolean success);
static void _main_window_on_job_removed_manager_job_removed (Manager* _sender, guint32 id, const char* path, gboolean success, gpointer self);
void manager_subscribe (Manager* self, GError** error);
void main_window_clear_unit (MainWindow* self);
void main_window_clear_job (MainWindow* self);
void main_window_populate_unit_model (MainWindow* self, GError** error);
void main_window_populate_job_model (MainWindow* self, GError** error);
MainWindow* main_window_new (GError** error);
MainWindow* main_window_construct (GType object_type, GError** error);
ManagerUnitInfo* manager_list_units (Manager* self, int* result_length1, GError** error);
void main_window_on_unit_changed (MainWindow* self, Unit* u);
static void _main_window_on_unit_changed_unit_changed (Unit* _sender, gpointer self);
static void _vala_ManagerUnitInfo_array_free (ManagerUnitInfo* array, gint array_length);
ManagerJobInfo* manager_list_jobs (Manager* self, int* result_length1, GError** error);
void main_window_on_job_changed (MainWindow* self, Job* j);
static void _main_window_on_job_changed_job_changed (Job* _sender, gpointer self);
static void _vala_ManagerJobInfo_array_free (ManagerJobInfo* array, gint array_length);
Unit* main_window_get_current_unit (MainWindow* self);
void main_window_show_unit (MainWindow* self, Unit* unit);
char* main_window_make_dependency_string (MainWindow* self, const char* prefix, const char* word, char** dependencies, int dependencies_length1);
char* unit_get_id (Unit* self);
char** unit_get_names (Unit* self, int* result_length1);
char** unit_get_requires (Unit* self, int* result_length1);
char** unit_get_requires_overridable (Unit* self, int* result_length1);
char** unit_get_requisite (Unit* self, int* result_length1);
char** unit_get_requisite_overridable (Unit* self, int* result_length1);
char** unit_get_wants (Unit* self, int* result_length1);
char** unit_get_required_by (Unit* self, int* result_length1);
char** unit_get_required_by_overridable (Unit* self, int* result_length1);
char** unit_get_wanted_by (Unit* self, int* result_length1);
char** unit_get_conflicts (Unit* self, int* result_length1);
char** unit_get_before (Unit* self, int* result_length1);
char** unit_get_after (Unit* self, int* result_length1);
char* unit_get_description (Unit* self);
char* unit_get_load_state (Unit* self);
char* unit_get_active_state (Unit* self);
char* unit_get_sub_state (Unit* self);
char* unit_get_fragment_path (Unit* self);
guint64 unit_get_active_enter_timestamp (Unit* self);
guint64 unit_get_active_exit_timestamp (Unit* self);
gboolean unit_get_can_start (Unit* self);
gboolean unit_get_can_reload (Unit* self);
char* unit_get_default_control_group (Unit* self);
Job* main_window_get_current_job (MainWindow* self);
void main_window_show_job (MainWindow* self, Job* job);
guint32 job_get_id (Job* self);
char* job_get_state (Job* self);
char* job_get_job_type (Job* self);
char* unit_start (Unit* self, const char* mode, GError** error);
void main_window_show_error (MainWindow* self, const char* e);
char* unit_stop (Unit* self, const char* mode, GError** error);
char* unit_reload (Unit* self, const char* mode, GError** error);
char* unit_restart (Unit* self, const char* mode, GError** error);
void job_cancel (Job* self, GError** error);
void unit_get_job (Unit* self, UnitJobLink* result);
void main_window_update_unit_iter (MainWindow* self, GtkTreeIter* iter, const char* id, Unit* u);
void job_get_unit (Job* self, JobUnitLink* result);
void main_window_update_job_iter (MainWindow* self, GtkTreeIter* iter, guint32 id, Job* j);
void manager_reload (Manager* self, GError** error);
char* manager_create_snapshot (Manager* self, const char* name, gboolean cleanup, GError** error);
char* manager_load_unit (Manager* self, const char* name, GError** error);
char* manager_get_unit (Manager* self, const char* name, GError** error);
static void main_window_finalize (GObject* obj);
void show_error (const char* e);
gint _vala_main (char** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);

const GOptionEntry entries[3] = {{"session", (gchar) 0, 0, G_OPTION_ARG_NONE, &session, "Connect to session bus", NULL}, {"system", (gchar) 0, (gint) G_OPTION_FLAG_REVERSE, G_OPTION_ARG_NONE, &session, "Connect to system bus", NULL}, {NULL}};


#line 28 "systemadm.vala"
LeftLabel* left_label_construct (GType object_type, const char* text) {
#line 417 "systemadm.c"
	LeftLabel * self;
	self = g_object_newv (object_type, 0, NULL);
#line 29 "systemadm.vala"
	if (text != NULL) {
#line 422 "systemadm.c"
		char* _tmp0_;
#line 30 "systemadm.vala"
		gtk_label_set_markup ((GtkLabel*) self, _tmp0_ = g_strdup_printf ("<b>%s</b>", text));
#line 426 "systemadm.c"
		_g_free0 (_tmp0_);
	}
#line 31 "systemadm.vala"
	gtk_misc_set_alignment ((GtkMisc*) self, (float) 0, (float) 0);
#line 32 "systemadm.vala"
	gtk_misc_set_padding ((GtkMisc*) self, 6, 0);
#line 433 "systemadm.c"
	return self;
}


#line 28 "systemadm.vala"
LeftLabel* left_label_new (const char* text) {
#line 28 "systemadm.vala"
	return left_label_construct (TYPE_LEFT_LABEL, text);
#line 442 "systemadm.c"
}


static void left_label_class_init (LeftLabelClass * klass) {
	left_label_parent_class = g_type_class_peek_parent (klass);
}


static void left_label_instance_init (LeftLabel * self) {
}


GType left_label_get_type (void) {
	static volatile gsize left_label_type_id__volatile = 0;
	if (g_once_init_enter (&left_label_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LeftLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) left_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LeftLabel), 0, (GInstanceInitFunc) left_label_instance_init, NULL };
		GType left_label_type_id;
		left_label_type_id = g_type_register_static (GTK_TYPE_LABEL, "LeftLabel", &g_define_type_info, 0);
		g_once_init_leave (&left_label_type_id__volatile, left_label_type_id);
	}
	return left_label_type_id__volatile;
}


#line 37 "systemadm.vala"
RightLabel* right_label_construct (GType object_type, const char* text) {
#line 469 "systemadm.c"
	RightLabel * self;
	self = g_object_newv (object_type, 0, NULL);
#line 38 "systemadm.vala"
	right_label_set_text_or_na (self, text);
#line 39 "systemadm.vala"
	gtk_misc_set_alignment ((GtkMisc*) self, (float) 0, (float) 0);
#line 40 "systemadm.vala"
	gtk_label_set_ellipsize ((GtkLabel*) self, PANGO_ELLIPSIZE_START);
#line 41 "systemadm.vala"
	gtk_label_set_selectable ((GtkLabel*) self, TRUE);
#line 480 "systemadm.c"
	return self;
}


#line 37 "systemadm.vala"
RightLabel* right_label_new (const char* text) {
#line 37 "systemadm.vala"
	return right_label_construct (TYPE_RIGHT_LABEL, text);
#line 489 "systemadm.c"
}


#line 44 "systemadm.vala"
void right_label_set_text_or_na (RightLabel* self, const char* text) {
#line 495 "systemadm.c"
	gboolean _tmp0_ = FALSE;
#line 44 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 45 "systemadm.vala"
	if (text == NULL) {
#line 45 "systemadm.vala"
		_tmp0_ = TRUE;
#line 503 "systemadm.c"
	} else {
#line 45 "systemadm.vala"
		_tmp0_ = _vala_strcmp0 (text, "") == 0;
#line 507 "systemadm.c"
	}
#line 45 "systemadm.vala"
	if (_tmp0_) {
#line 46 "systemadm.vala"
		gtk_label_set_markup ((GtkLabel*) self, "<i>n/a</i>");
#line 513 "systemadm.c"
	} else {
#line 48 "systemadm.vala"
		gtk_label_set_text ((GtkLabel*) self, text);
#line 517 "systemadm.c"
	}
}


#line 51 "systemadm.vala"
void right_label_set_markup_or_na (RightLabel* self, const char* text) {
#line 524 "systemadm.c"
	gboolean _tmp0_ = FALSE;
#line 51 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 52 "systemadm.vala"
	if (text == NULL) {
#line 52 "systemadm.vala"
		_tmp0_ = TRUE;
#line 532 "systemadm.c"
	} else {
#line 52 "systemadm.vala"
		_tmp0_ = _vala_strcmp0 (text, "") == 0;
#line 536 "systemadm.c"
	}
#line 52 "systemadm.vala"
	if (_tmp0_) {
#line 53 "systemadm.vala"
		gtk_label_set_markup ((GtkLabel*) self, "<i>n/a</i>");
#line 542 "systemadm.c"
	} else {
#line 55 "systemadm.vala"
		gtk_label_set_markup ((GtkLabel*) self, text);
#line 546 "systemadm.c"
	}
}


static void right_label_class_init (RightLabelClass * klass) {
	right_label_parent_class = g_type_class_peek_parent (klass);
}


static void right_label_instance_init (RightLabel * self) {
}


GType right_label_get_type (void) {
	static volatile gsize right_label_type_id__volatile = 0;
	if (g_once_init_enter (&right_label_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RightLabelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) right_label_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RightLabel), 0, (GInstanceInitFunc) right_label_instance_init, NULL };
		GType right_label_type_id;
		right_label_type_id = g_type_register_static (GTK_TYPE_LABEL, "RightLabel", &g_define_type_info, 0);
		g_once_init_leave (&right_label_type_id__volatile, right_label_type_id);
	}
	return right_label_type_id__volatile;
}


#line 7712 "gtk+-2.0.vapi"
static void _gtk_main_quit_gtk_object_destroy (GtkObject* _sender, gpointer self) {
#line 574 "systemadm.c"
	gtk_main_quit ();
}


#line 846 "systemadm.vala"
static void _main_window_unit_type_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
#line 581 "systemadm.c"
	main_window_unit_type_changed (self);
}


#line 901 "systemadm.vala"
static void _main_window_on_unit_load_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
#line 588 "systemadm.c"
	main_window_on_unit_load_entry_changed (self);
}


#line 872 "systemadm.vala"
static void _main_window_on_unit_load_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
#line 595 "systemadm.c"
	main_window_on_unit_load (self);
}


#line 872 "systemadm.vala"
static void _main_window_on_unit_load_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 602 "systemadm.c"
	main_window_on_unit_load (self);
}


#line 860 "systemadm.vala"
static void _main_window_on_server_snapshot_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 609 "systemadm.c"
	main_window_on_server_snapshot (self);
}


#line 852 "systemadm.vala"
static void _main_window_on_server_reload_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 616 "systemadm.c"
	main_window_on_server_reload (self);
}


#line 805 "systemadm.vala"
static gboolean _main_window_unit_filter_gtk_tree_model_filter_visible_func (GtkTreeModel* model, GtkTreeIter* iter, gpointer self) {
#line 623 "systemadm.c"
	gboolean result;
	result = main_window_unit_filter (self, model, iter);
	return result;
}


#line 390 "systemadm.vala"
static void _main_window_unit_changed_gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self) {
#line 632 "systemadm.c"
	main_window_unit_changed (self);
}


#line 556 "systemadm.vala"
static void _main_window_job_changed_gtk_tree_view_cursor_changed (GtkTreeView* _sender, gpointer self) {
#line 639 "systemadm.c"
	main_window_job_changed (self);
}


#line 905 "systemadm.vala"
static gboolean _main_window_on_activate_link_gtk_label_activate_link (GtkLabel* _sender, const char* uri, gpointer self) {
#line 646 "systemadm.c"
	gboolean result;
	result = main_window_on_activate_link (self, uri);
	return result;
}


#line 585 "systemadm.vala"
static void _main_window_on_start_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 655 "systemadm.c"
	main_window_on_start (self);
}


#line 598 "systemadm.vala"
static void _main_window_on_stop_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 662 "systemadm.c"
	main_window_on_stop (self);
}


#line 611 "systemadm.vala"
static void _main_window_on_reload_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 669 "systemadm.c"
	main_window_on_reload (self);
}


#line 624 "systemadm.vala"
static void _main_window_on_restart_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 676 "systemadm.c"
	main_window_on_restart (self);
}


#line 637 "systemadm.vala"
static void _main_window_on_cancel_gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 683 "systemadm.c"
	main_window_on_cancel (self);
}


#line 674 "systemadm.vala"
static void _main_window_on_unit_new_manager_unit_new (Manager* _sender, const char* id, const char* path, gpointer self) {
#line 690 "systemadm.c"
	main_window_on_unit_new (self, id, path);
}


#line 697 "systemadm.vala"
static void _main_window_on_job_new_manager_job_new (Manager* _sender, guint32 id, const char* path, gpointer self) {
#line 697 "systemadm.c"
	main_window_on_job_new (self, id, path);
}


#line 710 "systemadm.vala"
static void _main_window_on_unit_removed_manager_unit_removed (Manager* _sender, const char* id, const char* path, gpointer self) {
#line 704 "systemadm.c"
	main_window_on_unit_removed (self, id, path);
}


#line 731 "systemadm.vala"
static void _main_window_on_job_removed_manager_job_removed (Manager* _sender, guint32 id, const char* path, gboolean success, gpointer self) {
#line 711 "systemadm.c"
	main_window_on_job_removed (self, id, path, success);
}


#line 105 "systemadm.vala"
MainWindow* main_window_construct (GType object_type, GError** error) {
#line 718 "systemadm.c"
	GError * _inner_error_;
	MainWindow * self;
	const char* _tmp0_;
	GtkNotebook* notebook;
	GtkBox* unit_vbox;
	GtkLabel* _tmp1_;
	GtkBox* job_vbox;
	GtkLabel* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkBox* type_hbox;
	GtkEntry* _tmp4_;
	GtkButton* _tmp5_;
	GtkBox* unit_load_hbox;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	GtkListStore* _tmp8_;
	GtkListStore* _tmp9_;
	GtkTreeModelFilter* unit_model_filter;
	GtkTreeModelFilter* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkTreeView* _tmp12_;
	GtkCellRendererText* _tmp13_;
	GtkCellRendererText* _tmp14_;
	GtkCellRendererText* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkCellRendererText* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkCellRendererText* _tmp21_;
	GtkScrolledWindow* scroll;
	GtkScrolledWindow* _tmp22_;
	RightLabel* _tmp23_;
	RightLabel* _tmp24_;
	RightLabel* _tmp25_;
	RightLabel* _tmp26_;
	RightLabel* _tmp27_;
	RightLabel* _tmp28_;
	RightLabel* _tmp29_;
	RightLabel* _tmp30_;
	RightLabel* _tmp31_;
	RightLabel* _tmp32_;
	RightLabel* _tmp33_;
	RightLabel* _tmp34_;
	RightLabel* _tmp35_;
	RightLabel* _tmp36_;
	RightLabel* _tmp37_;
	RightLabel* _tmp38_;
	GtkTable* unit_table;
	GtkTable* job_table;
	LeftLabel* _tmp39_;
	LeftLabel* _tmp40_;
	LeftLabel* _tmp41_;
	LeftLabel* _tmp42_;
	LeftLabel* _tmp43_;
	LeftLabel* _tmp44_;
	LeftLabel* _tmp45_;
	LeftLabel* _tmp46_;
	LeftLabel* _tmp47_;
	LeftLabel* _tmp48_;
	LeftLabel* _tmp49_;
	LeftLabel* _tmp50_;
	LeftLabel* _tmp51_;
	LeftLabel* _tmp52_;
	LeftLabel* _tmp53_;
	LeftLabel* _tmp54_;
	GtkButtonBox* bbox;
	GtkButton* _tmp55_;
	GtkButton* _tmp56_;
	GtkButton* _tmp57_;
	GtkButton* _tmp58_;
	GtkButtonBox* _tmp59_;
	GtkButton* _tmp60_;
	DBusBusType _tmp61_ = 0;
	DBusGConnection* _tmp62_;
	DBusGConnection* _tmp63_;
	Manager* _tmp64_;
	_inner_error_ = NULL;
	self = g_object_newv (object_type, 0, NULL);
	_tmp0_ = NULL;
#line 106 "systemadm.vala"
	if (session) {
#line 106 "systemadm.vala"
		_tmp0_ = "systemd Session Manager";
#line 803 "systemadm.c"
	} else {
#line 106 "systemadm.vala"
		_tmp0_ = "systemd System Manager";
#line 807 "systemadm.c"
	}
#line 106 "systemadm.vala"
	gtk_window_set_title ((GtkWindow*) self, _tmp0_);
#line 107 "systemadm.vala"
	((GtkWindow*) self)->position = (guint) GTK_WIN_POS_CENTER;
#line 108 "systemadm.vala"
	gtk_window_set_default_size ((GtkWindow*) self, 1000, 700);
#line 109 "systemadm.vala"
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 12);
#line 110 "systemadm.vala"
	g_signal_connect ((GtkObject*) self, "destroy", (GCallback) _gtk_main_quit_gtk_object_destroy, NULL);
#line 112 "systemadm.vala"
	notebook = g_object_ref_sink ((GtkNotebook*) gtk_notebook_new ());
#line 113 "systemadm.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) notebook);
#line 115 "systemadm.vala"
	unit_vbox = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 12));
#line 116 "systemadm.vala"
	gtk_notebook_append_page (notebook, (GtkWidget*) unit_vbox, (GtkWidget*) (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("Units"))));
#line 827 "systemadm.c"
	_g_object_unref0 (_tmp1_);
#line 117 "systemadm.vala"
	gtk_container_set_border_width ((GtkContainer*) unit_vbox, (guint) 12);
#line 119 "systemadm.vala"
	job_vbox = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 12));
#line 120 "systemadm.vala"
	gtk_notebook_append_page (notebook, (GtkWidget*) job_vbox, (GtkWidget*) (_tmp2_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("Jobs"))));
#line 835 "systemadm.c"
	_g_object_unref0 (_tmp2_);
#line 121 "systemadm.vala"
	gtk_container_set_border_width ((GtkContainer*) job_vbox, (guint) 12);
#line 123 "systemadm.vala"
	self->priv->unit_type_combo_box = (_tmp3_ = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_text ()), _g_object_unref0 (self->priv->unit_type_combo_box), _tmp3_);
#line 124 "systemadm.vala"
	type_hbox = (GtkBox*) g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
#line 125 "systemadm.vala"
	gtk_box_pack_start (type_hbox, (GtkWidget*) self->priv->unit_type_combo_box, FALSE, FALSE, (guint) 0);
#line 126 "systemadm.vala"
	gtk_box_pack_start (unit_vbox, (GtkWidget*) type_hbox, FALSE, FALSE, (guint) 0);
#line 128 "systemadm.vala"
	gtk_combo_box_append_text (self->priv->unit_type_combo_box, "Show All Units");
#line 129 "systemadm.vala"
	gtk_combo_box_append_text (self->priv->unit_type_combo_box, "Show Only Live Units");
#line 130 "systemadm.vala"
	gtk_combo_box_append_text (self->priv->unit_type_combo_box, "Services");
#line 131 "systemadm.vala"
	gtk_combo_box_append_text (self->priv->unit_type_combo_box, "Sockets");
#line 132 "systemadm.vala"
	gtk_combo_box_append_text (self->priv->unit_type_combo_box, "Devices");
#line 133 "systemadm.vala"
	gtk_combo_box_append_text (self->priv->unit_type_combo_box, "Mounts");
#line 134 "systemadm.vala"
	gtk_combo_box_append_text (self->priv->unit_type_combo_box, "Automounts");
#line 135 "systemadm.vala"
	gtk_combo_box_append_text (self->priv->unit_type_combo_box, "Targets");
#line 136 "systemadm.vala"
	gtk_combo_box_append_text (self->priv->unit_type_combo_box, "Snapshots");
#line 137 "systemadm.vala"
	gtk_combo_box_set_active (self->priv->unit_type_combo_box, 1);
#line 138 "systemadm.vala"
	g_signal_connect_object (self->priv->unit_type_combo_box, "changed", (GCallback) _main_window_unit_type_changed_gtk_combo_box_changed, self, 0);
#line 140 "systemadm.vala"
	self->priv->unit_load_entry = (_tmp4_ = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (self->priv->unit_load_entry), _tmp4_);
#line 141 "systemadm.vala"
	self->priv->unit_load_button = (_tmp5_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic ("_Load")), _g_object_unref0 (self->priv->unit_load_button), _tmp5_);
#line 142 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->unit_load_button, FALSE);
#line 144 "systemadm.vala"
	g_signal_connect_object ((GtkEditable*) self->priv->unit_load_entry, "changed", (GCallback) _main_window_on_unit_load_entry_changed_gtk_editable_changed, self, 0);
#line 145 "systemadm.vala"
	g_signal_connect_object (self->priv->unit_load_entry, "activate", (GCallback) _main_window_on_unit_load_gtk_entry_activate, self, 0);
#line 146 "systemadm.vala"
	g_signal_connect_object (self->priv->unit_load_button, "clicked", (GCallback) _main_window_on_unit_load_gtk_button_clicked, self, 0);
#line 148 "systemadm.vala"
	unit_load_hbox = (GtkBox*) g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
#line 149 "systemadm.vala"
	gtk_box_pack_start (unit_load_hbox, (GtkWidget*) self->priv->unit_load_entry, FALSE, TRUE, (guint) 0);
#line 150 "systemadm.vala"
	gtk_box_pack_start (unit_load_hbox, (GtkWidget*) self->priv->unit_load_button, FALSE, TRUE, (guint) 0);
#line 152 "systemadm.vala"
	self->priv->server_snapshot_button = (_tmp6_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic ("Take S_napshot")), _g_object_unref0 (self->priv->server_snapshot_button), _tmp6_);
#line 153 "systemadm.vala"
	self->priv->server_reload_button = (_tmp7_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic ("Reload _Configuration")), _g_object_unref0 (self->priv->server_reload_button), _tmp7_);
#line 155 "systemadm.vala"
	g_signal_connect_object (self->priv->server_snapshot_button, "clicked", (GCallback) _main_window_on_server_snapshot_gtk_button_clicked, self, 0);
#line 156 "systemadm.vala"
	g_signal_connect_object (self->priv->server_reload_button, "clicked", (GCallback) _main_window_on_server_reload_gtk_button_clicked, self, 0);
#line 158 "systemadm.vala"
	gtk_box_pack_end (type_hbox, (GtkWidget*) self->priv->server_snapshot_button, FALSE, TRUE, (guint) 0);
#line 159 "systemadm.vala"
	gtk_box_pack_end (type_hbox, (GtkWidget*) self->priv->server_reload_button, FALSE, TRUE, (guint) 0);
#line 160 "systemadm.vala"
	gtk_box_pack_end (type_hbox, (GtkWidget*) unit_load_hbox, FALSE, TRUE, (guint) 24);
#line 162 "systemadm.vala"
	self->priv->unit_model = (_tmp8_ = gtk_list_store_new (7, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, TYPE_UNIT, NULL), _g_object_unref0 (self->priv->unit_model), _tmp8_);
#line 163 "systemadm.vala"
	self->priv->job_model = (_tmp9_ = gtk_list_store_new (6, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, TYPE_JOB, G_TYPE_UINT, NULL), _g_object_unref0 (self->priv->job_model), _tmp9_);
#line 905 "systemadm.c"
	unit_model_filter = NULL;
#line 166 "systemadm.vala"
	unit_model_filter = (_tmp10_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) self->priv->unit_model, NULL), _g_object_unref0 (unit_model_filter), _tmp10_);
#line 167 "systemadm.vala"
	gtk_tree_model_filter_set_visible_func (unit_model_filter, _main_window_unit_filter_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
#line 169 "systemadm.vala"
	self->priv->unit_view = (_tmp11_ = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) unit_model_filter)), _g_object_unref0 (self->priv->unit_view), _tmp11_);
#line 170 "systemadm.vala"
	self->priv->job_view = (_tmp12_ = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) self->priv->job_model)), _g_object_unref0 (self->priv->job_view), _tmp12_);
#line 172 "systemadm.vala"
	g_signal_connect_object (self->priv->unit_view, "cursor-changed", (GCallback) _main_window_unit_changed_gtk_tree_view_cursor_changed, self, 0);
#line 173 "systemadm.vala"
	g_signal_connect_object (self->priv->job_view, "cursor-changed", (GCallback) _main_window_job_changed_gtk_tree_view_cursor_changed, self, 0);
#line 175 "systemadm.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->unit_view, -1, "Load State", (GtkCellRenderer*) (_tmp13_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 2, NULL);
#line 921 "systemadm.c"
	_g_object_unref0 (_tmp13_);
#line 176 "systemadm.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->unit_view, -1, "Active State", (GtkCellRenderer*) (_tmp14_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 3, NULL);
#line 925 "systemadm.c"
	_g_object_unref0 (_tmp14_);
#line 177 "systemadm.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->unit_view, -1, "Unit State", (GtkCellRenderer*) (_tmp15_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 4, NULL);
#line 929 "systemadm.c"
	_g_object_unref0 (_tmp15_);
#line 178 "systemadm.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->unit_view, -1, "Unit", (GtkCellRenderer*) (_tmp16_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 0, NULL);
#line 933 "systemadm.c"
	_g_object_unref0 (_tmp16_);
#line 179 "systemadm.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->unit_view, -1, "Job", (GtkCellRenderer*) (_tmp17_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 5, NULL);
#line 937 "systemadm.c"
	_g_object_unref0 (_tmp17_);
#line 181 "systemadm.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->job_view, -1, "Job", (GtkCellRenderer*) (_tmp18_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 0, NULL);
#line 941 "systemadm.c"
	_g_object_unref0 (_tmp18_);
#line 182 "systemadm.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->job_view, -1, "Unit", (GtkCellRenderer*) (_tmp19_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 1, NULL);
#line 945 "systemadm.c"
	_g_object_unref0 (_tmp19_);
#line 183 "systemadm.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->job_view, -1, "Type", (GtkCellRenderer*) (_tmp20_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 2, NULL);
#line 949 "systemadm.c"
	_g_object_unref0 (_tmp20_);
#line 184 "systemadm.vala"
	gtk_tree_view_insert_column_with_attributes (self->priv->job_view, -1, "State", (GtkCellRenderer*) (_tmp21_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 3, NULL);
#line 953 "systemadm.c"
	_g_object_unref0 (_tmp21_);
#line 186 "systemadm.vala"
	scroll = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
#line 187 "systemadm.vala"
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 188 "systemadm.vala"
	gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
#line 189 "systemadm.vala"
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->unit_view);
#line 190 "systemadm.vala"
	gtk_box_pack_start (unit_vbox, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
#line 192 "systemadm.vala"
	scroll = (_tmp22_ = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), _g_object_unref0 (scroll), _tmp22_);
#line 193 "systemadm.vala"
	gtk_scrolled_window_set_policy (scroll, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 194 "systemadm.vala"
	gtk_scrolled_window_set_shadow_type (scroll, GTK_SHADOW_IN);
#line 195 "systemadm.vala"
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->job_view);
#line 196 "systemadm.vala"
	gtk_box_pack_start (job_vbox, (GtkWidget*) scroll, TRUE, TRUE, (guint) 0);
#line 198 "systemadm.vala"
	self->priv->unit_id_label = (_tmp23_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_id_label), _tmp23_);
#line 199 "systemadm.vala"
	self->priv->unit_aliases_label = (_tmp24_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_aliases_label), _tmp24_);
#line 200 "systemadm.vala"
	self->priv->unit_dependency_label = (_tmp25_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_dependency_label), _tmp25_);
#line 201 "systemadm.vala"
	self->priv->unit_description_label = (_tmp26_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_description_label), _tmp26_);
#line 202 "systemadm.vala"
	self->priv->unit_load_state_label = (_tmp27_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_load_state_label), _tmp27_);
#line 203 "systemadm.vala"
	self->priv->unit_active_state_label = (_tmp28_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_active_state_label), _tmp28_);
#line 204 "systemadm.vala"
	self->priv->unit_sub_state_label = (_tmp29_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_sub_state_label), _tmp29_);
#line 205 "systemadm.vala"
	self->priv->unit_fragment_path_label = (_tmp30_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_fragment_path_label), _tmp30_);
#line 206 "systemadm.vala"
	self->priv->unit_active_enter_timestamp_label = (_tmp31_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_active_enter_timestamp_label), _tmp31_);
#line 207 "systemadm.vala"
	self->priv->unit_active_exit_timestamp_label = (_tmp32_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_active_exit_timestamp_label), _tmp32_);
#line 208 "systemadm.vala"
	self->priv->unit_can_start_label = (_tmp33_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_can_start_label), _tmp33_);
#line 209 "systemadm.vala"
	self->priv->unit_can_reload_label = (_tmp34_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_can_reload_label), _tmp34_);
#line 210 "systemadm.vala"
	self->priv->unit_cgroup_label = (_tmp35_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->unit_cgroup_label), _tmp35_);
#line 212 "systemadm.vala"
	self->priv->job_id_label = (_tmp36_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->job_id_label), _tmp36_);
#line 213 "systemadm.vala"
	self->priv->job_state_label = (_tmp37_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->job_state_label), _tmp37_);
#line 214 "systemadm.vala"
	self->priv->job_type_label = (_tmp38_ = g_object_ref_sink (right_label_new (NULL)), _g_object_unref0 (self->priv->job_type_label), _tmp38_);
#line 216 "systemadm.vala"
	gtk_label_set_track_visited_links ((GtkLabel*) self->priv->unit_dependency_label, FALSE);
#line 217 "systemadm.vala"
	gtk_label_set_selectable ((GtkLabel*) self->priv->unit_dependency_label, FALSE);
#line 218 "systemadm.vala"
	g_signal_connect_object ((GtkLabel*) self->priv->unit_dependency_label, "activate-link", (GCallback) _main_window_on_activate_link_gtk_label_activate_link, self, 0);
#line 220 "systemadm.vala"
	gtk_label_set_track_visited_links ((GtkLabel*) self->priv->unit_fragment_path_label, FALSE);
#line 222 "systemadm.vala"
	unit_table = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 8, (guint) 6, FALSE));
#line 223 "systemadm.vala"
	gtk_table_set_row_spacings (unit_table, (guint) 6);
#line 224 "systemadm.vala"
	gtk_container_set_border_width ((GtkContainer*) unit_table, (guint) 0);
#line 225 "systemadm.vala"
	gtk_box_pack_start (unit_vbox, (GtkWidget*) unit_table, FALSE, TRUE, (guint) 0);
#line 227 "systemadm.vala"
	job_table = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) 2, (guint) 2, FALSE));
#line 228 "systemadm.vala"
	gtk_table_set_row_spacings (job_table, (guint) 6);
#line 229 "systemadm.vala"
	gtk_container_set_border_width ((GtkContainer*) job_table, (guint) 0);
#line 230 "systemadm.vala"
	gtk_box_pack_start (job_vbox, (GtkWidget*) job_table, FALSE, TRUE, (guint) 0);
#line 232 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp39_ = g_object_ref_sink (left_label_new ("Id:"))), (guint) 0, (guint) 1, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1033 "systemadm.c"
	_g_object_unref0 (_tmp39_);
#line 233 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_id_label, (guint) 1, (guint) 6, (guint) 0, (guint) 1, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 234 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp40_ = g_object_ref_sink (left_label_new ("Aliases:"))), (guint) 0, (guint) 1, (guint) 1, (guint) 2, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1039 "systemadm.c"
	_g_object_unref0 (_tmp40_);
#line 235 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_aliases_label, (guint) 1, (guint) 6, (guint) 1, (guint) 2, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 236 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp41_ = g_object_ref_sink (left_label_new ("Description:"))), (guint) 0, (guint) 1, (guint) 2, (guint) 3, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1045 "systemadm.c"
	_g_object_unref0 (_tmp41_);
#line 237 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_description_label, (guint) 1, (guint) 6, (guint) 2, (guint) 3, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 238 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp42_ = g_object_ref_sink (left_label_new ("Dependencies:"))), (guint) 0, (guint) 1, (guint) 3, (guint) 4, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1051 "systemadm.c"
	_g_object_unref0 (_tmp42_);
#line 239 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_dependency_label, (guint) 1, (guint) 6, (guint) 3, (guint) 4, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 240 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp43_ = g_object_ref_sink (left_label_new ("Fragment Path:"))), (guint) 0, (guint) 1, (guint) 4, (guint) 5, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1057 "systemadm.c"
	_g_object_unref0 (_tmp43_);
#line 241 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_fragment_path_label, (guint) 1, (guint) 6, (guint) 4, (guint) 5, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 242 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp44_ = g_object_ref_sink (left_label_new ("Control Group:"))), (guint) 0, (guint) 1, (guint) 5, (guint) 6, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1063 "systemadm.c"
	_g_object_unref0 (_tmp44_);
#line 243 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_cgroup_label, (guint) 1, (guint) 6, (guint) 5, (guint) 6, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 245 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp45_ = g_object_ref_sink (left_label_new ("Load State:"))), (guint) 0, (guint) 1, (guint) 6, (guint) 7, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1069 "systemadm.c"
	_g_object_unref0 (_tmp45_);
#line 246 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_load_state_label, (guint) 1, (guint) 2, (guint) 6, (guint) 7, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 247 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp46_ = g_object_ref_sink (left_label_new ("Active State:"))), (guint) 0, (guint) 1, (guint) 7, (guint) 8, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1075 "systemadm.c"
	_g_object_unref0 (_tmp46_);
#line 248 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_active_state_label, (guint) 1, (guint) 2, (guint) 7, (guint) 8, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 249 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp47_ = g_object_ref_sink (left_label_new ("Unit State:"))), (guint) 0, (guint) 1, (guint) 8, (guint) 9, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1081 "systemadm.c"
	_g_object_unref0 (_tmp47_);
#line 250 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_sub_state_label, (guint) 1, (guint) 2, (guint) 8, (guint) 9, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 252 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp48_ = g_object_ref_sink (left_label_new ("Active Enter Timestamp:"))), (guint) 2, (guint) 3, (guint) 7, (guint) 8, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1087 "systemadm.c"
	_g_object_unref0 (_tmp48_);
#line 253 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_active_enter_timestamp_label, (guint) 3, (guint) 4, (guint) 7, (guint) 8, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 254 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp49_ = g_object_ref_sink (left_label_new ("Active Exit Timestamp:"))), (guint) 2, (guint) 3, (guint) 8, (guint) 9, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1093 "systemadm.c"
	_g_object_unref0 (_tmp49_);
#line 255 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_active_exit_timestamp_label, (guint) 3, (guint) 4, (guint) 8, (guint) 9, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 257 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp50_ = g_object_ref_sink (left_label_new ("Can Start/Stop:"))), (guint) 4, (guint) 5, (guint) 7, (guint) 8, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1099 "systemadm.c"
	_g_object_unref0 (_tmp50_);
#line 258 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_can_start_label, (guint) 5, (guint) 6, (guint) 7, (guint) 8, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 259 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) (_tmp51_ = g_object_ref_sink (left_label_new ("Can Reload:"))), (guint) 4, (guint) 5, (guint) 8, (guint) 9, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1105 "systemadm.c"
	_g_object_unref0 (_tmp51_);
#line 260 "systemadm.vala"
	gtk_table_attach (unit_table, (GtkWidget*) self->priv->unit_can_reload_label, (guint) 5, (guint) 6, (guint) 8, (guint) 9, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 262 "systemadm.vala"
	gtk_table_attach (job_table, (GtkWidget*) (_tmp52_ = g_object_ref_sink (left_label_new ("Id:"))), (guint) 0, (guint) 1, (guint) 0, (guint) 1, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1111 "systemadm.c"
	_g_object_unref0 (_tmp52_);
#line 263 "systemadm.vala"
	gtk_table_attach (job_table, (GtkWidget*) self->priv->job_id_label, (guint) 1, (guint) 2, (guint) 0, (guint) 1, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 264 "systemadm.vala"
	gtk_table_attach (job_table, (GtkWidget*) (_tmp53_ = g_object_ref_sink (left_label_new ("State:"))), (guint) 0, (guint) 1, (guint) 1, (guint) 2, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1117 "systemadm.c"
	_g_object_unref0 (_tmp53_);
#line 265 "systemadm.vala"
	gtk_table_attach (job_table, (GtkWidget*) self->priv->job_state_label, (guint) 1, (guint) 2, (guint) 1, (guint) 2, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 266 "systemadm.vala"
	gtk_table_attach (job_table, (GtkWidget*) (_tmp54_ = g_object_ref_sink (left_label_new ("Type:"))), (guint) 0, (guint) 1, (guint) 2, (guint) 3, GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 1123 "systemadm.c"
	_g_object_unref0 (_tmp54_);
#line 267 "systemadm.vala"
	gtk_table_attach (job_table, (GtkWidget*) self->priv->job_type_label, (guint) 1, (guint) 2, (guint) 2, (guint) 3, GTK_EXPAND | GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
#line 269 "systemadm.vala"
	bbox = (GtkButtonBox*) g_object_ref_sink ((GtkHButtonBox*) gtk_hbutton_box_new ());
#line 270 "systemadm.vala"
	gtk_button_box_set_layout (bbox, GTK_BUTTONBOX_START);
#line 271 "systemadm.vala"
	gtk_box_set_spacing ((GtkBox*) bbox, 6);
#line 272 "systemadm.vala"
	gtk_box_pack_start (unit_vbox, (GtkWidget*) bbox, FALSE, TRUE, (guint) 0);
#line 274 "systemadm.vala"
	self->priv->start_button = (_tmp55_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic ("_Start")), _g_object_unref0 (self->priv->start_button), _tmp55_);
#line 275 "systemadm.vala"
	self->priv->stop_button = (_tmp56_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic ("Sto_p")), _g_object_unref0 (self->priv->stop_button), _tmp56_);
#line 276 "systemadm.vala"
	self->priv->reload_button = (_tmp57_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic ("_Reload")), _g_object_unref0 (self->priv->reload_button), _tmp57_);
#line 277 "systemadm.vala"
	self->priv->restart_button = (_tmp58_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic ("Res_tart")), _g_object_unref0 (self->priv->restart_button), _tmp58_);
#line 279 "systemadm.vala"
	g_signal_connect_object (self->priv->start_button, "clicked", (GCallback) _main_window_on_start_gtk_button_clicked, self, 0);
#line 280 "systemadm.vala"
	g_signal_connect_object (self->priv->stop_button, "clicked", (GCallback) _main_window_on_stop_gtk_button_clicked, self, 0);
#line 281 "systemadm.vala"
	g_signal_connect_object (self->priv->reload_button, "clicked", (GCallback) _main_window_on_reload_gtk_button_clicked, self, 0);
#line 282 "systemadm.vala"
	g_signal_connect_object (self->priv->restart_button, "clicked", (GCallback) _main_window_on_restart_gtk_button_clicked, self, 0);
#line 284 "systemadm.vala"
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) self->priv->start_button, FALSE, TRUE, (guint) 0);
#line 285 "systemadm.vala"
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) self->priv->stop_button, FALSE, TRUE, (guint) 0);
#line 286 "systemadm.vala"
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) self->priv->restart_button, FALSE, TRUE, (guint) 0);
#line 287 "systemadm.vala"
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) self->priv->reload_button, FALSE, TRUE, (guint) 0);
#line 289 "systemadm.vala"
	bbox = (_tmp59_ = (GtkButtonBox*) g_object_ref_sink ((GtkHButtonBox*) gtk_hbutton_box_new ()), _g_object_unref0 (bbox), _tmp59_);
#line 290 "systemadm.vala"
	gtk_button_box_set_layout (bbox, GTK_BUTTONBOX_START);
#line 291 "systemadm.vala"
	gtk_box_set_spacing ((GtkBox*) bbox, 6);
#line 292 "systemadm.vala"
	gtk_box_pack_start (job_vbox, (GtkWidget*) bbox, FALSE, TRUE, (guint) 0);
#line 294 "systemadm.vala"
	self->priv->cancel_button = (_tmp60_ = g_object_ref_sink ((GtkButton*) gtk_button_new_with_mnemonic ("_Cancel")), _g_object_unref0 (self->priv->cancel_button), _tmp60_);
#line 296 "systemadm.vala"
	g_signal_connect_object (self->priv->cancel_button, "clicked", (GCallback) _main_window_on_cancel_gtk_button_clicked, self, 0);
#line 298 "systemadm.vala"
	gtk_box_pack_start ((GtkBox*) bbox, (GtkWidget*) self->priv->cancel_button, FALSE, TRUE, (guint) 0);
#line 300 "systemadm.vala"
	if (session) {
#line 300 "systemadm.vala"
		_tmp61_ = DBUS_BUS_SESSION;
#line 1177 "systemadm.c"
	} else {
#line 300 "systemadm.vala"
		_tmp61_ = DBUS_BUS_SYSTEM;
#line 1181 "systemadm.c"
	}
#line 300 "systemadm.vala"
	_tmp62_ = dbus_g_bus_get (_tmp61_, &_inner_error_);
#line 1185 "systemadm.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (notebook);
			_g_object_unref0 (unit_vbox);
			_g_object_unref0 (job_vbox);
			_g_object_unref0 (type_hbox);
			_g_object_unref0 (unit_load_hbox);
			_g_object_unref0 (unit_model_filter);
			_g_object_unref0 (scroll);
			_g_object_unref0 (unit_table);
			_g_object_unref0 (job_table);
			_g_object_unref0 (bbox);
			g_object_unref (self);
			return NULL;
		} else {
			_g_object_unref0 (notebook);
			_g_object_unref0 (unit_vbox);
			_g_object_unref0 (job_vbox);
			_g_object_unref0 (type_hbox);
			_g_object_unref0 (unit_load_hbox);
			_g_object_unref0 (unit_model_filter);
			_g_object_unref0 (scroll);
			_g_object_unref0 (unit_table);
			_g_object_unref0 (job_table);
			_g_object_unref0 (bbox);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 300 "systemadm.vala"
	self->priv->bus = (_tmp63_ = _tmp62_, _dbus_g_connection_unref0 (self->priv->bus), _tmp63_);
#line 302 "systemadm.vala"
	self->priv->manager = (_tmp64_ = manager_dbus_proxy_new (self->priv->bus, "org.freedesktop.systemd1", "/org/freedesktop/systemd1"), _g_object_unref0 (self->priv->manager), _tmp64_);
#line 307 "systemadm.vala"
	g_signal_connect_object (self->priv->manager, "unit-new", (GCallback) _main_window_on_unit_new_manager_unit_new, self, 0);
#line 308 "systemadm.vala"
	g_signal_connect_object (self->priv->manager, "job-new", (GCallback) _main_window_on_job_new_manager_job_new, self, 0);
#line 309 "systemadm.vala"
	g_signal_connect_object (self->priv->manager, "unit-removed", (GCallback) _main_window_on_unit_removed_manager_unit_removed, self, 0);
#line 310 "systemadm.vala"
	g_signal_connect_object (self->priv->manager, "job-removed", (GCallback) _main_window_on_job_removed_manager_job_removed, self, 0);
#line 312 "systemadm.vala"
	manager_subscribe (self->priv->manager, &_inner_error_);
#line 1231 "systemadm.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (notebook);
			_g_object_unref0 (unit_vbox);
			_g_object_unref0 (job_vbox);
			_g_object_unref0 (type_hbox);
			_g_object_unref0 (unit_load_hbox);
			_g_object_unref0 (unit_model_filter);
			_g_object_unref0 (scroll);
			_g_object_unref0 (unit_table);
			_g_object_unref0 (job_table);
			_g_object_unref0 (bbox);
			g_object_unref (self);
			return NULL;
		} else {
			_g_object_unref0 (notebook);
			_g_object_unref0 (unit_vbox);
			_g_object_unref0 (job_vbox);
			_g_object_unref0 (type_hbox);
			_g_object_unref0 (unit_load_hbox);
			_g_object_unref0 (unit_model_filter);
			_g_object_unref0 (scroll);
			_g_object_unref0 (unit_table);
			_g_object_unref0 (job_table);
			_g_object_unref0 (bbox);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 314 "systemadm.vala"
	main_window_clear_unit (self);
#line 315 "systemadm.vala"
	main_window_clear_job (self);
#line 316 "systemadm.vala"
	main_window_populate_unit_model (self, &_inner_error_);
#line 1269 "systemadm.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (notebook);
			_g_object_unref0 (unit_vbox);
			_g_object_unref0 (job_vbox);
			_g_object_unref0 (type_hbox);
			_g_object_unref0 (unit_load_hbox);
			_g_object_unref0 (unit_model_filter);
			_g_object_unref0 (scroll);
			_g_object_unref0 (unit_table);
			_g_object_unref0 (job_table);
			_g_object_unref0 (bbox);
			g_object_unref (self);
			return NULL;
		} else {
			_g_object_unref0 (notebook);
			_g_object_unref0 (unit_vbox);
			_g_object_unref0 (job_vbox);
			_g_object_unref0 (type_hbox);
			_g_object_unref0 (unit_load_hbox);
			_g_object_unref0 (unit_model_filter);
			_g_object_unref0 (scroll);
			_g_object_unref0 (unit_table);
			_g_object_unref0 (job_table);
			_g_object_unref0 (bbox);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
#line 317 "systemadm.vala"
	main_window_populate_job_model (self, &_inner_error_);
#line 1303 "systemadm.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (notebook);
			_g_object_unref0 (unit_vbox);
			_g_object_unref0 (job_vbox);
			_g_object_unref0 (type_hbox);
			_g_object_unref0 (unit_load_hbox);
			_g_object_unref0 (unit_model_filter);
			_g_object_unref0 (scroll);
			_g_object_unref0 (unit_table);
			_g_object_unref0 (job_table);
			_g_object_unref0 (bbox);
			g_object_unref (self);
			return NULL;
		} else {
			_g_object_unref0 (notebook);
			_g_object_unref0 (unit_vbox);
			_g_object_unref0 (job_vbox);
			_g_object_unref0 (type_hbox);
			_g_object_unref0 (unit_load_hbox);
			_g_object_unref0 (unit_model_filter);
			_g_object_unref0 (scroll);
			_g_object_unref0 (unit_table);
			_g_object_unref0 (job_table);
			_g_object_unref0 (bbox);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_g_object_unref0 (notebook);
	_g_object_unref0 (unit_vbox);
	_g_object_unref0 (job_vbox);
	_g_object_unref0 (type_hbox);
	_g_object_unref0 (unit_load_hbox);
	_g_object_unref0 (unit_model_filter);
	_g_object_unref0 (scroll);
	_g_object_unref0 (unit_table);
	_g_object_unref0 (job_table);
	_g_object_unref0 (bbox);
	return self;
}


#line 105 "systemadm.vala"
MainWindow* main_window_new (GError** error) {
#line 105 "systemadm.vala"
	return main_window_construct (TYPE_MAIN_WINDOW, error);
#line 1353 "systemadm.c"
}


#line 753 "systemadm.vala"
static void _main_window_on_unit_changed_unit_changed (Unit* _sender, gpointer self) {
#line 1359 "systemadm.c"
	main_window_on_unit_changed (self, _sender);
}


static void _vala_ManagerUnitInfo_array_free (ManagerUnitInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			manager_unit_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


#line 320 "systemadm.vala"
void main_window_populate_unit_model (MainWindow* self, GError** error) {
#line 1377 "systemadm.c"
	GError * _inner_error_;
	ManagerUnitInfo* _tmp1_;
	gint _list_size_;
	gint list_length1;
	gint _tmp0_;
	ManagerUnitInfo* list;
#line 320 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 1386 "systemadm.c"
	_inner_error_ = NULL;
#line 321 "systemadm.vala"
	gtk_list_store_clear (self->priv->unit_model);
#line 1390 "systemadm.c"
	list = (_tmp1_ = manager_list_units (self->priv->manager, &_tmp0_, &_inner_error_), list_length1 = _tmp0_, _list_size_ = list_length1, _tmp1_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		ManagerUnitInfo* i_collection;
		int i_collection_length1;
		int i_it;
#line 325 "systemadm.vala"
		i_collection = list;
#line 1408 "systemadm.c"
		i_collection_length1 = list_length1;
		for (i_it = 0; i_it < list_length1; i_it = i_it + 1) {
			ManagerUnitInfo _tmp5_ = {0};
			ManagerUnitInfo i;
			i = (manager_unit_info_copy (&i_collection[i_it], &_tmp5_), _tmp5_);
			{
				GtkTreeIter iter = {0};
				Unit* u;
				char* _tmp2_;
#line 328 "systemadm.vala"
				u = unit_dbus_proxy_new (self->priv->bus, "org.freedesktop.systemd1", i.unit_path);
#line 333 "systemadm.vala"
				g_signal_connect_object (u, "changed", (GCallback) _main_window_on_unit_changed_unit_changed, self, 0);
#line 335 "systemadm.vala"
				gtk_list_store_append (self->priv->unit_model, &iter);
#line 1424 "systemadm.c"
				_tmp2_ = NULL;
#line 342 "systemadm.vala"
				if (_vala_strcmp0 (i.job_type, "") != 0) {
#line 1428 "systemadm.c"
					char* _tmp3_;
#line 342 "systemadm.vala"
					_tmp2_ = (_tmp3_ = g_strdup_printf ("→ %s", i.job_type), _g_free0 (_tmp2_), _tmp3_);
#line 1432 "systemadm.c"
				} else {
					char* _tmp4_;
#line 342 "systemadm.vala"
					_tmp2_ = (_tmp4_ = g_strdup (""), _g_free0 (_tmp2_), _tmp4_);
#line 1437 "systemadm.c"
				}
#line 336 "systemadm.vala"
				gtk_list_store_set (self->priv->unit_model, &iter, 0, i.id, 1, i.description, 2, i.load_state, 3, i.active_state, 4, i.sub_state, 5, _tmp2_, 6, u, -1);
#line 1441 "systemadm.c"
				manager_unit_info_destroy (&i);
				_g_object_unref0 (u);
				_g_free0 (_tmp2_);
			}
		}
	}
	list = (_vala_ManagerUnitInfo_array_free (list, list_length1), NULL);
}


#line 779 "systemadm.vala"
static void _main_window_on_job_changed_job_changed (Job* _sender, gpointer self) {
#line 1454 "systemadm.c"
	main_window_on_job_changed (self, _sender);
}


static void _vala_ManagerJobInfo_array_free (ManagerJobInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			manager_job_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


#line 347 "systemadm.vala"
void main_window_populate_job_model (MainWindow* self, GError** error) {
#line 1472 "systemadm.c"
	GError * _inner_error_;
	ManagerJobInfo* _tmp1_;
	gint _list_size_;
	gint list_length1;
	gint _tmp0_;
	ManagerJobInfo* list;
#line 347 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 1481 "systemadm.c"
	_inner_error_ = NULL;
#line 348 "systemadm.vala"
	gtk_list_store_clear (self->priv->job_model);
#line 1485 "systemadm.c"
	list = (_tmp1_ = manager_list_jobs (self->priv->manager, &_tmp0_, &_inner_error_), list_length1 = _tmp0_, _list_size_ = list_length1, _tmp1_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == DBUS_GERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	{
		ManagerJobInfo* i_collection;
		int i_collection_length1;
		int i_it;
#line 352 "systemadm.vala"
		i_collection = list;
#line 1503 "systemadm.c"
		i_collection_length1 = list_length1;
		for (i_it = 0; i_it < list_length1; i_it = i_it + 1) {
			ManagerJobInfo _tmp4_ = {0};
			ManagerJobInfo i;
			i = (manager_job_info_copy (&i_collection[i_it], &_tmp4_), _tmp4_);
			{
				GtkTreeIter iter = {0};
				Job* j;
				char* _tmp3_;
				char* _tmp2_;
#line 355 "systemadm.vala"
				j = job_dbus_proxy_new (self->priv->bus, "org.freedesktop.systemd1", i.job_path);
#line 360 "systemadm.vala"
				g_signal_connect_object (j, "changed", (GCallback) _main_window_on_job_changed_job_changed, self, 0);
#line 362 "systemadm.vala"
				gtk_list_store_append (self->priv->job_model, &iter);
#line 363 "systemadm.vala"
				gtk_list_store_set (self->priv->job_model, &iter, 0, _tmp2_ = g_strdup_printf ("%u", (guint) i.id), 1, i.name, 2, _tmp3_ = g_strdup_printf ("→ %s", i.type), 3, i.state, 4, j, 5, i.id, -1);
#line 1522 "systemadm.c"
				_g_free0 (_tmp3_);
				_g_free0 (_tmp2_);
				manager_job_info_destroy (&i);
				_g_object_unref0 (j);
			}
		}
	}
	list = (_vala_ManagerJobInfo_array_free (list, list_length1), NULL);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 373 "systemadm.vala"
Unit* main_window_get_current_unit (MainWindow* self) {
#line 1541 "systemadm.c"
	Unit* result = NULL;
	GtkTreePath* p;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	Unit* u;
#line 373 "systemadm.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1551 "systemadm.c"
	p = NULL;
#line 375 "systemadm.vala"
	gtk_tree_view_get_cursor (self->priv->unit_view, &_tmp0_, NULL);
#line 375 "systemadm.vala"
	p = (_tmp1_ = _tmp0_, _gtk_tree_path_free0 (p), _tmp1_);
#line 377 "systemadm.vala"
	if (p == NULL) {
#line 1559 "systemadm.c"
		result = NULL;
		_gtk_tree_path_free0 (p);
#line 378 "systemadm.vala"
		return result;
#line 1564 "systemadm.c"
	}
#line 380 "systemadm.vala"
	model = _g_object_ref0 (gtk_tree_view_get_model (self->priv->unit_view));
#line 1568 "systemadm.c"
	u = NULL;
#line 384 "systemadm.vala"
	gtk_tree_model_get_iter (model, &iter, p);
#line 385 "systemadm.vala"
	gtk_tree_model_get (model, &iter, 6, &u, -1);
#line 1574 "systemadm.c"
	result = u;
	_gtk_tree_path_free0 (p);
	_g_object_unref0 (model);
#line 387 "systemadm.vala"
	return result;
#line 1580 "systemadm.c"
}


#line 390 "systemadm.vala"
void main_window_unit_changed (MainWindow* self) {
#line 1586 "systemadm.c"
	Unit* u;
#line 390 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 391 "systemadm.vala"
	u = main_window_get_current_unit (self);
#line 393 "systemadm.vala"
	if (u == NULL) {
#line 394 "systemadm.vala"
		main_window_clear_unit (self);
#line 1596 "systemadm.c"
	} else {
#line 396 "systemadm.vala"
		main_window_show_unit (self, u);
#line 1600 "systemadm.c"
	}
	_g_object_unref0 (u);
}


#line 399 "systemadm.vala"
void main_window_clear_unit (MainWindow* self) {
#line 1608 "systemadm.c"
	char* _tmp0_;
#line 399 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 400 "systemadm.vala"
	self->priv->current_unit_id = (_tmp0_ = NULL, _g_free0 (self->priv->current_unit_id), _tmp0_);
#line 402 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->start_button, FALSE);
#line 403 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->stop_button, FALSE);
#line 404 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->reload_button, FALSE);
#line 405 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->restart_button, FALSE);
#line 407 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_id_label, NULL);
#line 408 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_aliases_label, NULL);
#line 409 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_description_label, NULL);
#line 410 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_description_label, NULL);
#line 411 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_load_state_label, NULL);
#line 412 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_active_state_label, NULL);
#line 413 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_sub_state_label, NULL);
#line 414 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_fragment_path_label, NULL);
#line 415 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_active_enter_timestamp_label, NULL);
#line 416 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_active_exit_timestamp_label, NULL);
#line 417 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_can_reload_label, NULL);
#line 418 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_can_start_label, NULL);
#line 419 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_cgroup_label, NULL);
#line 1648 "systemadm.c"
}


#line 422 "systemadm.vala"
char* main_window_make_dependency_string (MainWindow* self, const char* prefix, const char* word, char** dependencies, int dependencies_length1) {
#line 1654 "systemadm.c"
	char* result = NULL;
	gboolean first;
	char* r;
#line 422 "systemadm.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 422 "systemadm.vala"
	g_return_val_if_fail (word != NULL, NULL);
#line 423 "systemadm.vala"
	first = TRUE;
#line 1664 "systemadm.c"
	r = NULL;
#line 426 "systemadm.vala"
	if (prefix == NULL) {
#line 1668 "systemadm.c"
		char* _tmp0_;
#line 427 "systemadm.vala"
		r = (_tmp0_ = g_strdup (""), _g_free0 (r), _tmp0_);
#line 1672 "systemadm.c"
	} else {
		char* _tmp1_;
#line 429 "systemadm.vala"
		r = (_tmp1_ = g_strdup (prefix), _g_free0 (r), _tmp1_);
#line 1677 "systemadm.c"
	}
	{
		char** i_collection;
		int i_collection_length1;
		int i_it;
#line 431 "systemadm.vala"
		i_collection = dependencies;
#line 1685 "systemadm.c"
		i_collection_length1 = dependencies_length1;
		for (i_it = 0; i_it < dependencies_length1; i_it = i_it + 1) {
			char* i;
			i = g_strdup (i_collection[i_it]);
			{
				char* _tmp9_;
				char* _tmp8_;
				char* _tmp7_;
				char* _tmp6_;
				char* _tmp5_;
#line 432 "systemadm.vala"
				if (_vala_strcmp0 (r, "") != 0) {
#line 1698 "systemadm.c"
					const char* _tmp2_;
					char* _tmp3_;
					_tmp2_ = NULL;
#line 433 "systemadm.vala"
					if (first) {
#line 433 "systemadm.vala"
						_tmp2_ = "\n";
#line 1706 "systemadm.c"
					} else {
#line 433 "systemadm.vala"
						_tmp2_ = ",";
#line 1710 "systemadm.c"
					}
#line 433 "systemadm.vala"
					r = (_tmp3_ = g_strconcat (r, _tmp2_, NULL), _g_free0 (r), _tmp3_);
#line 1714 "systemadm.c"
				}
#line 435 "systemadm.vala"
				if (first) {
#line 1718 "systemadm.c"
					char* _tmp4_;
#line 436 "systemadm.vala"
					r = (_tmp4_ = g_strconcat (r, word, NULL), _g_free0 (r), _tmp4_);
#line 437 "systemadm.vala"
					first = FALSE;
#line 1724 "systemadm.c"
				}
#line 440 "systemadm.vala"
				r = (_tmp9_ = g_strconcat (r, _tmp8_ = g_strconcat (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat (_tmp5_ = g_strconcat (" <a href=\"", i, NULL), "\">", NULL), i, NULL), "</a>", NULL), NULL), _g_free0 (r), _tmp9_);
#line 1728 "systemadm.c"
				_g_free0 (_tmp8_);
				_g_free0 (_tmp7_);
				_g_free0 (_tmp6_);
				_g_free0 (_tmp5_);
				_g_free0 (i);
			}
		}
	}
	result = r;
#line 443 "systemadm.vala"
	return result;
#line 1740 "systemadm.c"
}


#line 2149 "glib-2.0.vapi"
static void g_time_local (time_t time, struct tm* result) {
#line 1746 "systemadm.c"
	struct tm _result_ = {0};
#line 2151 "glib-2.0.vapi"
	localtime_r (&time, &_result_);
#line 1750 "systemadm.c"
	*result = _result_;
#line 2152 "glib-2.0.vapi"
	return;
#line 1754 "systemadm.c"
}


#line 2159 "glib-2.0.vapi"
static char* g_time_format (struct tm *self, const char* format) {
#line 1760 "systemadm.c"
	char* result = NULL;
	gchar* _tmp0_;
	gint _buffer_size_;
	gint buffer_length1;
	gchar* buffer;
#line 2159 "glib-2.0.vapi"
	g_return_val_if_fail (format != NULL, NULL);
#line 1768 "systemadm.c"
	buffer = (_tmp0_ = g_new0 (gchar, 64), buffer_length1 = 64, _buffer_size_ = buffer_length1, _tmp0_);
#line 2161 "glib-2.0.vapi"
	strftime (buffer, buffer_length1, format, &(*self));
#line 1772 "systemadm.c"
	result = g_strdup ((const char*) buffer);
	buffer = (g_free (buffer), NULL);
#line 2162 "glib-2.0.vapi"
	return result;
#line 1777 "systemadm.c"
}


#line 446 "systemadm.vala"
void main_window_show_unit (MainWindow* self, Unit* unit) {
#line 1783 "systemadm.c"
	char* _tmp0_;
	char* a;
	char** _tmp6_;
	gint _requires_size_;
	gint requires_length1;
	gint _tmp5_;
	char** requires;
	char** _tmp8_;
	gint _requires_overridable_size_;
	gint requires_overridable_length1;
	gint _tmp7_;
	char** requires_overridable;
	char** _tmp10_;
	gint _requisite_size_;
	gint requisite_length1;
	gint _tmp9_;
	char** requisite;
	char** _tmp12_;
	gint _requisite_overridable_size_;
	gint requisite_overridable_length1;
	gint _tmp11_;
	char** requisite_overridable;
	char** _tmp14_;
	gint _wants_size_;
	gint wants_length1;
	gint _tmp13_;
	char** wants;
	char** _tmp16_;
	gint _required_by_size_;
	gint required_by_length1;
	gint _tmp15_;
	char** required_by;
	char** _tmp18_;
	gint _required_by_overridable_size_;
	gint required_by_overridable_length1;
	gint _tmp17_;
	char** required_by_overridable;
	char** _tmp20_;
	gint _wanted_by_size_;
	gint wanted_by_length1;
	gint _tmp19_;
	char** wanted_by;
	char** _tmp22_;
	gint _conflicts_size_;
	gint conflicts_length1;
	gint _tmp21_;
	char** conflicts;
	char** _tmp24_;
	gint _before_size_;
	gint before_length1;
	gint _tmp23_;
	char** before;
	char** _tmp26_;
	gint _after_size_;
	gint after_length1;
	gint _tmp25_;
	char** after;
	char* _tmp37_;
	char* _tmp36_;
	char* _tmp35_;
	char* _tmp34_;
	char* _tmp33_;
	char* _tmp32_;
	char* _tmp31_;
	char* _tmp30_;
	char* _tmp29_;
	char* _tmp28_;
	char* _tmp27_;
	char* _tmp38_;
	char* _tmp39_;
	char* _tmp40_;
	char* _tmp41_;
	char* fp;
	guint64 t;
	gboolean b;
	const char* _tmp50_;
	const char* _tmp51_;
	char* _tmp52_;
#line 446 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 446 "systemadm.vala"
	g_return_if_fail (unit != NULL);
#line 447 "systemadm.vala"
	self->priv->current_unit_id = (_tmp0_ = unit_get_id (unit), _g_free0 (self->priv->current_unit_id), _tmp0_);
#line 449 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_id_label, self->priv->current_unit_id);
#line 451 "systemadm.vala"
	a = g_strdup ("");
#line 1872 "systemadm.c"
	{
		gint _tmp1_;
		char** i_collection;
		int i_collection_length1;
		int i_it;
#line 452 "systemadm.vala"
		i_collection = unit_get_names (unit, &_tmp1_);
#line 1880 "systemadm.c"
		i_collection_length1 = _tmp1_;
		for (i_it = 0; i_it < _tmp1_; i_it = i_it + 1) {
			char* i;
			i = g_strdup (i_collection[i_it]);
			{
#line 453 "systemadm.vala"
				if (_vala_strcmp0 (i, self->priv->current_unit_id) == 0) {
#line 1888 "systemadm.c"
					_g_free0 (i);
#line 454 "systemadm.vala"
					continue;
#line 1892 "systemadm.c"
				}
#line 456 "systemadm.vala"
				if (_vala_strcmp0 (a, "") == 0) {
#line 1896 "systemadm.c"
					char* _tmp2_;
#line 457 "systemadm.vala"
					a = (_tmp2_ = g_strdup (i), _g_free0 (a), _tmp2_);
#line 1900 "systemadm.c"
				} else {
					char* _tmp4_;
					char* _tmp3_;
#line 459 "systemadm.vala"
					a = (_tmp4_ = g_strconcat (a, _tmp3_ = g_strconcat ("\n", i, NULL), NULL), _g_free0 (a), _tmp4_);
#line 1906 "systemadm.c"
					_g_free0 (_tmp3_);
				}
				_g_free0 (i);
			}
		}
#line 452 "systemadm.vala"
		i_collection = (_vala_array_free (i_collection, i_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1914 "systemadm.c"
	}
#line 462 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_aliases_label, a);
#line 1918 "systemadm.c"
	requires = (_tmp6_ = unit_get_requires (unit, &_tmp5_), requires_length1 = _tmp5_, _requires_size_ = requires_length1, _tmp6_);
	requires_overridable = (_tmp8_ = unit_get_requires_overridable (unit, &_tmp7_), requires_overridable_length1 = _tmp7_, _requires_overridable_size_ = requires_overridable_length1, _tmp8_);
	requisite = (_tmp10_ = unit_get_requisite (unit, &_tmp9_), requisite_length1 = _tmp9_, _requisite_size_ = requisite_length1, _tmp10_);
	requisite_overridable = (_tmp12_ = unit_get_requisite_overridable (unit, &_tmp11_), requisite_overridable_length1 = _tmp11_, _requisite_overridable_size_ = requisite_overridable_length1, _tmp12_);
	wants = (_tmp14_ = unit_get_wants (unit, &_tmp13_), wants_length1 = _tmp13_, _wants_size_ = wants_length1, _tmp14_);
	required_by = (_tmp16_ = unit_get_required_by (unit, &_tmp15_), required_by_length1 = _tmp15_, _required_by_size_ = required_by_length1, _tmp16_);
	required_by_overridable = (_tmp18_ = unit_get_required_by_overridable (unit, &_tmp17_), required_by_overridable_length1 = _tmp17_, _required_by_overridable_size_ = required_by_overridable_length1, _tmp18_);
	wanted_by = (_tmp20_ = unit_get_wanted_by (unit, &_tmp19_), wanted_by_length1 = _tmp19_, _wanted_by_size_ = wanted_by_length1, _tmp20_);
	conflicts = (_tmp22_ = unit_get_conflicts (unit, &_tmp21_), conflicts_length1 = _tmp21_, _conflicts_size_ = conflicts_length1, _tmp22_);
	before = (_tmp24_ = unit_get_before (unit, &_tmp23_), before_length1 = _tmp23_, _before_size_ = before_length1, _tmp24_);
	after = (_tmp26_ = unit_get_after (unit, &_tmp25_), after_length1 = _tmp25_, _after_size_ = after_length1, _tmp26_);
#line 477 "systemadm.vala"
	right_label_set_markup_or_na (self->priv->unit_dependency_label, _tmp37_ = main_window_make_dependency_string (self, _tmp36_ = main_window_make_dependency_string (self, _tmp35_ = main_window_make_dependency_string (self, _tmp34_ = main_window_make_dependency_string (self, _tmp33_ = main_window_make_dependency_string (self, _tmp32_ = main_window_make_dependency_string (self, _tmp31_ = main_window_make_dependency_string (self, _tmp30_ = main_window_make_dependency_string (self, _tmp29_ = main_window_make_dependency_string (self, _tmp28_ = main_window_make_dependency_string (self, _tmp27_ = main_window_make_dependency_string (self, NULL, "requires", requires, requires_length1), "overridable requires", requires_overridable, requires_overridable_length1), "requisite", requisite, requisite_length1), "overridable requisite", requisite_overridable, requisite_overridable_length1), "wants", wants, wants_length1), "conflicts", conflicts, conflicts_length1), "required by", required_by, required_by_length1), "overridable required by", required_by_overridable, required_by_overridable_length1), "wanted by", wanted_by, wanted_by_length1), "after", after, after_length1), "before", before, before_length1));
#line 1932 "systemadm.c"
	_g_free0 (_tmp37_);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp34_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp29_);
	_g_free0 (_tmp28_);
	_g_free0 (_tmp27_);
#line 501 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_description_label, _tmp38_ = unit_get_description (unit));
#line 1946 "systemadm.c"
	_g_free0 (_tmp38_);
#line 502 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_load_state_label, _tmp39_ = unit_get_load_state (unit));
#line 1950 "systemadm.c"
	_g_free0 (_tmp39_);
#line 503 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_active_state_label, _tmp40_ = unit_get_active_state (unit));
#line 1954 "systemadm.c"
	_g_free0 (_tmp40_);
#line 504 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_sub_state_label, _tmp41_ = unit_get_sub_state (unit));
#line 1958 "systemadm.c"
	_g_free0 (_tmp41_);
#line 506 "systemadm.vala"
	fp = unit_get_fragment_path (unit);
#line 507 "systemadm.vala"
	if (_vala_strcmp0 (fp, "") != 0) {
#line 1964 "systemadm.c"
		char* _tmp45_;
		char* _tmp44_;
		char* _tmp43_;
		char* _tmp42_;
#line 508 "systemadm.vala"
		right_label_set_markup_or_na (self->priv->unit_fragment_path_label, _tmp45_ = g_strconcat (_tmp44_ = g_strconcat (_tmp43_ = g_strconcat (_tmp42_ = g_strconcat ("<a href=\"file://", fp, NULL), "\">", NULL), fp, NULL), "</a>", NULL));
#line 1971 "systemadm.c"
		_g_free0 (_tmp45_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp42_);
	} else {
#line 510 "systemadm.vala"
		right_label_set_text_or_na (self->priv->unit_fragment_path_label, NULL);
#line 1979 "systemadm.c"
	}
#line 512 "systemadm.vala"
	t = unit_get_active_enter_timestamp (unit);
#line 513 "systemadm.vala"
	if (t > 0) {
#line 1985 "systemadm.c"
		struct tm _tmp46_ = {0};
		struct tm timestamp;
		char* _tmp47_;
#line 514 "systemadm.vala"
		timestamp = (g_time_local ((time_t) (t / 1000000), &_tmp46_), _tmp46_);
#line 515 "systemadm.vala"
		right_label_set_text_or_na (self->priv->unit_active_enter_timestamp_label, _tmp47_ = g_time_format (&timestamp, "%a, %d %b %Y %H:%M:%S %z"));
#line 1993 "systemadm.c"
		_g_free0 (_tmp47_);
	} else {
#line 517 "systemadm.vala"
		right_label_set_text_or_na (self->priv->unit_active_enter_timestamp_label, NULL);
#line 1998 "systemadm.c"
	}
#line 519 "systemadm.vala"
	t = unit_get_active_exit_timestamp (unit);
#line 520 "systemadm.vala"
	if (t > 0) {
#line 2004 "systemadm.c"
		struct tm _tmp48_ = {0};
		struct tm timestamp;
		char* _tmp49_;
#line 521 "systemadm.vala"
		timestamp = (g_time_local ((time_t) (t / 1000000), &_tmp48_), _tmp48_);
#line 522 "systemadm.vala"
		right_label_set_text_or_na (self->priv->unit_active_exit_timestamp_label, _tmp49_ = g_time_format (&timestamp, "%a, %d %b %Y %H:%M:%S %z"));
#line 2012 "systemadm.c"
		_g_free0 (_tmp49_);
	} else {
#line 524 "systemadm.vala"
		right_label_set_text_or_na (self->priv->unit_active_exit_timestamp_label, NULL);
#line 2017 "systemadm.c"
	}
#line 526 "systemadm.vala"
	b = unit_get_can_start (unit);
#line 527 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->start_button, b);
#line 528 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->stop_button, b);
#line 529 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->restart_button, b);
#line 2027 "systemadm.c"
	_tmp50_ = NULL;
#line 530 "systemadm.vala"
	if (b) {
#line 530 "systemadm.vala"
		_tmp50_ = "Yes";
#line 2033 "systemadm.c"
	} else {
#line 530 "systemadm.vala"
		_tmp50_ = "No";
#line 2037 "systemadm.c"
	}
#line 530 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_can_start_label, _tmp50_);
#line 532 "systemadm.vala"
	b = unit_get_can_reload (unit);
#line 533 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->reload_button, b);
#line 2045 "systemadm.c"
	_tmp51_ = NULL;
#line 534 "systemadm.vala"
	if (b) {
#line 534 "systemadm.vala"
		_tmp51_ = "Yes";
#line 2051 "systemadm.c"
	} else {
#line 534 "systemadm.vala"
		_tmp51_ = "No";
#line 2055 "systemadm.c"
	}
#line 534 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_can_reload_label, _tmp51_);
#line 536 "systemadm.vala"
	right_label_set_text_or_na (self->priv->unit_cgroup_label, _tmp52_ = unit_get_default_control_group (unit));
#line 2061 "systemadm.c"
	_g_free0 (_tmp52_);
	_g_free0 (a);
	requires = (_vala_array_free (requires, requires_length1, (GDestroyNotify) g_free), NULL);
	requires_overridable = (_vala_array_free (requires_overridable, requires_overridable_length1, (GDestroyNotify) g_free), NULL);
	requisite = (_vala_array_free (requisite, requisite_length1, (GDestroyNotify) g_free), NULL);
	requisite_overridable = (_vala_array_free (requisite_overridable, requisite_overridable_length1, (GDestroyNotify) g_free), NULL);
	wants = (_vala_array_free (wants, wants_length1, (GDestroyNotify) g_free), NULL);
	required_by = (_vala_array_free (required_by, required_by_length1, (GDestroyNotify) g_free), NULL);
	required_by_overridable = (_vala_array_free (required_by_overridable, required_by_overridable_length1, (GDestroyNotify) g_free), NULL);
	wanted_by = (_vala_array_free (wanted_by, wanted_by_length1, (GDestroyNotify) g_free), NULL);
	conflicts = (_vala_array_free (conflicts, conflicts_length1, (GDestroyNotify) g_free), NULL);
	before = (_vala_array_free (before, before_length1, (GDestroyNotify) g_free), NULL);
	after = (_vala_array_free (after, after_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (fp);
}


#line 539 "systemadm.vala"
Job* main_window_get_current_job (MainWindow* self) {
#line 2081 "systemadm.c"
	Job* result = NULL;
	GtkTreePath* p;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp0_ = NULL;
	GtkTreeIter iter = {0};
	GtkTreeModel* model;
	Job* j = NULL;
#line 539 "systemadm.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 2091 "systemadm.c"
	p = NULL;
#line 541 "systemadm.vala"
	gtk_tree_view_get_cursor (self->priv->job_view, &_tmp0_, NULL);
#line 541 "systemadm.vala"
	p = (_tmp1_ = _tmp0_, _gtk_tree_path_free0 (p), _tmp1_);
#line 543 "systemadm.vala"
	if (p == NULL) {
#line 2099 "systemadm.c"
		result = NULL;
		_gtk_tree_path_free0 (p);
#line 544 "systemadm.vala"
		return result;
#line 2104 "systemadm.c"
	}
#line 547 "systemadm.vala"
	model = _g_object_ref0 (gtk_tree_view_get_model (self->priv->job_view));
#line 550 "systemadm.vala"
	gtk_tree_model_get_iter (model, &iter, p);
#line 551 "systemadm.vala"
	gtk_tree_model_get (model, &iter, 4, &j, -1);
#line 2112 "systemadm.c"
	result = _g_object_ref0 (j);
	_gtk_tree_path_free0 (p);
	_g_object_unref0 (model);
#line 553 "systemadm.vala"
	return result;
#line 2118 "systemadm.c"
}


#line 556 "systemadm.vala"
void main_window_job_changed (MainWindow* self) {
#line 2124 "systemadm.c"
	Job* j;
#line 556 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 557 "systemadm.vala"
	j = main_window_get_current_job (self);
#line 559 "systemadm.vala"
	if (j == NULL) {
#line 560 "systemadm.vala"
		main_window_clear_job (self);
#line 2134 "systemadm.c"
	} else {
#line 562 "systemadm.vala"
		main_window_show_job (self, j);
#line 2138 "systemadm.c"
	}
	_g_object_unref0 (j);
}


#line 565 "systemadm.vala"
void main_window_clear_job (MainWindow* self) {
#line 565 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 566 "systemadm.vala"
	self->priv->current_job_id = (guint32) 0;
#line 568 "systemadm.vala"
	right_label_set_text_or_na (self->priv->job_id_label, NULL);
#line 569 "systemadm.vala"
	right_label_set_text_or_na (self->priv->job_state_label, NULL);
#line 570 "systemadm.vala"
	right_label_set_text_or_na (self->priv->job_type_label, NULL);
#line 572 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->cancel_button, FALSE);
#line 2158 "systemadm.c"
}


#line 575 "systemadm.vala"
void main_window_show_job (MainWindow* self, Job* job) {
#line 2164 "systemadm.c"
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
#line 575 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 575 "systemadm.vala"
	g_return_if_fail (job != NULL);
#line 576 "systemadm.vala"
	self->priv->current_job_id = job_get_id (job);
#line 578 "systemadm.vala"
	right_label_set_text_or_na (self->priv->job_id_label, _tmp0_ = g_strdup_printf ("%u", (guint) self->priv->current_job_id));
#line 2176 "systemadm.c"
	_g_free0 (_tmp0_);
#line 579 "systemadm.vala"
	right_label_set_text_or_na (self->priv->job_state_label, _tmp1_ = job_get_state (job));
#line 2180 "systemadm.c"
	_g_free0 (_tmp1_);
#line 580 "systemadm.vala"
	right_label_set_text_or_na (self->priv->job_type_label, _tmp2_ = job_get_job_type (job));
#line 2184 "systemadm.c"
	_g_free0 (_tmp2_);
#line 582 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->cancel_button, TRUE);
#line 2188 "systemadm.c"
}


#line 585 "systemadm.vala"
void main_window_on_start (MainWindow* self) {
#line 2194 "systemadm.c"
	GError * _inner_error_;
	Unit* u;
#line 585 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 2199 "systemadm.c"
	_inner_error_ = NULL;
#line 586 "systemadm.vala"
	u = main_window_get_current_unit (self);
#line 588 "systemadm.vala"
	if (u == NULL) {
#line 2205 "systemadm.c"
		_g_object_unref0 (u);
#line 589 "systemadm.vala"
		return;
#line 2209 "systemadm.c"
	}
	{
		char* _tmp0_;
#line 592 "systemadm.vala"
		_tmp0_ = unit_start (u, "replace", &_inner_error_);
#line 2215 "systemadm.c"
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			_g_object_unref0 (u);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 594 "systemadm.vala"
			main_window_show_error (self, e->message);
#line 2236 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (u);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (u);
}


#line 598 "systemadm.vala"
void main_window_on_stop (MainWindow* self) {
#line 2253 "systemadm.c"
	GError * _inner_error_;
	Unit* u;
#line 598 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 2258 "systemadm.c"
	_inner_error_ = NULL;
#line 599 "systemadm.vala"
	u = main_window_get_current_unit (self);
#line 601 "systemadm.vala"
	if (u == NULL) {
#line 2264 "systemadm.c"
		_g_object_unref0 (u);
#line 602 "systemadm.vala"
		return;
#line 2268 "systemadm.c"
	}
	{
		char* _tmp0_;
#line 605 "systemadm.vala"
		_tmp0_ = unit_stop (u, "replace", &_inner_error_);
#line 2274 "systemadm.c"
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch1_dbus_gerror;
			}
			_g_object_unref0 (u);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 607 "systemadm.vala"
			main_window_show_error (self, e->message);
#line 2295 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (u);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (u);
}


#line 611 "systemadm.vala"
void main_window_on_reload (MainWindow* self) {
#line 2312 "systemadm.c"
	GError * _inner_error_;
	Unit* u;
#line 611 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 2317 "systemadm.c"
	_inner_error_ = NULL;
#line 612 "systemadm.vala"
	u = main_window_get_current_unit (self);
#line 614 "systemadm.vala"
	if (u == NULL) {
#line 2323 "systemadm.c"
		_g_object_unref0 (u);
#line 615 "systemadm.vala"
		return;
#line 2327 "systemadm.c"
	}
	{
		char* _tmp0_;
#line 618 "systemadm.vala"
		_tmp0_ = unit_reload (u, "replace", &_inner_error_);
#line 2333 "systemadm.c"
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch2_dbus_gerror;
			}
			_g_object_unref0 (u);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally2;
	__catch2_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 620 "systemadm.vala"
			main_window_show_error (self, e->message);
#line 2354 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (u);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (u);
}


#line 624 "systemadm.vala"
void main_window_on_restart (MainWindow* self) {
#line 2371 "systemadm.c"
	GError * _inner_error_;
	Unit* u;
#line 624 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 2376 "systemadm.c"
	_inner_error_ = NULL;
#line 625 "systemadm.vala"
	u = main_window_get_current_unit (self);
#line 627 "systemadm.vala"
	if (u == NULL) {
#line 2382 "systemadm.c"
		_g_object_unref0 (u);
#line 628 "systemadm.vala"
		return;
#line 2386 "systemadm.c"
	}
	{
		char* _tmp0_;
#line 631 "systemadm.vala"
		_tmp0_ = unit_restart (u, "replace", &_inner_error_);
#line 2392 "systemadm.c"
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch3_dbus_gerror;
			}
			_g_object_unref0 (u);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally3;
	__catch3_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 633 "systemadm.vala"
			main_window_show_error (self, e->message);
#line 2413 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (u);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (u);
}


#line 637 "systemadm.vala"
void main_window_on_cancel (MainWindow* self) {
#line 2430 "systemadm.c"
	GError * _inner_error_;
	Job* j;
#line 637 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 2435 "systemadm.c"
	_inner_error_ = NULL;
#line 638 "systemadm.vala"
	j = main_window_get_current_job (self);
#line 640 "systemadm.vala"
	if (j == NULL) {
#line 2441 "systemadm.c"
		_g_object_unref0 (j);
#line 641 "systemadm.vala"
		return;
#line 2445 "systemadm.c"
	}
	{
#line 644 "systemadm.vala"
		job_cancel (j, &_inner_error_);
#line 2450 "systemadm.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch4_dbus_gerror;
			}
			_g_object_unref0 (j);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally4;
	__catch4_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 646 "systemadm.vala"
			main_window_show_error (self, e->message);
#line 2470 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (j);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (j);
}


#line 650 "systemadm.vala"
void main_window_update_unit_iter (MainWindow* self, GtkTreeIter* iter, const char* id, Unit* u) {
#line 2487 "systemadm.c"
	char* t;
	UnitJobLink _tmp0_ = {0};
	UnitJobLink jl;
	char* _tmp2_;
	char* _tmp8_;
	char* _tmp7_;
	char* _tmp6_;
	char* _tmp5_;
#line 650 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 650 "systemadm.vala"
	g_return_if_fail (id != NULL);
#line 650 "systemadm.vala"
	g_return_if_fail (u != NULL);
#line 652 "systemadm.vala"
	t = g_strdup ("");
#line 653 "systemadm.vala"
	jl = (unit_get_job (u, &_tmp0_), _tmp0_);
#line 655 "systemadm.vala"
	if (jl.id != 0) {
#line 2508 "systemadm.c"
		Job* j;
		char* _tmp1_;
#line 656 "systemadm.vala"
		j = job_dbus_proxy_new (self->priv->bus, "org.freedesktop.systemd1", jl.path);
#line 661 "systemadm.vala"
		t = (_tmp1_ = job_get_job_type (j), _g_free0 (t), _tmp1_);
#line 2515 "systemadm.c"
		_g_object_unref0 (j);
	}
	_tmp2_ = NULL;
#line 670 "systemadm.vala"
	if (_vala_strcmp0 (t, "") != 0) {
#line 2521 "systemadm.c"
		char* _tmp3_;
#line 670 "systemadm.vala"
		_tmp2_ = (_tmp3_ = g_strdup_printf ("→ %s", t), _g_free0 (_tmp2_), _tmp3_);
#line 2525 "systemadm.c"
	} else {
		char* _tmp4_;
#line 670 "systemadm.vala"
		_tmp2_ = (_tmp4_ = g_strdup (""), _g_free0 (_tmp2_), _tmp4_);
#line 2530 "systemadm.c"
	}
#line 664 "systemadm.vala"
	gtk_list_store_set (self->priv->unit_model, iter, 0, id, 1, _tmp5_ = unit_get_description (u), 2, _tmp6_ = unit_get_load_state (u), 3, _tmp7_ = unit_get_active_state (u), 4, _tmp8_ = unit_get_sub_state (u), 5, _tmp2_, 6, u, -1);
#line 2534 "systemadm.c"
	_g_free0 (_tmp8_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp5_);
	_g_free0 (t);
	unit_job_link_destroy (&jl);
	_g_free0 (_tmp2_);
}


#line 674 "systemadm.vala"
void main_window_on_unit_new (MainWindow* self, const char* id, const char* path) {
#line 2547 "systemadm.c"
	Unit* u;
	GtkTreeIter iter = {0};
#line 674 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 674 "systemadm.vala"
	g_return_if_fail (id != NULL);
#line 674 "systemadm.vala"
	g_return_if_fail (path != NULL);
#line 675 "systemadm.vala"
	u = unit_dbus_proxy_new (self->priv->bus, "org.freedesktop.systemd1", path);
#line 680 "systemadm.vala"
	g_signal_connect_object (u, "changed", (GCallback) _main_window_on_unit_changed_unit_changed, self, 0);
#line 683 "systemadm.vala"
	gtk_list_store_append (self->priv->unit_model, &iter);
#line 684 "systemadm.vala"
	main_window_update_unit_iter (self, &iter, id, u);
#line 2564 "systemadm.c"
	_g_object_unref0 (u);
}


#line 687 "systemadm.vala"
void main_window_update_job_iter (MainWindow* self, GtkTreeIter* iter, guint32 id, Job* j) {
#line 2571 "systemadm.c"
	char* _tmp5_;
	char* _tmp4_;
	char* _tmp3_;
	JobUnitLink _tmp2_;
	char* _tmp0_;
	JobUnitLink _tmp1_ = {0};
#line 687 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 687 "systemadm.vala"
	g_return_if_fail (j != NULL);
#line 688 "systemadm.vala"
	gtk_list_store_set (self->priv->job_model, iter, 0, _tmp0_ = g_strdup_printf ("%u", (guint) id), 1, (_tmp2_ = (job_get_unit (j, &_tmp1_), _tmp1_)).id, 2, _tmp4_ = g_strdup_printf ("→ %s", _tmp3_ = job_get_job_type (j)), 3, _tmp5_ = job_get_state (j), 4, j, 5, id, -1);
#line 2584 "systemadm.c"
	_g_free0 (_tmp5_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp3_);
	job_unit_link_destroy (&_tmp2_);
	_g_free0 (_tmp0_);
}


#line 697 "systemadm.vala"
void main_window_on_job_new (MainWindow* self, guint32 id, const char* path) {
#line 2595 "systemadm.c"
	Job* j;
	GtkTreeIter iter = {0};
#line 697 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 697 "systemadm.vala"
	g_return_if_fail (path != NULL);
#line 698 "systemadm.vala"
	j = job_dbus_proxy_new (self->priv->bus, "org.freedesktop.systemd1", path);
#line 703 "systemadm.vala"
	g_signal_connect_object (j, "changed", (GCallback) _main_window_on_job_changed_job_changed, self, 0);
#line 706 "systemadm.vala"
	gtk_list_store_append (self->priv->job_model, &iter);
#line 707 "systemadm.vala"
	main_window_update_job_iter (self, &iter, id, j);
#line 2610 "systemadm.c"
	_g_object_unref0 (j);
}


#line 710 "systemadm.vala"
void main_window_on_unit_removed (MainWindow* self, const char* id, const char* path) {
#line 2617 "systemadm.c"
	GtkTreeIter iter = {0};
#line 710 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 710 "systemadm.vala"
	g_return_if_fail (id != NULL);
#line 710 "systemadm.vala"
	g_return_if_fail (path != NULL);
#line 712 "systemadm.vala"
	if (!gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->unit_model, &iter)) {
#line 713 "systemadm.vala"
		return;
#line 2629 "systemadm.c"
	}
	{
		gboolean _tmp0_;
#line 715 "systemadm.vala"
		_tmp0_ = TRUE;
#line 715 "systemadm.vala"
		while (TRUE) {
#line 2637 "systemadm.c"
			char* name;
#line 715 "systemadm.vala"
			if (!_tmp0_) {
#line 728 "systemadm.vala"
				if (!gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->unit_model, &iter)) {
#line 728 "systemadm.vala"
					break;
#line 2645 "systemadm.c"
				}
			}
#line 715 "systemadm.vala"
			_tmp0_ = FALSE;
#line 2650 "systemadm.c"
			name = NULL;
#line 718 "systemadm.vala"
			gtk_tree_model_get ((GtkTreeModel*) self->priv->unit_model, &iter, 0, &name, -1);
#line 720 "systemadm.vala"
			if (_vala_strcmp0 (id, name) == 0) {
#line 721 "systemadm.vala"
				if (_vala_strcmp0 (self->priv->current_unit_id, name) == 0) {
#line 722 "systemadm.vala"
					main_window_clear_unit (self);
#line 2660 "systemadm.c"
				}
#line 724 "systemadm.vala"
				gtk_list_store_remove (self->priv->unit_model, &iter);
#line 2664 "systemadm.c"
				_g_free0 (name);
#line 725 "systemadm.vala"
				break;
#line 2668 "systemadm.c"
			}
			_g_free0 (name);
		}
	}
}


#line 731 "systemadm.vala"
void main_window_on_job_removed (MainWindow* self, guint32 id, const char* path, gboolean success) {
#line 2678 "systemadm.c"
	GtkTreeIter iter = {0};
#line 731 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 731 "systemadm.vala"
	g_return_if_fail (path != NULL);
#line 733 "systemadm.vala"
	if (!gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->job_model, &iter)) {
#line 734 "systemadm.vala"
		return;
#line 2688 "systemadm.c"
	}
	{
		gboolean _tmp0_;
#line 736 "systemadm.vala"
		_tmp0_ = TRUE;
#line 736 "systemadm.vala"
		while (TRUE) {
#line 2696 "systemadm.c"
			guint32 j = 0U;
#line 736 "systemadm.vala"
			if (!_tmp0_) {
#line 750 "systemadm.vala"
				if (!gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->job_model, &iter)) {
#line 750 "systemadm.vala"
					break;
#line 2704 "systemadm.c"
				}
			}
#line 736 "systemadm.vala"
			_tmp0_ = FALSE;
#line 739 "systemadm.vala"
			gtk_tree_model_get ((GtkTreeModel*) self->priv->job_model, &iter, 5, &j, -1);
#line 741 "systemadm.vala"
			if (id == j) {
#line 742 "systemadm.vala"
				if (self->priv->current_job_id == j) {
#line 743 "systemadm.vala"
					main_window_clear_job (self);
#line 2717 "systemadm.c"
				}
#line 745 "systemadm.vala"
				gtk_list_store_remove (self->priv->job_model, &iter);
#line 747 "systemadm.vala"
				break;
#line 2723 "systemadm.c"
			}
		}
	}
}


#line 753 "systemadm.vala"
void main_window_on_unit_changed (MainWindow* self, Unit* u) {
#line 2732 "systemadm.c"
	GtkTreeIter iter = {0};
	char* id;
	char* _tmp0_;
#line 753 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 753 "systemadm.vala"
	g_return_if_fail (u != NULL);
#line 2740 "systemadm.c"
	id = NULL;
#line 757 "systemadm.vala"
	if (!gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->unit_model, &iter)) {
#line 2744 "systemadm.c"
		_g_free0 (id);
#line 758 "systemadm.vala"
		return;
#line 2748 "systemadm.c"
	}
#line 760 "systemadm.vala"
	id = (_tmp0_ = unit_get_id (u), _g_free0 (id), _tmp0_);
#line 2752 "systemadm.c"
	{
		gboolean _tmp1_;
#line 762 "systemadm.vala"
		_tmp1_ = TRUE;
#line 762 "systemadm.vala"
		while (TRUE) {
#line 2759 "systemadm.c"
			char* name;
#line 762 "systemadm.vala"
			if (!_tmp1_) {
#line 776 "systemadm.vala"
				if (!gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->unit_model, &iter)) {
#line 776 "systemadm.vala"
					break;
#line 2767 "systemadm.c"
				}
			}
#line 762 "systemadm.vala"
			_tmp1_ = FALSE;
#line 2772 "systemadm.c"
			name = NULL;
#line 765 "systemadm.vala"
			gtk_tree_model_get ((GtkTreeModel*) self->priv->unit_model, &iter, 0, &name, -1);
#line 767 "systemadm.vala"
			if (_vala_strcmp0 (id, name) == 0) {
#line 768 "systemadm.vala"
				main_window_update_unit_iter (self, &iter, id, u);
#line 770 "systemadm.vala"
				if (_vala_strcmp0 (self->priv->current_unit_id, id) == 0) {
#line 771 "systemadm.vala"
					main_window_show_unit (self, u);
#line 2784 "systemadm.c"
				}
				_g_free0 (name);
#line 773 "systemadm.vala"
				break;
#line 2789 "systemadm.c"
			}
			_g_free0 (name);
		}
	}
	_g_free0 (id);
}


#line 779 "systemadm.vala"
void main_window_on_job_changed (MainWindow* self, Job* j) {
#line 2800 "systemadm.c"
	GtkTreeIter iter = {0};
	guint32 id = 0U;
#line 779 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 779 "systemadm.vala"
	g_return_if_fail (j != NULL);
#line 783 "systemadm.vala"
	if (!gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->job_model, &iter)) {
#line 784 "systemadm.vala"
		return;
#line 2811 "systemadm.c"
	}
#line 786 "systemadm.vala"
	id = job_get_id (j);
#line 2815 "systemadm.c"
	{
		gboolean _tmp0_;
#line 788 "systemadm.vala"
		_tmp0_ = TRUE;
#line 788 "systemadm.vala"
		while (TRUE) {
#line 2822 "systemadm.c"
			guint32 k = 0U;
#line 788 "systemadm.vala"
			if (!_tmp0_) {
#line 802 "systemadm.vala"
				if (!gtk_tree_model_iter_next ((GtkTreeModel*) self->priv->job_model, &iter)) {
#line 802 "systemadm.vala"
					break;
#line 2830 "systemadm.c"
				}
			}
#line 788 "systemadm.vala"
			_tmp0_ = FALSE;
#line 791 "systemadm.vala"
			gtk_tree_model_get ((GtkTreeModel*) self->priv->job_model, &iter, 5, &k, -1);
#line 793 "systemadm.vala"
			if (id == k) {
#line 794 "systemadm.vala"
				main_window_update_job_iter (self, &iter, id, j);
#line 796 "systemadm.vala"
				if (self->priv->current_job_id == id) {
#line 797 "systemadm.vala"
					main_window_show_job (self, j);
#line 2845 "systemadm.c"
				}
#line 799 "systemadm.vala"
				break;
#line 2849 "systemadm.c"
			}
		}
	}
}


#line 805 "systemadm.vala"
gboolean main_window_unit_filter (MainWindow* self, GtkTreeModel* model, GtkTreeIter* iter) {
#line 2858 "systemadm.c"
	gboolean result = FALSE;
	char* id;
	char* active_state;
	char* job;
#line 805 "systemadm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 805 "systemadm.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 2867 "systemadm.c"
	id = NULL;
	active_state = NULL;
	job = NULL;
#line 808 "systemadm.vala"
	gtk_tree_model_get (model, iter, 0, &id, 3, &active_state, 5, &job, -1);
#line 810 "systemadm.vala"
	if (id == NULL) {
#line 2875 "systemadm.c"
		result = FALSE;
		_g_free0 (id);
		_g_free0 (active_state);
		_g_free0 (job);
#line 811 "systemadm.vala"
		return result;
#line 2882 "systemadm.c"
	}
#line 813 "systemadm.vala"
	switch (gtk_combo_box_get_active (self->priv->unit_type_combo_box)) {
#line 2886 "systemadm.c"
		case 0:
		{
			result = TRUE;
			_g_free0 (id);
			_g_free0 (active_state);
			_g_free0 (job);
#line 816 "systemadm.vala"
			return result;
#line 2895 "systemadm.c"
		}
		case 1:
		{
			gboolean _tmp0_ = FALSE;
#line 819 "systemadm.vala"
			if (_vala_strcmp0 (active_state, "inactive") != 0) {
#line 819 "systemadm.vala"
				_tmp0_ = TRUE;
#line 2904 "systemadm.c"
			} else {
#line 819 "systemadm.vala"
				_tmp0_ = _vala_strcmp0 (job, "") != 0;
#line 2908 "systemadm.c"
			}
			result = _tmp0_;
			_g_free0 (id);
			_g_free0 (active_state);
			_g_free0 (job);
#line 819 "systemadm.vala"
			return result;
#line 2916 "systemadm.c"
		}
		case 2:
		{
			result = g_str_has_suffix (id, ".service");
			_g_free0 (id);
			_g_free0 (active_state);
			_g_free0 (job);
#line 822 "systemadm.vala"
			return result;
#line 2926 "systemadm.c"
		}
		case 3:
		{
			result = g_str_has_suffix (id, ".socket");
			_g_free0 (id);
			_g_free0 (active_state);
			_g_free0 (job);
#line 825 "systemadm.vala"
			return result;
#line 2936 "systemadm.c"
		}
		case 4:
		{
			result = g_str_has_suffix (id, ".device");
			_g_free0 (id);
			_g_free0 (active_state);
			_g_free0 (job);
#line 828 "systemadm.vala"
			return result;
#line 2946 "systemadm.c"
		}
		case 5:
		{
			result = g_str_has_suffix (id, ".mount");
			_g_free0 (id);
			_g_free0 (active_state);
			_g_free0 (job);
#line 831 "systemadm.vala"
			return result;
#line 2956 "systemadm.c"
		}
		case 6:
		{
			result = g_str_has_suffix (id, ".automount");
			_g_free0 (id);
			_g_free0 (active_state);
			_g_free0 (job);
#line 834 "systemadm.vala"
			return result;
#line 2966 "systemadm.c"
		}
		case 7:
		{
			result = g_str_has_suffix (id, ".target");
			_g_free0 (id);
			_g_free0 (active_state);
			_g_free0 (job);
#line 837 "systemadm.vala"
			return result;
#line 2976 "systemadm.c"
		}
		case 8:
		{
			result = g_str_has_suffix (id, ".snapshot");
			_g_free0 (id);
			_g_free0 (active_state);
			_g_free0 (job);
#line 840 "systemadm.vala"
			return result;
#line 2986 "systemadm.c"
		}
	}
	result = FALSE;
	_g_free0 (id);
	_g_free0 (active_state);
	_g_free0 (job);
#line 843 "systemadm.vala"
	return result;
#line 2995 "systemadm.c"
}


#line 846 "systemadm.vala"
void main_window_unit_type_changed (MainWindow* self) {
#line 3001 "systemadm.c"
	GtkTreeModelFilter* model;
#line 846 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 847 "systemadm.vala"
	model = _g_object_ref0 (GTK_TREE_MODEL_FILTER (gtk_tree_view_get_model (self->priv->unit_view)));
#line 849 "systemadm.vala"
	gtk_tree_model_filter_refilter (model);
#line 3009 "systemadm.c"
	_g_object_unref0 (model);
}


#line 852 "systemadm.vala"
void main_window_on_server_reload (MainWindow* self) {
#line 3016 "systemadm.c"
	GError * _inner_error_;
#line 852 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 3020 "systemadm.c"
	_inner_error_ = NULL;
	{
#line 854 "systemadm.vala"
		manager_reload (self->priv->manager, &_inner_error_);
#line 3025 "systemadm.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch5_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally5;
	__catch5_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 856 "systemadm.vala"
			main_window_show_error (self, e->message);
#line 3044 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 860 "systemadm.vala"
void main_window_on_server_snapshot (MainWindow* self) {
#line 3059 "systemadm.c"
	GError * _inner_error_;
#line 860 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 3063 "systemadm.c"
	_inner_error_ = NULL;
	{
		char* _tmp0_;
#line 862 "systemadm.vala"
		_tmp0_ = manager_create_snapshot (self->priv->manager, "", FALSE, &_inner_error_);
#line 3069 "systemadm.c"
		_g_free0 (_tmp0_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch6_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 864 "systemadm.vala"
		if (gtk_combo_box_get_active (self->priv->unit_type_combo_box) != 0) {
#line 865 "systemadm.vala"
			gtk_combo_box_set_active (self->priv->unit_type_combo_box, 8);
#line 3083 "systemadm.c"
		}
	}
	goto __finally6;
	__catch6_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 868 "systemadm.vala"
			main_window_show_error (self, e->message);
#line 3095 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


#line 872 "systemadm.vala"
void main_window_on_unit_load (MainWindow* self) {
#line 3110 "systemadm.c"
	GError * _inner_error_;
	char* t;
#line 872 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 3115 "systemadm.c"
	_inner_error_ = NULL;
#line 873 "systemadm.vala"
	t = g_strdup (gtk_entry_get_text (self->priv->unit_load_entry));
#line 875 "systemadm.vala"
	if (_vala_strcmp0 (t, "") == 0) {
#line 3121 "systemadm.c"
		_g_free0 (t);
#line 876 "systemadm.vala"
		return;
#line 3125 "systemadm.c"
	}
	{
		char* path;
		Unit* u;
		char* _tmp0_;
		GtkMessageDialog* _tmp1_;
		GtkMessageDialog* m;
#line 879 "systemadm.vala"
		path = manager_load_unit (self->priv->manager, t, &_inner_error_);
#line 3135 "systemadm.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch7_dbus_gerror;
			}
			_g_free0 (t);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 881 "systemadm.vala"
		u = unit_dbus_proxy_new (self->priv->bus, "org.freedesktop.systemd1", path);
#line 886 "systemadm.vala"
		m = (_tmp1_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_CLOSE, "Unit available as id %s", _tmp0_ = unit_get_id (u))), _g_free0 (_tmp0_), _tmp1_);
#line 891 "systemadm.vala"
		gtk_window_set_title ((GtkWindow*) m, "Unit");
#line 892 "systemadm.vala"
		gtk_dialog_run ((GtkDialog*) m);
#line 893 "systemadm.vala"
		gtk_object_destroy ((GtkObject*) m);
#line 895 "systemadm.vala"
		main_window_show_unit (self, u);
#line 3157 "systemadm.c"
		_g_free0 (path);
		_g_object_unref0 (u);
		_g_object_unref0 (m);
	}
	goto __finally7;
	__catch7_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 897 "systemadm.vala"
			main_window_show_error (self, e->message);
#line 3171 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (t);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (t);
}


#line 901 "systemadm.vala"
void main_window_on_unit_load_entry_changed (MainWindow* self) {
#line 901 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 902 "systemadm.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->unit_load_button, _vala_strcmp0 (gtk_entry_get_text (self->priv->unit_load_entry), "") != 0);
#line 3192 "systemadm.c"
}


#line 905 "systemadm.vala"
gboolean main_window_on_activate_link (MainWindow* self, const char* uri) {
#line 3198 "systemadm.c"
	gboolean result = FALSE;
	GError * _inner_error_;
#line 905 "systemadm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 905 "systemadm.vala"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 3205 "systemadm.c"
	_inner_error_ = NULL;
	{
		char* path;
		Unit* u;
#line 908 "systemadm.vala"
		path = manager_get_unit (self->priv->manager, uri, &_inner_error_);
#line 3212 "systemadm.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch8_dbus_gerror;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
#line 910 "systemadm.vala"
		u = unit_dbus_proxy_new (self->priv->bus, "org.freedesktop.systemd1", path);
#line 915 "systemadm.vala"
		main_window_show_unit (self, u);
#line 3225 "systemadm.c"
		_g_free0 (path);
		_g_object_unref0 (u);
	}
	goto __finally8;
	__catch8_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 917 "systemadm.vala"
			main_window_show_error (self, e->message);
#line 3238 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
#line 920 "systemadm.vala"
	return result;
#line 3251 "systemadm.c"
}


#line 923 "systemadm.vala"
void main_window_show_error (MainWindow* self, const char* e) {
#line 3257 "systemadm.c"
	GtkMessageDialog* m;
#line 923 "systemadm.vala"
	g_return_if_fail (self != NULL);
#line 923 "systemadm.vala"
	g_return_if_fail (e != NULL);
#line 924 "systemadm.vala"
	m = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", e));
#line 928 "systemadm.vala"
	gtk_window_set_title ((GtkWindow*) m, "Error");
#line 929 "systemadm.vala"
	gtk_dialog_run ((GtkDialog*) m);
#line 930 "systemadm.vala"
	gtk_object_destroy ((GtkObject*) m);
#line 3271 "systemadm.c"
	_g_object_unref0 (m);
}


static void main_window_class_init (MainWindowClass * klass) {
	main_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MainWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
}


static void main_window_instance_init (MainWindow * self) {
	self->priv = MAIN_WINDOW_GET_PRIVATE (self);
}


static void main_window_finalize (GObject* obj) {
	MainWindow * self;
	self = MAIN_WINDOW (obj);
	_g_free0 (self->priv->current_unit_id);
	_g_object_unref0 (self->priv->unit_view);
	_g_object_unref0 (self->priv->job_view);
	_g_object_unref0 (self->priv->unit_model);
	_g_object_unref0 (self->priv->job_model);
	_g_object_unref0 (self->priv->start_button);
	_g_object_unref0 (self->priv->stop_button);
	_g_object_unref0 (self->priv->restart_button);
	_g_object_unref0 (self->priv->reload_button);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->unit_load_entry);
	_g_object_unref0 (self->priv->unit_load_button);
	_g_object_unref0 (self->priv->server_snapshot_button);
	_g_object_unref0 (self->priv->server_reload_button);
	_dbus_g_connection_unref0 (self->priv->bus);
	_g_object_unref0 (self->priv->manager);
	_g_object_unref0 (self->priv->unit_id_label);
	_g_object_unref0 (self->priv->unit_aliases_label);
	_g_object_unref0 (self->priv->unit_dependency_label);
	_g_object_unref0 (self->priv->unit_description_label);
	_g_object_unref0 (self->priv->unit_load_state_label);
	_g_object_unref0 (self->priv->unit_active_state_label);
	_g_object_unref0 (self->priv->unit_sub_state_label);
	_g_object_unref0 (self->priv->unit_fragment_path_label);
	_g_object_unref0 (self->priv->unit_active_enter_timestamp_label);
	_g_object_unref0 (self->priv->unit_active_exit_timestamp_label);
	_g_object_unref0 (self->priv->unit_can_start_label);
	_g_object_unref0 (self->priv->unit_can_reload_label);
	_g_object_unref0 (self->priv->unit_cgroup_label);
	_g_object_unref0 (self->priv->job_id_label);
	_g_object_unref0 (self->priv->job_state_label);
	_g_object_unref0 (self->priv->job_type_label);
	_g_object_unref0 (self->priv->unit_type_combo_box);
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
}


GType main_window_get_type (void) {
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
		GType main_window_type_id;
		main_window_type_id = g_type_register_static (GTK_TYPE_WINDOW, "MainWindow", &g_define_type_info, 0);
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}


#line 941 "systemadm.vala"
void show_error (const char* e) {
#line 3342 "systemadm.c"
	GtkMessageDialog* m;
#line 941 "systemadm.vala"
	g_return_if_fail (e != NULL);
#line 942 "systemadm.vala"
	m = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (NULL, 0, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, "%s", e));
#line 943 "systemadm.vala"
	gtk_dialog_run ((GtkDialog*) m);
#line 944 "systemadm.vala"
	gtk_object_destroy ((GtkObject*) m);
#line 3352 "systemadm.c"
	_g_object_unref0 (m);
}


#line 947 "systemadm.vala"
gint _vala_main (char** args, int args_length1) {
#line 3359 "systemadm.c"
	gint result = 0;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		MainWindow* window;
#line 950 "systemadm.vala"
		gtk_init_with_args (&args_length1, &args, "[OPTION...]", entries, "systemadm", &_inner_error_);
#line 3367 "systemadm.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch9_dbus_gerror;
			}
			goto __catch9_g_error;
		}
#line 952 "systemadm.vala"
		window = g_object_ref_sink (main_window_new (&_inner_error_));
#line 3376 "systemadm.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch9_dbus_gerror;
			}
			goto __catch9_g_error;
		}
#line 953 "systemadm.vala"
		gtk_widget_show_all ((GtkWidget*) window);
#line 955 "systemadm.vala"
		gtk_main ();
#line 3387 "systemadm.c"
		_g_object_unref0 (window);
	}
	goto __finally9;
	__catch9_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 957 "systemadm.vala"
			show_error (e->message);
#line 3399 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 959 "systemadm.vala"
			show_error (e->message);
#line 3412 "systemadm.c"
			_g_error_free0 (e);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
#line 962 "systemadm.vala"
	return result;
#line 3425 "systemadm.c"
}


#line 947 "systemadm.vala"
int main (int argc, char ** argv) {
#line 947 "systemadm.vala"
	g_type_init ();
#line 947 "systemadm.vala"
	return _vala_main (argv, argc);
#line 3435 "systemadm.c"
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




