;;;
;;; Copyright (c) 2003,2004 uim Project http://uim.freedesktop.org/
;;;
;;; All rights reserved.
;;;
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 1. Redistributions of source code must retain the above copyright
;;;    notice, this list of conditions and the following disclaimer.
;;; 2. Redistributions in binary form must reproduce the above copyright
;;;    notice, this list of conditions and the following disclaimer in the
;;;    documentation and/or other materials provided with the distribution.
;;; 3. Neither the name of authors nor the names of its contributors
;;;    may be used to endorse or promote products derived from this software
;;;    without specific prior written permission.
;;;
;;; THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
;;; ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
;;; IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
;;; FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
;;; OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
;;; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
;;; LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
;;; OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
;;; SUCH DAMAGE.
;;;;

(require "generic.scm")

(define hangul-change-key-bind
  (lambda ()    
    (define-key generic-next-candidate-key? "")
    (define-key generic-prev-candidate-key? "")
    (define-key generic-commit-key? '(" " generic-return-key?))))
    
(define hangul2-init-handler
  (lambda (id arg)
    (require "hangul2.scm")
    (let* ((c (find-context id))
	   (cc (context-data c)))
      (set-context-data!
       c
       (generic-context-new hangul2-rule #t))
      (hangul-change-key-bind)
      ())))

(define hangul3-init-handler
  (lambda (id arg)
    (require "hangul3.scm")
    (let* ((c (find-context id))
	   (cc (context-data c)))
      (set-context-data!
       c
       (generic-context-new hangul3-rule #t))
      ())))

(define romaja-init-handler
  (lambda (id arg)
    (require "romaja.scm")
    (let* ((c (find-context id))
	   (cc (context-data c)))
      (set-context-data!
       c
       (generic-context-new romaja-rule #t))
      (hangul-change-key-bind)
      ())))

(generic-register-im
 'hangul2 "ko" "UTF-8" hangul2-init-handler)

(generic-register-im
 'hangul3 "ko" "UTF-8" hangul3-init-handler)

(generic-register-im
 'romaja "ko" "UTF-8" romaja-init-handler)
