/* Locale dependent routines */
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "ximserver.h"


static char *
ustring_to_euc_str(uString *s)
{
    uString::iterator i;
    int l=0;
    char *c;
    /* count the length*/
    for (i = s->begin(); i!= s->end(); i++) {
        l++;
        if (*i > 256) {
            l ++;
        }
    }
    c = (char *)malloc(l+1);
    c[l] = 0;
    l = 0;
    for (i = s->begin() ; i!= s->end(); i++) {
        if (*i < 256) {
            c[l] = *i;
            l++;
        } else {
            c[l] = ((*i)>>8)|0x80;
            c[l+1] = ((*i)&0xff)|0x80;
            l+=2;
        }
    }
    return c;
}

char *
Locale::uStringToCtext(uString *us)
{
    char *str = ustring_to_euc_str(us);
    XTextProperty prop;
    XmbTextListToTextProperty(XimServer::gDpy, &str, 1,
			      XCompoundTextStyle, &prop);
    free(str);
    char *res = strdup((char *)prop.value);
    XFree(prop.value);
    return res;
}

bool
Locale::supportOverTheSpot()
{
  return false;
}

class EUCJP_Locale : public Locale {
public:
  virtual char *uStringToCtext(uString *us) {
    int len;
    char *t;
    len = us->size() * 10;
    t = (char *)alloca(len+1);
    uString::iterator i;
    bool jp_mode=false;
    int cur,j=0;

    for (i = us->begin(); i != us->end(); i++) {
        cur = *i;
        if (!(cur & 0xff00)) {
            if (jp_mode) {
                t[j++] = 0x1b;
                t[j++] = 0x28;
                t[j++] = 0x42;
                jp_mode = false;
            }
            t[j++] = cur & 0xff;
        } else {
            if (!jp_mode) {
                jp_mode = true;
                t[j++] = 0x1b;
                t[j++] = 0x24;
                t[j++] = 0x29;
                t[j++] = 0x42;
            }
            t[j++] = (cur >> 8)|0x80;
            t[j++] = (cur & 0xff)|0x80;
        }
    }
    if (jp_mode) {
      t[j++] = 0x1b;
      t[j++] = 0x28;
      t[j++] = 0x42;
    }
    t[j] = 0;
    return strdup(t);
  };
  virtual bool supportOverTheSpot() {
    return true;
  }
};

Locale *getLocale(char *lang)
{
  if (!strcmp(lang, "ja")) {
    return new EUCJP_Locale();
  }
  return NULL;
}
