#include <uim/config.h>
#include <uim/uim.h>
#include <uim/uim-helper.h>

#include "ximserver.h"
#include "xim.h"
#include "convdisp.h"

#include "canddisp.h"

static FILE *candwin_r = NULL, *candwin_w = NULL;
static int candwin_pid = 0;

static char*
candwin_command(void)
{
#ifdef USE_GTK2
  return "uim-helper-candwin-gtk";
#else
  return NULL;
#endif
}

Canddisp* canddisp_singleton()
{
    static Canddisp* disp = NULL;
    char *command = candwin_command();

    if (disp == NULL && command) {
      candwin_pid = uim_ipc_open_command(candwin_pid, &candwin_r, &candwin_w, command);
      disp = new Canddisp();
    }
    return disp;
}

Canddisp::Canddisp()
{
}

Canddisp::~Canddisp() {
    ;
}

void Canddisp::begin(std::vector<const char*> candidates)
{
  std::vector<const char*>::iterator i;
  
  if(candwin_w == NULL)
    return;

  fprintf( candwin_w, "begin\ncharset=EUC-JP\n");
  for (i  = candidates.begin(); i != candidates.end(); i++) {
    fprintf( candwin_w, "%s\n", *i);
  }
  fprintf(candwin_w, "\n");
  fflush(candwin_w);
}

void Canddisp::select(int index)
{
  if(candwin_w == NULL)
    return;
  fprintf(candwin_w, "select\n");
  fprintf(candwin_w, "%d\n\n", index);
  fflush(candwin_w);
}

void Canddisp::end()
{
  if(candwin_w == NULL)
    return;
  fprintf(candwin_w, "end\n\n");
  fflush(candwin_w);
}

void Canddisp::show()
{
  if(candwin_w == NULL)
    return;
  fprintf(candwin_w, "show\n\n");
  fflush(candwin_w);
}

void Canddisp::hide()
{
  if(candwin_w == NULL)
    return;
  fprintf( candwin_w, "hide\n\n");
  fflush(candwin_w);
}

void Canddisp::move(int x, int y)
{
  if(candwin_w == NULL)
    return;
 
  fprintf( candwin_w, "move\n");
  fprintf( candwin_w, "%d\n", x);
  fprintf( candwin_w, "%d\n", y);
  fprintf( candwin_w, "\n");
  fflush(candwin_w);
}
