/* API and ABI is unstable */
#ifndef _uim_h_included_
#define _uim_h_included_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

typedef struct uim_context_ *uim_context;

typedef struct uim_candidate_ *uim_candidate;

/* This will be filled later, so ABI is unstable */
enum UKey {
  UKey_0 = 48,
  UKey_1 = 49,
  UKey_2 = 50,
  UKey_3 = 51,
  UKey_4 = 52,
  UKey_5 = 53,
  UKey_6 = 54,
  UKey_7 = 55,
  UKey_8 = 56,
  UKey_9 = 57,
  UKey_Escape = 256,
  UKey_Tab,
  UKey_Backspace,
  UKey_Delete,
  UKey_Return,
  UKey_Left,
  UKey_Up ,
  UKey_Right ,
  UKey_Down ,
  UKey_Prior , /* page up */
  UKey_Next , /* page down */
  UKey_Home,
  UKey_End,
  UKey_Zenkaku_Hankaku, /* zenkaku/hankaku toggle */
  UKey_Multi_key, /* multi-key character compose */
  UKey_Mode_switch, /* charcter set switch */
  UKey_Henkan_Mode, /* start/stop conversion */
  UKey_Muhenkan, /* cancel conversion */
  UKey_F1,
  UKey_F2,
  UKey_F3,
  UKey_F4,
  UKey_F5,
  UKey_F6,
  UKey_F7,
  UKey_F8,
  UKey_F9,
  UKey_F10,
  UKey_F11,
  UKey_F12,
  UKey_F13,
  UKey_F14,
  UKey_F15,
  UKey_F16,
  UKey_F17,
  UKey_F18,
  UKey_F19,
  UKey_F20,
  UKey_F21,
  UKey_F22,
  UKey_F23,
  UKey_F24,
  UKey_F25,
  UKey_F26,
  UKey_F27,
  UKey_F28,
  UKey_F29,
  UKey_F30,
  UKey_F31,
  UKey_F32,
  UKey_F33,
  UKey_F34,
  UKey_F35, /* X, Gtk and Qt supports up to F35 */
  /* non-standard platform specific keys (e.g. Zaurus PDA) */
  UKey_Private1,
  UKey_Private2,
  UKey_Private3,
  UKey_Private4,
  UKey_Private5,
  UKey_Private6,
  UKey_Private7,
  UKey_Private8,
  UKey_Private9,
  UKey_Private10,
  UKey_Private11,
  UKey_Private12,
  UKey_Private13,
  UKey_Private14,
  UKey_Private15,
  UKey_Private16,
  UKey_Private17,
  UKey_Private18,
  UKey_Private19,
  UKey_Private20,
  UKey_Private21,
  UKey_Private22,
  UKey_Private23,
  UKey_Private24,
  UKey_Private25,
  UKey_Private26,
  UKey_Private27,
  UKey_Private28,
  UKey_Private29,
  UKey_Private30,
  /* this part is especially unstable */
  UKey_Shift_key,
  UKey_Control_key,
  UKey_Alt_key,
  UKey_Meta_key,
  UKey_Other = 1000
};
  
enum UKeyModifier {
  UKey_Shift = 1,
  UKey_Control = 2,
  UKey_Alt = 4,
  UKey_Meta = 8,
  UKey_Pseudo0 = 16,
  UKey_Pseudo1 = 32,
};
  
enum UPreeditAttr {
  UPeAttr_None = 0,
  UPeAttr_UnderLine = 1,
  UPeAttr_Reverse = 2,
  UPeAttr_Cursor = 4,
  UPeAttr_Separator = 8,
};

/* abstracting platform-dependent character code conversion method */
struct uim_code_converter {
  int (*is_convertible)(const char *tocode, const char *fromcode);
  void *(*create)(const char *tocode, const char *fromcode);
  char *(*convert)(void *obj, const char *str);
  void (*release)(void *obj);
};
  
int uim_init(void);
void uim_quit(void);

uim_context
uim_create_context(void *ptr,
		   char *enc,
		   char *lang,
		   char *engine,
		   struct uim_code_converter *conv,
		   void (*commit_cb)(void *ptr, char *str));
void
uim_set_preedit_cb(uim_context uc,
		   void (*clear_cb)(void *ptr),
		   void (*pushback_cb)(void *ptr,
				       int attr,
				       char *str),
		   /* page change cb .. etc will be here */
		   void (*update_cb)(void *ptr));
void
uim_release_context(uim_context uc);
void
uim_reset_context(uim_context uc);
/* im list */
int uim_get_nr_im(uim_context uc);
/* you must not free the result */
const char *uim_get_im_name(uim_context uc, int nth);
/* you must not free the result */
const char *uim_get_im_language(uim_context uc, int nth);
/* you must not free the result */
const char *uim_get_im_encoding(uim_context uc, int nth);
/* 32 <= key <= 126 */
int
uim_press_key(uim_context uc, int key, int state);
int
uim_release_key(uim_context uc, int key, int state);
  
/* mode list */
int
uim_get_nr_modes(uim_context uc);
/* you must not free the result */
const char *
uim_get_mode_name(uim_context uc, int nth);
void
uim_set_mode_list_update_cb(uim_context uc,
			    void (*update_cb)(void *ptr));
/*property*/
void
uim_prop_list_update(uim_context uc);
void
uim_prop_label_update(uim_context uc);
void
uim_set_prop_list_update_cb(uim_context uc,
			    void (*update_cb)(void *ptr, char *str));

void
uim_set_prop_label_update_cb(uim_context uc,
			     void (*update_cb)(void *ptr, char *str));
void
uim_prop_activate(uim_context uc, char *str);
/* mode */
int
uim_get_current_mode(uim_context uc);
void
uim_set_mode(uim_context uc, int nth);
void
uim_set_mode_cb(uim_context uc, void (*update_cb)(void *ptr,
						  int mode));
  
int uim_set_candidate_selector_cb(uim_context uc,
				  void (*begin_cb)(void *ptr, int nr, int display_limit),
				  void (*select_cb)(void *ptr, int index),
				  void (*shift_page_cb)(void *ptr, int direction),
				  void (*end_cb)(void *ptr));

/* You must free the result by uim_candidate_free */
uim_candidate uim_get_candidate(uim_context uc, int index, int accel_enumeration_hint);
void uim_candidate_free(uim_candidate cand);

int   uim_get_candidate_index(uim_context uc);
void  uim_set_candidate_index(uim_context uc, int index);

/* You must not free the result.  */
const char *uim_candidate_get_cand_str(uim_candidate cand);
const char *uim_candidate_get_heading_label(uim_candidate cand);

/* Utility functions */
int
uim_ipc_open_command(int old_pid, FILE **read_handler, FILE **write_handler, char *command);
char *uim_symbol_value_str(const char *symbol_str);

/* an uim_code_converter implementation using iconv */
extern struct uim_code_converter *uim_iconv;

#ifdef __cplusplus
}
#endif
#endif
