#include <stdlib.h>
#include <string.h>
#include "context.h"
#include "siod.h"


static LISP true_sym;

static LISP
string_equal(LISP x, LISP y)
{
  long xl, yl;
  char *xs, *ys;
  xs = get_c_string_dim(x, &xl);
  ys = get_c_string_dim(y, &yl);
  if (xl != yl) {
    return NIL;
  }
  if (!strncmp(xs, ys, xl)) {
    return (true_sym);
  }
  return NIL;
}

static LISP
charcode2string(LISP x)
{
  char buf[2];
  if (INTNUMP(x)) {
    buf[0] = INTNM(x);
  } else {
    buf[0] = 0;
  }
  buf[1] = 0;
    return strcons (1,buf);
}

static LISP
string2charcode(LISP x)
{
  char *buf = get_c_string(x);

  if(buf) {
    return intcons(*buf);
  }
  return NIL;
}

static LISP
nthcdr(LISP nth_, LISP lst)
{
  int nth = get_c_long(nth_);
  int i;
  for (i = 0; i < nth; i++) {
    if (!lst) {
      /* something bad happened */
      return NIL;
    }
    lst = CDR(lst);
  }
  return lst;
}

char *
uim_get_c_string(LISP str)
{
  char *s;
  long len;
  char *buf;
  s = get_c_string_dim(str, &len);
  buf = (char *)malloc(sizeof(char)*(len + 1));
  strncpy(buf, s, len);
  buf[len] = 0;
  return buf;
}

static LISP
str_seq_equal(LISP seq, LISP rule)
{
  int sl = nlength(seq);
  int rl = nlength(rule);
  int i;
  if (sl != rl) {
    return NIL;
  }
  for (i = 0; i < sl; i++) {
    if (!string_equal(CAR(seq), CAR(rule))) {
      return NIL;
    }
    seq = CDR(seq);
    rule = CDR(rule);
  }
  return true_sym;
}

static LISP
str_seq_partial(LISP seq, LISP rule)
{
  int sl = nlength(seq);
  int rl = nlength(rule);
  int i;

  if (sl >= rl) {
    return NIL;
  }
  for (i = 0; i < sl; i++) {
    if (!string_equal(CAR(seq), CAR(rule))) {
      return NIL;
    }
    seq = CDR(seq);
    rule = CDR(rule);
  }
  if (rule && CAR(rule)) {
    return CAR(rule);
  }
  return true_sym;
}

static LISP
rk_find_seq(LISP s, LISP rule)
{
  for (; rule != NIL; rule = CDR(rule)) {
    if (str_seq_equal(s, CAR(CAR(CAR(rule))))) {
      return CAR(rule);
    }
  }
  return NIL;
}

static LISP
rk_find_partial_seq(LISP s, LISP rule)
{
  for (; rule != NIL; rule = CDR(rule)) {
    if (str_seq_partial(s, CAR(CAR(CAR(rule))))) {
      return CAR(rule);
    }
  }
  return NIL;
}

static LISP
rk_expect_seq(LISP seq, LISP rules)
{
  long flag;
  LISP cur, res = NIL;
  flag = no_interrupt(1);
  for (cur = rules; cur; cur = CDR(cur)) {
    LISP rule = CAR(cur);
    LISP e = str_seq_partial(seq, CAR(CAR(rule)));
    if (e &&
	true_sym != e) {
      res = cons(e, res);
    }
  }
  no_interrupt(flag);
  return res;
}

static LISP
c_getenv(LISP str_)
{
  char *str = get_c_string(str_);
  char *val;

  if (!str) {
    return NIL;
  }
  val = getenv(str);
  return strcons(strlen(val), val);
}

static char **
uim_strsplit(char *splittee, char *splitter)
{
  char *cur, *tmp;
  int nr_token = 0;
  int in_token = 0;
  char **res;
  int len;
  int i;

  if(!splittee || !splitter)
    return NULL;


  /* count the number of token */
  cur = splittee;
  while (*cur) {
    if (strchr(splitter, *cur)) {
      in_token = 0;
    } else {
      if (!in_token) {
	nr_token ++;
      }
      in_token = 1;
    }
    cur ++;
  }
  /* allocate buffer */
  res = (char **)malloc(sizeof(char *) * (nr_token + 1) );
  if (!res) {
    return NULL;
  }
  /**/
  cur = splittee;
  for (i = 0; i < nr_token; i++) {
    /* find current token's start */
    while (strchr(splitter, *cur)) {
      cur ++;
    }
    /* calc length */
    len = 0;
    tmp = cur;
    while (!strchr(splitter, *tmp)) {
      len ++;
      tmp ++;
    }
    /* store */
    res[i] = malloc(sizeof(char) * (len + 1));
    strncpy(res[i], cur, len);
    res[i][len] = 0;
    cur = tmp;
  }
  /**/
  res[nr_token] = NULL;

  return res;
}

static LISP
uim_split_string(LISP _splittee, LISP _splitter)
{
  char *splittee = get_c_string(_splittee);
  char *splitter = get_c_string(_splitter);
  char **strs;
  LISP l = NIL;
  int i;
  int j;

  if(_splittee == NULL || _splitter == NULL)
    return NIL;

  if(splittee == NULL || splitter == NULL)
    return NIL;

   strs = uim_strsplit(splittee, splitter);

   if(!strs || !*strs)
     return NIL;

   for(j = 0;strs[j] != '\0' ; j++){}

   j--;
   
   for(i = j; i >= 0 ; i--)
     {
       l = cons ( strcons( strlen(strs[i]), strs[i] ), l );
            free(strs[i]);
     }
   free(strs);
   return l;
}

static LISP
eucjp_string_to_list(LISP str_)
{
  char *str = get_c_string(str_);
  unsigned char *cur = str;
  LISP res = NIL;
  while (*cur) {
    LISP tmp;
    char buf[3];
    int len;
    buf[2] = 0;
    if (*cur > 127) {
      /* 2 bytes */
      buf[0] = cur[0];
      buf[1] = cur[1];
      len = 2;
      cur ++;
    } else {
      buf[0] = cur[0];
      buf[1] = 0;
      len = 1;
    }
    res = cons (strcons(len, buf), res);
    cur ++;
  }
  return res;
}

static LISP
uim_symbol_value(const char *symbol_str)
{
  LISP symbol_str_ = rintern(symbol_str);
  
  if(symbol_boundp(symbol_str_, NIL) == true_sym) {
    return symbol_value(symbol_str_, NIL);         
  } else {
    return NIL;
  }
}

char *
uim_symbol_value_str(const char *symbol_str)
{
  LISP val_;
  char *val;
  val_ = uim_symbol_value(symbol_str);

  if( val_ != NIL) {
    val = uim_get_c_string(val_);
  } else {
    val = NULL;
  }
  return val;
}

int
uim_symbol_value_int(const char *symbol_str)
{
  LISP val_;
  int val;
  val_ = uim_symbol_value(symbol_str);

  if( val_ != NIL) {
    val = get_c_long(val_);
  } else {
    val = 0;
  }
  return val;
}


static LISP
digit2string(LISP x)
{
  char buf[10];
  int i;

  i = get_c_long(x);

  sprintf(buf,"%d",i);
  return strcons (strlen(buf),buf);
}

void
uim_init_util_subrs()
{
  true_sym = siod_true_value();
  init_subr_2("string-equal?", string_equal);
  init_subr_2("nthcdr", nthcdr);
  init_subr_1("charcode->string", charcode2string);
  init_subr_1("string->charcode", string2charcode);
  init_subr_1("digit->string", digit2string);
  init_subr_2("str-seq-equal?", str_seq_equal);
  init_subr_2("str-seq-partial?", str_seq_partial);
  init_subr_2("rk-lib-find-seq", rk_find_seq);
  init_subr_2("rk-lib-find-partial-seq", rk_find_partial_seq);
  init_subr_2("rk-lib-expect-seq", rk_expect_seq);
  init_subr_1("getenv", c_getenv);
  init_subr_2("string-split", uim_split_string);
  init_subr_1("string-to-list", eucjp_string_to_list);
}
