#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <netinet/in.h>
#include <netdb.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <uim/uim.h>
#include <uim/uim-helper.h>
#include "context.h"

static int uim_fd = -1;
static void (*uim_disconnect_cb)(void);

static void uim_helper_client_focus(uim_context uc, int flg);

#define BUFFER_SIZE 1024
/*Common buffer for some functions's temporary buffer.
  Pay attention for use.*/
static char uim_help_buf[BUFFER_SIZE];
static int uim_read_buf_count;
static int uim_read_buf_error;
static char uim_read_buf[BUFFER_SIZE];

char*
get_server_command(void)
{
  return "uim-helper-server";
}


int uim_helper_init_client_fd(void (*disconnect_cb)(void))
{
  struct stat lst, fst;
  int fd;
  struct sockaddr_un server;
  char *path = uim_helper_get_pathname();
  
  uim_fd = -1;
  
  if(!path)
    return -1;

  memset(&server, 0, sizeof(server));
  
  server.sun_family = PF_UNIX;
  strcpy(server.sun_path, path);
  free(path);
  
  fd = socket(PF_UNIX, SOCK_STREAM, 0);
  if (fd < 0) {
    perror("fail to create socket");
    return -1;
  }
  
  if (fstat(fd, &fst) != 0) {
    close(fd);
    return -1;
  }  
  if (fst.st_uid != getuid()) {
    close(fd);
    return -1;
  }
  
  if(connect(fd, (struct sockaddr *)&server,sizeof(server)) == -1){
    int serv_pid = 0;
    FILE *serv_r = NULL, *serv_w = NULL;
    char buf[128];
    
    serv_pid = uim_ipc_open_command(serv_pid, &serv_r, &serv_w, get_server_command());
    
    if(serv_pid == 0) {
      return -1;
    }
    
    while (fgets (buf, sizeof(buf), serv_r ) != NULL ) {
      if(strcmp( buf, "\n" ) == 0)
	break;
    }
    
    if(connect(fd, (struct sockaddr *)&server,sizeof(server)) == -1){
      return -1;
    }
  }

  uim_disconnect_cb = disconnect_cb;
  uim_read_buf_count = 0;
  uim_read_buf_error = 0;
  uim_fd = fd;
  return fd;
}

void
uim_helper_close_client_fd(int fd)
{
  if (fd != -1) {
    close(fd);
  }
  if (uim_disconnect_cb) {
    uim_disconnect_cb();
  }
  uim_fd = -1;
}


void
uim_helper_client_focus_in(uim_context uc)
{
  uim_helper_client_focus(uc, 0);
}

void
uim_helper_client_focus_out(uim_context uc)
{
  uim_helper_client_focus(uc, 1);
}

static void
uim_helper_client_focus(uim_context uc, int flg)
{
  if(uim_fd < 0)
    return;

  if(!uc)
    return;

  if(flg == 0)
    snprintf(uim_help_buf, BUFFER_SIZE, "focus_in\n");
  else
    snprintf(uim_help_buf, BUFFER_SIZE, "focus_out\n");

  uim_helper_send_message(uim_fd, uim_help_buf);
}



void
uim_helper_client_get_prop_list(void)
{
  snprintf(uim_help_buf, BUFFER_SIZE, "prop_list_get\n");
  uim_helper_send_message(uim_fd, uim_help_buf);
}

void
uim_helper_read_proc(int fd)
{
  int rc;  

  rc = read(fd, uim_read_buf, BUFFER_SIZE - uim_read_buf_count);
  if (rc == 0) {
    if (uim_disconnect_cb) {
      uim_disconnect_cb();
    }
    uim_fd = -1;
    return ;
  }
  uim_read_buf_count += rc;
}

static void
shift_read_buffer(int count)
{
  memmove(uim_read_buf, &uim_read_buf[count],
	  uim_read_buf_count - count);
  uim_read_buf_count -= count;
}

char *
uim_helper_get_message()
{
  int i;
  char buf[BUFFER_SIZE];
  for (i = 0; i < uim_read_buf_count - 1; i++) {
    if (uim_read_buf[i] == '\n' &&
	uim_read_buf[i+1] == '\n') {
      memcpy(buf, uim_read_buf, i+2);
      buf[i+2] = 0;
      shift_read_buffer(i+2);
      if (uim_read_buf_error) {
	uim_read_buf_error = 0;
	return NULL;
      }
      return strdup(buf);
    }
  }
  if (uim_read_buf_count) {
    uim_read_buf_error = 1;
  }
  return NULL;
}
