

/*
 *                   COPYRIGHT (c) 1988-1994 BY                             *
 *        PARADIGM ASSOCIATES INCORPORATED, CAMBRIDGE, MASSACHUSETTS.       *
 *        See the source file SLIB.C for more information.                  *

 Array-hacking code moved to another source file.

 */
/*
  removed base64 functions (Oct-03) Yusuke TABATA
  removed tc_{long,double}_array
  removed fast save/load functionality
 */
#include <stdio.h>
#include <string.h>
#include <setjmp.h>
#include <stdlib.h>
#include <stdarg.h>
#include <ctype.h>
#include <math.h>

#include "siod.h"

LISP
assv (LISP x, LISP alist)
{
  LISP l, tmp;
  for (l = alist; CONSP (l); l = CDR (l))
    {
      tmp = CAR (l);
      if (CONSP (tmp) && NNULLP (eql (CAR (tmp), x)))
	return (tmp);
      INTERRUPT_CHECK ();
    }
  if EQ
    (l, NIL) return (NIL);
  return (my_err ("improper list to assv", alist));
}

LISP
lstrcmp (LISP s1, LISP s2)
{
  return (intcons (strcmp (get_c_string (s1), get_c_string (s2))));
}

LISP
member (LISP x, LISP il)
{
  LISP l, tmp;
  for (l = il; CONSP (l); l = CDR (l))
    {
      tmp = CAR (l);
      if NNULLP
	(equal (x, tmp)) return (l);
      INTERRUPT_CHECK ();
    }
  if EQ
    (l, NIL) return (NIL);
  return (my_err ("improper list to member", il));
}

LISP
memv (LISP x, LISP il)
{
  LISP l, tmp;
  for (l = il; CONSP (l); l = CDR (l))
    {
      tmp = CAR (l);
      if NNULLP
	(eql (x, tmp)) return (l);
      INTERRUPT_CHECK ();
    }
  if EQ
    (l, NIL) return (NIL);
  return (my_err ("improper list to memv", il));
}

LISP
lsubset (LISP fcn, LISP l)
{
  LISP result = NIL, v;
  for (v = l; CONSP (v); v = CDR (v))
    if NNULLP
      (funcall1 (fcn, CAR (v)))
	result = cons (CAR (v), result);
  return (nreverse (result));
}

LISP
listn (long n,...)
{
  LISP result, ptr;
  long j;
  va_list args;
  for (j = 0, result = NIL; j < n; ++j)
    result = cons (NIL, result);
  va_start (args, n);
  for (j = 0, ptr = result; j < n; ptr = cdr (ptr), ++j)
    setcar (ptr, va_arg (args, LISP));
  va_end (args);
  return (result);
}

static LISP
ltypeof (LISP obj)
{
  long x;
  x = TYPE (obj);
  switch (x)
    {
    case tc_nil:
      return (rintern ("tc_nil"));
    case tc_cons:
      return (rintern ("tc_cons"));
    case tc_intnum:
      return (rintern ("tc_intnum"));
    case tc_symbol:
      return (rintern ("tc_symbol"));
    case tc_subr_0:
      return (rintern ("tc_subr_0"));
    case tc_subr_1:
      return (rintern ("tc_subr_1"));
    case tc_subr_2:
      return (rintern ("tc_subr_2"));
    case tc_subr_2n:
      return (rintern ("tc_subr_2n"));
    case tc_subr_3:
      return (rintern ("tc_subr_3"));
    case tc_subr_4:
      return (rintern ("tc_subr_4"));
    case tc_subr_5:
      return (rintern ("tc_subr_5"));
    case tc_lsubr:
      return (rintern ("tc_lsubr"));
    case tc_fsubr:
      return (rintern ("tc_fsubr"));
    case tc_msubr:
      return (rintern ("tc_msubr"));
    case tc_closure:
      return (rintern ("tc_closure"));
    case tc_free_cell:
      return (rintern ("tc_free_cell"));
    case tc_string:
      return (rintern ("tc_string"));
    case tc_c_file:
      return (rintern ("tc_c_file"));
    default:
      return (intcons (x));
    }
}

void
init_subrs_a (void)
{
  init_subr_2 ("assv", assv);
  init_subr_2 ("strcmp", lstrcmp);
  init_subr_2 ("subset", lsubset);
  init_subr_1 ("typeof", ltypeof);
  init_subr_2 ("memv", memv);
  init_subr_2 ("member", member);
}
