;; zaurus.scm: platform-specific support for Sharp Zaurus PDA
;;
;; This file is intended to use with IMKit-uim on Qtopia platform
;; See following documents for Zaurus specific key definitions
;;
;; SL-A300
;; http://developer.ezaurus.com/sl_j/doc/software/keycode_qt_a300_20021213.pdf
;;
;; SL-B500 and SL-C700
;; http://developer.ezaurus.com/sl_j/doc/software/keycode_b500c700.pdf

(require "generic-key.scm")

(define zaurus-calendar-key
  (lambda (key key-state)
    (= key 'F9)))

(define zaurus-addressbook-key
  (lambda (key key-state)
    (= key 'F10)))

(define zaurus-menu-key
  (lambda (key key-state)
    (= key 'F11)))

;; application key to show "Home" tab of the launcher, not ordinary
;; "Home" key in desktop
(define zaurus-home-key
  (lambda (key key-state)
    (= key 'F12)))

(define zaurus-mail-key
  (lambda (key key-state)
    (= key 'F13)))

;; "Mail" being pressed long
(define zaurus-mail-pressed-long-key
  (lambda (key key-state)
    (= key 'F14)))

(define zaurus-zenkaku-hankaku-key
  (lambda (key key-state)
    (= key 'F21)))

;; "Fn" modifier key
;; modified keys are translated to another unmodified key by Qt/Embedded
(define zaurus-fn-key
  (lambda (key key-state)
    (= key 'F22)))

;; Fn + Space ("OnKun")
(define zaurus-onkun-key
  (lambda (key key-state)
    (= key 'F23)))

;; Fn + "Zenkaku/Hankaku" ("Kanji")
(define zaurus-kanji-key
  (lambda (key key-state)
    (= key 'F25)))

;; Katakana/Hiragana toggle
(define zaurus-katakana-hiragana-key
  (lambda (key key-state)
    (= key 'F26)))

;; "SELECT" on SL-5500 (center of round cursor keys)
(define zaurus-select-key
  (lambda (key key-state)
    (= key 'F30)))

;; Fn + "Katakana/Hiragana" ("Kigou")
(define zaurus-kigou-key
  (lambda (key key-state)
    (= key 'F31)))

;; "Sync start" button on cradle
(define zaurus-sync-start-key
  (lambda (key key-state)
    (= key 'F32)))

(define zaurus-ok-key
  (lambda (key key-state)
    (= key 'F33)))

;; Power switch (don't use this key)
(define zaurus-power-key
  (lambda (key key-state)
    (= key 'F34)))

;; "Calendar" being pressed long (as "Sync" on SL-C700)
(define zaurus-sync-key
  (lambda (key key-state)
    (= key 'F35)))

;; following keysyms are locally assigned by IMKit-uim from raw integer
;; Fn + 1 ("Zoom out")
(define zaurus-zoom-out-key
  (lambda (key key-state)
    (= key 'Private1)))

;; Fn + 2 ("Zoom in")
(define zaurus-zoom-in-key
  (lambda (key key-state)
    (= key 'Private2)))

;; Fn + 3 ("Decrease contrast")
(define zaurus-decrease-contrast-key
  (lambda (key key-state)
    (= key 'Private3)))

;; Fn + 4 ("Increase contrast")
(define zaurus-increase-contrast-key
  (lambda (key key-state)
    (= key 'Private4)))

;; Fn + 5
(define zaurus-fn-5-key
  (lambda (key key-state)
    (= key 'Private5)))

;; Fn + 6 ("Hiragana")
(define zaurus-hiragana-mode-key
  (lambda (key key-state)
    (= key 'Private6)))

;; Fn + 7 ("Katakana")
(define zaurus-katakana-mode-key
  (lambda (key key-state)
    (= key 'Private7)))

;; Fn + 8 ("half-width Katakana")
(define zaurus-half-katakana-mode-key
  (lambda (key key-state)
    (= key 'Private8)))

;; Fn + 9 ("wide-width Alphanumeric")
(define zaurus-wide-latin-mode-key
  (lambda (key key-state)
    (= key 'Private9)))

;; Fn + 0 ("Alphanumeric")
(define zaurus-latin-mode-key
  (lambda (key key-state)
    (= key 'Private10)))

;; Fn + Q
(define zaurus-fn-q-key
  (lambda (key key-state)
    (= key 'Private11)))

;; Fn + O
(define zaurus-fn-o-key
  (lambda (key key-state)
    (= key 'Private12)))

;; Fn + P
(define zaurus-fn-p-key
  (lambda (key key-state)
    (= key 'Private13)))

;; Fn + A
(define zaurus-fn-a-key
  (lambda (key key-state)
    (= key 'Private14)))

;; Fn + S
(define zaurus-fn-s-key
  (lambda (key key-state)
    (= key 'Private15)))

;; Fn + K
(define zaurus-fn-k-key
  (lambda (key key-state)
    (= key 'Private16)))

;; Fn + N
(define zaurus-fn-n-key
  (lambda (key key-state)
    (= key 'Private17)))

;; Fn + M
(define zaurus-fn-m-key
  (lambda (key key-state)
    (= key 'Private18)))

;; save original definitions
(define default-modifier-key modifier-key)
(define default-generic-commit-key generic-commit-key)
(define default-generic-cancel-key generic-cancel-key)

;; "OK" key is not included to avoid accidential termination of application
(define zaurus-commit-key
  (lambda (key key-state)
    (default-generic-commit-key key key-state)))
     
;; "CANCEL" key is already bound as 'escape in generic-cancel-key, so
;; ignore "CANCEL" key to avoid accidential termination of application
(define zaurus-cancel-key
  (lambda (key key-state)
    (or
     (and
      (not (= key 'escape))
      (default-generic-cancel-key key key-state))
     (and
      (shift-key-mask key-state)
      (zaurus-select-key key key-state)))))

;; additionally bind "OK" key for commit
(define zaurus-barbarous-commit-key
  (lambda (key key-state)
    (or
     (zaurus-commit-key key key-state)
     (zaurus-ok-key key key-state))))

;; additionally bind "CANCEL" key for cancel operation
(define zaurus-barbarous-cancel-key
  (lambda (key key-state)
    (or
     (zaurus-cancel-key key key-state)
     (= key 'escape))))

;; placeholder for future use
(define zaurus-translate-key
  (lambda (key key-state)
    (cond
     ((zaurus-zenkaku-hankaku-key key key-state)
      ('zenkaku-hankaku key-state))
     ((zaurus-katakana-hiragana-key key key-state)
      ('Mode_switch key-state)))))

;; ignore Fn key as modifier key
(set! modifier-key
      (lambda (key key-state)
	(or (default-modifier-key key key-state)
	    (zaurus-fn-key key key-state))))

;; replace the default keybindings to fit Zaurus hardware
;; you can use the barbarous bindings with careful key operation
(set! generic-commit-key zaurus-commit-key)
(set! generic-cancel-key zaurus-cancel-key)
;(set! generic-commit-key zaurus-barbarous-commit-key)
;(set! generic-cancel-key zaurus-barbarous-cancel-key)
