;;TODO
;;    ::ñϿ
;;
;;⡼ɰ
;;  ܸϥ⡼(ܸϥ⡼ɤɬס)
;;  ѿ⡼
;;  ѱѿ⡼
;;  
;;ơȰ
;;  *ܸϥ⡼
;;    Ե,Ͼ,Ѵ
;;  *ñϿ⡼
;;    ɤϾ,ñϾ
;;

(require "japanese.scm")
(require "generic-key.scm")

;; configs
(define prime-use-candidate-window? #t)
(define prime-candidate-op-count 1) ;;䥦ɥɽޤǤ˲󥹥ڡ򲡤ɬפ뤫
(define prime-preedit-immediate-commit? #f)
(define prime-always-show-window? #t)
(define prime-mask-pending-preedit #f)
(define prime-nr-candidate-max 10)

;; config function
(define prime-dont-use-numeral-key-to-select-cand
  (lambda ()
    (set! prime-cand-select-key
	  (lambda (key key-state)
	    (and (numeral? key)
		 (control-key-mask key-state))))))

;; key
(define prime-latin-key
  (lambda (key key-state)
    (or
     (generic-off-key key key-state)
     (and (= (to-lower-char key) 108)
	  (control-key-mask key-state)))))
(define prime-wide-latin-key
  (lambda (key key-state)
    (and (= (to-lower-char key) 108)
	 (shift-key-mask key-state))))
(define prime-begin-conv-key
  (lambda (key key-state)
    (= key 32)))
(define prime-on-key
  (lambda (key key-state)
    (or
     (and (= (to-lower-char key) 106)
	  (control-key-mask key-state))
     (generic-on-key key key-state))))
(define prime-commit-key
  (lambda (key key-state)
    (generic-commit-key key key-state)))
(define prime-next-candidate
  (lambda (key key-state)
    (generic-next-candidate-key key key-state)))
(define prime-prev-candidate
  (lambda (key key-state)
    (or
     (generic-prev-candidate-key key key-state)
     (= (to-lower-char key) 120))))
(define prime-kana-toggle
  (lambda (key key-state)
    (and (= (to-lower-char key) 113)
	 (control-key-mask key-state))))
(define prime-cancel-key
  (lambda (key key-state)
    (generic-cancel-key key key-state)))
(define prime-backspace-key
  (lambda (key key-state)
    (generic-backspace-key key key-state)))
(define prime-delete-key
  (lambda (key key-state)
    (generic-delete-key key key-state)))
(define prime-go-left-key
  (lambda (key key-state)
    (generic-go-left-key key key-state)))
(define prime-go-right-key
  (lambda (key key-state)
    (generic-go-right-key key key-state)))
(define prime-cand-select-key
  (lambda (key key-state)
    (numeral? key)))

;; access
(define prime-context-raw-commit
 (lambda (ac)
   (car (nthcdr 16 ac))))
(define prime-context-set-raw-commit!
  (lambda (ac mode)
    (set-car! (nthcdr 16 ac) mode)))
(define prime-context-immediate-commit ;;Ūprime-preedit-immediate-commit?򥪥դˤ뤫ɤ
 (lambda (ac)
   (car (nthcdr 15 ac))))
(define prime-context-set-immediate-commit!
  (lambda (ac mode)
    (set-car! (nthcdr 15 ac) mode)))
(define prime-context-last-word ;;PRIMEPOBoxѸǤContext
 (lambda (ac)
   (car (nthcdr 14 ac))))
(define prime-context-set-last-word!
  (lambda (ac mode)
    (set-car! (nthcdr 14 ac) mode)))
(define prime-context-mode
 (lambda (ac)
   (car (nthcdr 13 ac))))
(define prime-context-set-mode!
  (lambda (ac mode)
    (set-car! (nthcdr 13 ac) mode)))
(define prime-context-left-string ;;κ¦ˤpreeditʸΥꥹ
 (lambda (ac)
   (car (nthcdr 12 ac))))
(define prime-context-set-left-string!
  (lambda (ac str)
    (set-car! (nthcdr 12 ac) str)))
(define prime-context-right-string
 (lambda (ac)
   (car (nthcdr 11 ac))))
(define prime-context-set-right-string!
  (lambda (ac str)
    (set-car! (nthcdr 11 ac) str)))
(define prime-context-candidates
  (lambda (c)
   (car (nthcdr 10 c))))
(define prime-context-set-candidates!
  (lambda (c cnt)
    (set-car! (nthcdr 10 c) cnt)))
(define prime-context-candidate-window
  (lambda (c)
   (car (nthcdr 9 c))))
(define prime-context-set-candidate-window!
  (lambda (c cnt)
    (set-car! (nthcdr 9 c) cnt)))
(define prime-context-candidate-op-count
  (lambda (c)
   (car (nthcdr 8 c))))
(define prime-context-set-candidate-op-count!
  (lambda (c cnt)
    (set-car! (nthcdr 8 c) cnt)))
(define prime-context-rk-context
  (lambda (c)
   (car (nthcdr 7 c))))
(define prime-context-set-rk-context!
  (lambda (c rkc)
    (set-car! (nthcdr 7 c) rkc)))
(define prime-context-nth
  (lambda (c)
    (car (nthcdr 6 c))))
(define prime-context-set-nth!
  (lambda (c nth)
    (set-car! (nthcdr 6 c) nth)))
(define prime-context-right-right-strings
  (lambda (c)
    (car (nthcdr 4 c))))
(define prime-context-set-right-right-strings!
  (lambda (c right-right)
    (set-car! (nthcdr 4 c) right-right)))
(define prime-context-left-left-strings
  (lambda (c)
    (car (nthcdr 3 c))))
(define prime-context-set-left-left-strings!
  (lambda (c left-left)
    (set-car! (nthcdr 3 c) left-left)))
(define prime-context-set-learning-word!
  (lambda (c head)
    (set-car! (nthcdr 2 c) head)))
(define prime-context-learning-word
  (lambda (c)
    (car (nthcdr 2 c))))
(define prime-context-kana-mode
  (lambda (sc)
    (car (nthcdr 1 sc))))
(define prime-context-set-kana-mode!
  (lambda (sc mode)
    (set-car! (nthcdr 1 sc) mode)))
(define prime-context-state
  (lambda (c)
    (car (nthcdr 0 c))))
(define prime-context-set-state!
  (lambda (c s)
    (set-car! (nthcdr 0 c) s)))
;; state kana head okuri tail candidates nth rk

(define prime-flush
  (lambda (sc)
    (rk-flush (prime-context-rk-context sc))
    (prime-context-set-state! sc 'prime-state-no-preedit)
    (prime-context-set-immediate-commit! sc #t)
    (prime-context-set-left-string! sc '())
    (prime-context-set-right-string! sc '())
    (prime-context-set-left-left-strings! sc '())
    (prime-context-set-right-right-strings! sc '())
    (prime-context-set-nth! sc 0)
    (prime-context-set-candidate-window! sc #f)))


(define prime-context-new
  (lambda ()
    (let ((c 
	   (copy-list 
	    '(prime-state-latin #t () () () () 0 () () () () () () 0 "" #t #f))))
      (prime-context-set-rk-context! c
				   (rk-context-new ja-rk-rule #t #f))
      (prime-flush c)
      c)))

(define prime-context-kana-toggle
  (lambda (sc)
    (let ((s (prime-context-kana-mode sc)))
      (set! s (not s))
      (if s
	  (prime-context-set-mode! sc 1)
	  (prime-context-set-mode! sc 2))
      (prime-context-set-kana-mode! sc s))))

(define prime-get-nth-candidate
  (lambda (sc n)
    (if (> n (prime-get-nr-candidates sc))
	nil)
    (car (cdr (car (nthcdr n (prime-context-candidates sc)))))))

(define prime-get-nr-candidates
  (lambda (sc)
    (length (prime-context-candidates sc))))

(define prime-get-current-candidate
  (lambda (sc)
    (prime-get-nth-candidate
     sc
     (prime-context-nth sc))))

(define prime-get-candidates! ;;⤦äȴؿ̾ɤˤ
  (lambda (sc preedit context)
    (prime-lib-send-command (string-append "set_context\t"  context "\n"))
    (prime-context-set-candidates!
     sc
     (prime-parse-cands
      (prime-lib-send-command (string-append "l\t"  preedit "\n"))))
    ))

(define prime-make-assoc-list
  (lambda (lst)
    (mapcar 
     (lambda (str)
       (string-split str "="))
     lst)))

(define prime-commit-raw
  (lambda (sc id)
    (im-commit-raw id)
    (prime-context-set-raw-commit! sc #t)))

(define prime-commit-candidate
  (lambda (sc)
    (let ((nth (prime-context-nth sc))
	  (learning-word (prime-context-learning-word sc)))
      (if learning-word
	  (begin
	    (set! assoc-list 
		  (prime-make-assoc-list 
		   (cdr (cdar (nthcdr nth (prime-context-candidates sc))))))
	    (prime-learn-word sc assoc-list))))))

(define prime-learn-word
  (lambda (sc assoc-list)
    (let ((key     (or (cadr (assoc "basekey"     assoc-list)) ""))
	  (value   (or (cadr (assoc "base"        assoc-list)) ""))
	  (part    (or (cadr (assoc "part"        assoc-list)) ""))
	  (context (or (prime-context-last-word sc) ""))
	  (suffix  (or (cadr (assoc "conjugation" assoc-list)) ""))
	  (rest    (or (cadr (assoc "suffix"      assoc-list)) "")))
      
      (prime-lib-send-command
       (string-append "learn_word\t" key "\t" value "\t" part "\t" context "\t" suffix "\t" rest "\n"))
      
      (prime-context-set-last-word!
       sc
       (prime-get-current-candidate sc)))))

(define prime-parse-cands
  (lambda (cands-string)
    (mapcar
     (lambda (str-line)
       (string-split str-line "\t"))
     (cdr (delq "" (string-split cands-string "\n"))))))

(define prime-begin-conversion
  (lambda (sc id)
    (let ((res)
	  (rkc (prime-context-rk-context sc)))
      (prime-get-candidates!
       sc
       (string-append (string-list-concat (prime-context-left-string sc))
		      (string-list-concat (prime-context-right-string sc)))
       (rk-pending rkc))
      (prime-context-last-word sc)
      (set! res
	    (prime-get-nth-candidate sc 0))
      (if res
	  (begin
	    (prime-context-set-nth! sc 0)
	    (prime-context-set-state!
	     sc 'prime-state-converting))
	  (prime-flush sc))
      )))

(define prime-update-preedit
  (lambda (id sc)
    (if (not (prime-context-raw-commit sc))
	(let ((rkc (prime-context-rk-context sc))
	      (stat (prime-context-state sc))
	      (learning-word (prime-context-learning-word sc))
	      (left (prime-context-left-string sc))
	      (right (prime-context-right-string sc))
	      (left-left (prime-context-left-left-strings sc))
	      (right-right (prime-context-right-right-strings sc)))
	  
	  (if (and
	       prime-mask-pending-preedit
	       (usual-char? (string->charcode (car left))))
	      (set! left (append (list "*") (cdr left))))
	  
	  (im-clear-preedit id)
	  (if learning-word
	      (begin
		(im-pushback-preedit
		 id preedit-reverse
		 (string-append "[" (string-list-concat learning-word) "|"))))
	  (if left-left
	      (begin
		(im-pushback-preedit
		 id preedit-none
		 (string-list-concat left-left))))
	  (if (= stat 'prime-state-converting)
	      (begin
		(im-pushback-preedit
		 id preedit-reverse
		 (prime-get-current-candidate sc)))
	      (if (prime-has-preedit? sc)
		  (let ((hl (string-list-concat left))
			(hr (string-list-concat (prime-context-right-string sc))))
		    (if (string? hl)
			(im-pushback-preedit
			 id preedit-underline
			 hl))
		    (im-pushback-preedit id preedit-underline
					 (rk-pending rkc))
		    (im-pushback-preedit id preedit-cursor "")
		    (if (string? hr)
			(im-pushback-preedit
			 id preedit-underline
			 hr)))
		  (im-pushback-preedit id preedit-cursor "")))
	  
	  (if right-right
	      (im-pushback-preedit
	       id preedit-none
	       (string-list-concat right-right)))
	  (if learning-word
	      (im-pushback-preedit
	       id preedit-reverse "]"))
	  (im-update-preedit id))
	(prime-context-set-raw-commit! sc #f))))

(define prime-update-mode
  (lambda (id sc)
    (let ((mode (prime-context-mode sc)))
      (im-update-mode id mode)
      (prime-update-prop-label id sc))))

(define prime-update-candidate-window
  (lambda (sc id)
    (let* ((rkc (prime-context-rk-context sc))
	   (nth (prime-context-nth sc))
	   (preedit (string-append (string-list-concat (prime-context-left-string sc))
				   (string-list-concat (prime-context-right-string sc)))))
      (cond
       ((> nth 0)
	(im-update-candidate id nth))
       ((and
	 (prime-has-preedit? sc)
	 (not (prime-context-candidate-window sc))
	 (or prime-always-show-window?
	     (> (prime-context-candidate-op-count sc)
		prime-candidate-op-count))
	 (or (not (prime-context-immediate-commit sc))
	     (not prime-preedit-immediate-commit?)))
	(begin
	  (prime-get-candidates!
	   sc
	   preedit
	   (prime-context-last-word sc))
	  (im-begin-candidate
	   id (prime-get-nr-candidates sc) prime-nr-candidate-max)
	  (prime-context-set-candidate-window! sc #t)))
	  
       ((not (prime-has-preedit? sc))
	(begin
	  (prime-context-set-candidate-window! sc #f)
	  (im-end-candidate id)))
	  
       ((prime-context-candidate-window sc)
	(begin
	  (prime-get-candidates!
	   sc
	   preedit
	   (prime-context-last-word sc))
	  (im-update-candidate id nth)))
    ))))

(define prime-has-preedit?
  (lambda (sc)
    (or
     (> (length (prime-context-left-string sc)) 0)
     (> (length (prime-context-right-string sc)) 0)
     (> (length (rk-pending (prime-context-rk-context sc))) 0))))

(define prime-word-learning-start!
  (lambda (sc)
    (prime-context-set-learning-word!
     sc
     (append
     (prime-context-right-string sc)
     (prime-context-left-string sc)))
     (prime-context-set-right-string! sc '())
     (prime-context-set-left-string! sc '())
     (prime-context-set-nth! sc 0)
     (prime-context-set-state! sc 'prime-state-no-preedit)
     ))

(define prime-commit-to-left-left
  (lambda (sc lst)
    (prime-context-set-left-left-strings!
     sc (append lst (prime-context-left-left-strings sc)))
    (prime-context-set-right-string! sc '())
    (prime-context-set-left-string! sc '())
    (prime-context-set-nth! sc 0)
    (prime-context-set-state! sc 'prime-state-no-preedit)
    ))

(define prime-proc-input-no-preedit
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	   (id (context-id c))
	   (key-str (charcode->string (to-lower-char key)))
	   (rkc (prime-context-rk-context sc))
	   (res nil)
	   (direct (ja-direct (charcode->string key)))
	   (learning-word (prime-context-learning-word sc))
	   (registered (string-append (string-list-concat (prime-context-left-left-strings sc))
				(string-list-concat (prime-context-right-right-strings sc)))))
      (cond
       ((prime-wide-latin-key key key-state)
	(begin
	  (prime-context-set-mode! sc 3)
	  (prime-context-set-state! sc 'prime-state-wide-latin)
	  (prime-update-mode id sc)))
       
       ((prime-latin-key key key-state)
	(begin
	  (prime-context-set-mode! sc 0)
	  (prime-context-set-state! sc 'prime-state-latin)
	  (prime-update-mode id sc)))
       
       ((prime-kana-toggle key key-state)
	(begin 
	  (prime-context-kana-toggle sc)
	  (prime-update-mode id sc)))
       
       ((prime-backspace-key key key-state)
	(if (not (rk-backspace rkc))
	    (if (prime-context-left-left-strings sc)
		(prime-context-set-left-left-strings!
		 sc (cdr (prime-context-left-left-strings sc)))
		(prime-commit-raw sc id))))

       ((prime-delete-key key key-state)
	(if (not (rk-delete rkc))
	    (if (prime-context-right-right-strings sc)
		(prime-context-set-right-right-strings!
		 sc (cdr (prime-context-right-right-strings sc)))
		(prime-commit-raw sc id))))

       ((prime-cancel-key key key-state)
	(if learning-word
	    (begin
	      (prime-context-set-left-string!
	       sc (prime-context-learning-word sc))
	      (prime-context-set-learning-word! sc '())
	      (prime-context-set-left-left-strings! sc '())
	      (prime-context-set-right-right-strings! sc '()))))
       
       ((prime-commit-key key key-state)
	(if (and learning-word
		 (not (string-equal? registered "")))
	    (begin
	      (prime-lib-send-command
	       (string-append "learn_word\t" (string-list-concat learning-word) "\t" registered "\n"))
	      (im-commit id registered)
	      (prime-flush sc)
	      (prime-context-set-learning-word! sc '()))
	    (prime-commit-raw sc id)))
	
       ((and (shift-key-mask key-state)
	     (alphabet-char? key))
	(begin
	  (prime-context-set-immediate-commit! sc #f)
	  (prime-proc-input-with-preedit c key key-state)))

       ((prime-cand-select-key key key-state)
	(begin
	  (prime-context-set-immediate-commit! sc #f)
	  (prime-proc-input-with-preedit c key key-state)))

       ((prime-go-left-key key key-state)
	(begin
	  (if (prime-context-left-left-strings sc)
	      (let ((c (car (prime-context-left-left-strings sc))))
		(prime-context-set-left-left-strings!
		 sc (cdr (prime-context-left-left-strings sc)))
		(prime-context-set-right-right-strings!
		 sc
		 (append (prime-context-right-right-strings sc) (list c))))
	      (prime-commit-raw sc id))))
 
       ;; right
       ((prime-go-right-key key key-state)
	(begin
	  (if (prime-context-right-right-strings sc)
	      (let ((c (car (reverse (prime-context-right-right-strings sc)))))
		(prime-context-set-right-right-strings!
		 sc (reverse (cdr (reverse (prime-context-right-right-strings sc)))))
		(prime-context-set-left-left-strings!
		 sc
		 (append (list c) (prime-context-left-left-strings sc))))
	      (prime-commit-raw sc id))))

       ((control-key-mask key-state)
	(prime-commit-raw sc id))
       
       ;; direct key => commit
       ((and direct
	     (not learning-word))
	(begin
	  (im-commit id direct)))
       

       ((symbol? key)
	(if learning-word
	    ()
	    (begin
	      (prime-flush sc)
	      (prime-context-set-last-word! sc "")
	      (prime-commit-raw sc id))))

       (else
	(begin
	  (prime-proc-input-with-preedit c key key-state)))))))


(define prime-proc-input-with-preedit
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	   (id (context-id c))
	   (rkc (prime-context-rk-context sc))
	   (stat (prime-context-state sc))
	   (res ())
	   (learning-word (prime-context-learning-word sc)))
      (cond
       ((prime-begin-conv-key key key-state)
	(prime-begin-conversion sc id))
       
       ((prime-cancel-key key key-state)
	())
       
       ((prime-backspace-key key key-state)
	(begin
	  (if (prime-context-left-string sc)
	      (prime-context-set-left-string!
	       sc (cdr (prime-context-left-string sc))))
	  (prime-context-set-candidate-window! sc #f) ;FIXME:very dirty hack
	  ))
       ;; delete
       ((prime-delete-key key key-state)
	(begin
	  (if (prime-context-right-string sc)
	      (prime-context-set-right-string!
	       sc
	       (reverse
		(cdr (reverse (prime-context-right-string sc))))))
	  (prime-context-set-candidate-window! sc #f) ;FIXME:very dirty hack
	  ))
       ;; commit
       ((prime-commit-key key key-state)
	(if learning-word
	    (prime-commit-to-left-left sc
				       (append
					(prime-context-right-string sc)
					(prime-context-left-string sc)))
	    (begin
	      (im-commit id (string-append (string-list-concat (prime-context-left-string sc))
					   (string-list-concat (prime-context-right-string sc))))
	      (prime-flush sc)
	      (prime-update-mode id sc))))
       
       ;; left
       ((prime-go-left-key key key-state)
	(begin
	  (if (prime-context-left-string sc)
	      (let ((c (car (prime-context-left-string sc))))
		(prime-context-set-left-string!
		 sc (cdr (prime-context-left-string sc)))
		(prime-context-set-right-string! 
		 sc
		 (append (prime-context-right-string sc) (list c)))))))
       
       ;; right
       ((prime-go-right-key key key-state)
	(begin
	  (if (prime-context-right-string sc)
	      (let ((c (car (reverse (prime-context-right-string sc)))))
		(prime-context-set-right-string!
		 sc (reverse (cdr (reverse (prime-context-right-string sc)))))
		(prime-context-set-left-string!
		 sc
		 (append (list c) (prime-context-left-string sc)))))))
		
       ((and (prime-cand-select-key key key-state)
	     (prime-context-immediate-commit sc))
	(let* ((nth (- key 49))
	       (cand (prime-get-nth-candidate sc nth)))
	  (if cand
	      (if learning-word
		  (begin
		    (prime-context-set-nth! sc nth)
		    (prime-commit-to-left-left sc (string-to-list cand)))
		  (begin
		    (prime-context-set-nth! sc nth)
		    (im-commit id cand)
		    (prime-commit-candidate sc)
		    (prime-flush sc)
		    (prime-update-mode id sc))))))

       ;; modifiers (excepts shift) => ignore
       ((and
	 (modifier-key-mask key-state)
	 (not (shift-key-mask key-state)))
	(prime-commit-raw sc id))
       
       ((or (prime-prev-candidate key key-state)
	    (prime-next-candidate key key-state))
	(prime-proc-state-converting c key key-state))

       (else
	(begin
	  (prime-context-set-left-string!
	   sc
	   (string-to-list
	    (nth 1 (string-split 
		    (prime-lib-send-command 
		     (string-append "get_label\t"
				    (string-list-concat (prime-context-left-string sc))
				    (charcode->string key) "\n")) "\n"))))
	  
	  (prime-context-set-candidate-window! sc #f) ;FIXME:very dirty hack
	  (if (and
	       prime-preedit-immediate-commit?
	       (prime-context-immediate-commit sc))
	      (begin
		(im-commit id (string-list-concat (prime-context-left-string sc)))
		(prime-flush sc)))))))))

(define prime-proc-state-converting
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	  (id (context-id c))
	  (res ())
	  (learning-word (prime-context-learning-word sc)))
      (cond
       ((prime-next-candidate key key-state)
	(begin
	  (prime-context-set-nth! sc
				  (+ 1 (prime-context-nth sc)))
	  (if (prime-get-current-candidate sc)
	      (prime-context-set-candidate-op-count!
	       sc
	       (+ 1 (prime-context-candidate-op-count sc)))
	      (if learning-word
		  (prime-context-set-nth! sc 0)
		  (prime-word-learning-start! sc)))))

       ((prime-prev-candidate key key-state)
	(begin
	  (if (> (prime-context-nth sc) 0)
	      (prime-context-set-nth! sc (- (prime-context-nth sc) 1))
	      (prime-context-set-nth! sc (- (prime-get-nr-candidates sc) 1)))))

       ((prime-cancel-key key key-state)
	(prime-flush sc))
       
       ((prime-commit-key key key-state)
	(if learning-word
	    (prime-commit-to-left-left sc (string-to-list (prime-get-nth-candidate sc (prime-context-nth sc))))
	    (begin
	      (im-commit id (prime-get-current-candidate sc))
	      (prime-commit-candidate sc)
	      (prime-flush sc)
	      (prime-update-mode id sc))))

       ((prime-cand-select-key key key-state)
	(let* ((nth (- key 49))
	       (cand (prime-get-nth-candidate sc nth)))
	  (if cand
	      (if learning-word
		  (begin
		    (prime-context-set-nth! sc nth)
		    (prime-commit-to-left-left sc (string-to-list cand)))
		  (begin
		    (prime-context-set-nth! sc nth)
		    (im-commit id cand)
		    (prime-commit-candidate sc)
		    (prime-flush sc)
		    (prime-update-mode id sc))))))

       (else
	(begin
	  (if learning-word
	      (begin
		(prime-commit-to-left-left sc (append
					       (prime-context-right-string sc)
					       (prime-context-left-string sc)))
		(prime-proc-input-no-preedit c key key-state))
	      (begin
		(prime-update-mode id sc)
		(im-commit id (prime-get-current-candidate sc))
		(prime-commit-candidate sc)
		(prime-flush sc)
		(prime-proc-input-no-preedit c key key-state)))
	  (prime-update-preedit id sc))))
      )))


(define prime-proc-mode-latin
  (lambda (c key key-state)
    (let ((sc (context-data c))
	  (id (context-id c)))
      (if (prime-on-key key key-state)
	  (begin
	    (prime-context-set-mode! sc 1)
	    (prime-update-mode id sc))
	  (prime-commit-raw sc id)))))

(define prime-proc-mode-wide-latin
  (lambda (c key key-state)
    (let* ((w (ja-wide (charcode->string key)))
	   (id (context-id c))
	   (sc (context-data c)))
      (if (prime-on-key key key-state)
	  (begin
	    (prime-flush sc)
	    (prime-context-set-mode! sc 1)
	    (prime-update-mode id sc))
	  (if w
	      (im-commit id w)
	      (prime-commit-raw sc id))))))

(define prime-push-key
  (lambda (c key key-state)
    (let* ((sc (context-data c))
	   (state (prime-context-state sc))
	   (mode (prime-context-mode sc))
	   (fun)
	   (res))
      (if (= mode 0)
	  (set! fun prime-proc-mode-latin))
      (if (= mode 3)
	  (set! fun prime-proc-mode-wide-latin))
      (if (or (= mode 1) (= mode 2))
	  (begin
	    (if (prime-has-preedit? sc)
		(set! fun prime-proc-input-with-preedit)
		(set! fun prime-proc-input-no-preedit))
	    (if (= state 'prime-state-converting)
		(set! fun prime-proc-state-converting))))
      (fun c key key-state)
      (prime-update-candidate-window sc (context-id c))
      (prime-update-preedit (context-id c) sc)      
      )))

(define prime-init-handler
  (lambda (id arg)
    (let* ((c (find-context id)))
      (set! candidate-window-position "left")
      (set-context-data! c
			 (prime-context-new))
      (im-clear-mode-list id)
      (im-pushback-mode-list id "ľ")
      (im-pushback-mode-list id "Ҥ餬")
      (im-pushback-mode-list id "ѱѿ")
      (im-update-mode-list id)
      (im-update-mode id 0)

      (prime-update-prop-list id))))

(define prime-press-key-handler
  (lambda (id key state)
    (let* ((c (find-context id)))
      (if (and (number? key)
	       (< key 32))
	  (im-commit-raw id)
	  (prime-push-key c key state)))))

(define prime-release-key-handler
  (lambda (id key state)
    (if (and (number? key)
	     (< key 32))
	(im-commit-raw id)
	())))

(define prime-reset-handler
  (lambda (id)
    ()))

(define prime-mode-handler
  (lambda (id mode)
    (let* ((c (find-context id))
	   (sc (context-data c)))
      (prime-flush sc)
      (prime-context-set-mode! sc mode)
      (if (= mode 1)
	  (prime-context-set-kana-mode! sc #t))
      (if (= mode 2)
	  (prime-context-set-kana-mode! sc #f))
      (prime-update-preedit id sc)
      ())))

(define prime-get-candidate-handler
  (lambda (id idx accel-enum-hint)
    (let* ((c (find-context id))
	   (sc (context-data c)))
      (list (prime-get-nth-candidate sc idx) (digit->string (+ idx 1))))))

(define prime-set-candidate-index-handler
  (lambda (id idx)
    (let* ((c (find-context id))
	   (sc (context-data c)))
      (prime-context-set-nth! sc idx)
      (prime-update-preedit id sc))))

(define prime-prop-handler
  (lambda (id message)
    (let* ((c (find-context id))
	   (sc (context-data c)))
      (prime-flush sc)
      (prime-update-preedit sc id)
      (cond
       ((string-equal? message
		       "prop_prime_hiragana")
	(begin
	  (prime-context-set-kana-mode! sc #t)))
       ((string-equal? message
		       "prop_prime_direct")
	(begin
	  (prime-context-set-wide-latin! sc #f)))
       ((string-equal? message
		       "prop_prime_zenkaku")
	(begin
	  (prime-context-set-wide-latin! sc #t))))
      (prime-update-mode id sc)
      (prime-update-prop-label id sc))))

(define prime-update-prop-label
  (lambda (id sc)
    (let* ((state (prime-context-state sc))
	   (str ""))
      (cond
       ((= state 'prime-state-latin)
	(set! str "P\tľ\n"))
       ((= state 'prime-state-wide-latin)
	(set! str "\tѱѿ\n"))
       ((= state 'prime-state-no-preedit)
	(set! str "\tҤ餬\n")))
      (im-update-prop-label id str))))

(define prime-update-prop-list
  (lambda (id) 
    (let* ((c (find-context id))
	   (sc (context-data c))
	   (state (prime-context-state sc))
	   (str ""))
      (cond
       ((= state 'prime-state-latin)
	(set! str "P\tľ\n"))
       ((= state 'prime-state-wide-latin)
	(set! str "\tѱѿ\n"))
       ((= state 'prime-state-no-preedit)
	(set! str "\tҤ餬\n")))
      (set! str 
	    (string-append "branch\t" str
			   "leaf\t\tҤ餬\tҤ餬ʥ⡼\tprop_prime_hiragana\n"
			   "leaf\tP\tľ\tľϥ⡼\tprop_prime_latin\n"
			   "leaf\t\tѱѿ\tѱѿ⡼\tprop_prime_wide_latin\n"))
      (im-update-prop-list id str)
      )))

(register-im
 'prime
 "ja"
 "EUC-JP"
 nil
 prime-init-handler
 nil
 prime-mode-handler
 prime-press-key-handler
 prime-release-key-handler
 prime-reset-handler
 prime-get-candidate-handler
 prime-set-candidate-index-handler
 prime-prop-handler)
