;;
(define generic-next-candidate-key
  (lambda (key key-state)
    (or
     (= (to-lower-char key) 32)
     (= key 'down)
     (and
      (= (to-lower-char key) 110)
      (control-key-mask key-state)))))
(define generic-prev-candidate-key
  (lambda (key key-state)
    (or 
     (= key 'up)
     (and
      (= (to-lower-char key) 112)
      (control-key-mask key-state)))))
(define generic-next-page-key
  (lambda (key key-state)
    (= key 'next)))
(define generic-prev-page-key
  (lambda (key key-state)
    (= key 'prior)))
(define generic-return-key
  (lambda (key key-state)
    (or
     (and (= (to-lower-char key) 109)
	  (control-key-mask key-state))
     (= key 'return))))
(define generic-commit-key
  (lambda (key key-state)
    (or
     (and (= (to-lower-char key) 106)
	  (control-key-mask key-state))
     (generic-return-key key key-state))))
(define generic-cancel-key
  (lambda (key key-state)
    (or
     (= key 'escape)
     (and
      (=(to-lower-char key) 103)
      (control-key-mask key-state)))))
(define generic-backspace-key
  (lambda (key key-state)
    (or	(= key 'backspace)
	(and (control-key-mask key-state)
	     (= (to-lower-char key) 104)))))
(define generic-delete-key
  (lambda (key key-state)
    (or (= key 'delete)
	(and (control-key-mask key-state)
	     (= (to-lower-char key) 100)))))
(define generic-kill-key
  (lambda (key key-state)
    (and (control-key-mask key-state)
	 (= (to-lower-char key) 107))))
(define generic-kill-backward-key
  (lambda (key key-state)
    (and (control-key-mask key-state)
	 (= (to-lower-char key) 117))))

(define generic-go-left-key
  (lambda (key key-state)
    (or
     (left-key key key-state)
     (and (= (to-lower-char key) 98)
	  (control-key-mask key-state)))))
(define generic-go-right-key
  (lambda (key key-state)
    (or
     (right-key key key-state)
     (and (= (to-lower-char key) 102)
	  (control-key-mask key-state)))))
(define generic-beginning-of-preedit-key
  (lambda (key key-state)
    (or (= key 'home)
	(and (control-key-mask key-state)
	     (= (to-lower-char key) 97)))))
(define generic-end-of-preedit-key
  (lambda (key key-state)
    (or (= key 'end)
	(and (control-key-mask key-state)
	     (= (to-lower-char key) 101)))))
;;
(define generic-on-key
  (lambda (key key-state)
    (or
     (and
      (= (to-lower-char key) 32)
      (shift-key-mask key-state))
     (= key 'zenkaku-hankaku))))
(define generic-off-key
  (lambda (key key-state)
    (or
     (and
      (= (to-lower-char key) 32)
      (shift-key-mask key-state))
     (= key 'zenkaku-hankaku))))
