;;
(require "japanese.scm")
(require "generic-key.scm")
;;
(define anthy-init-lib-ok? nil)
;; configs
(define anthy-use-candidate-window? #t)
(define anthy-candidate-op-count 1)
(define anthy-nr-candidate-max 10)
(define anthy-show-segment-separator? #f)
(define anthy-segment-separator "|")

;; key defs
(define anthy-on-key
  (lambda (key key-state)
    (or
     (and (= (to-lower-char key) 106)
	  (control-key-mask key-state))
     (generic-on-key key key-state))))
(define anthy-latin-key
  (lambda (key key-state)
    (or 
     (and 
      (= (to-lower-char key) 108)
      (not (modifier-key-mask key-state)))
     (generic-on-key key key-state))))
(define anthy-wide-latin-key
  (lambda (key key-state)
    (and (= (to-lower-char key) 108)
	 (shift-key-mask key-state))))
(define anthy-hankaku-kana-key
  (lambda (key key-state)
    (and
     (= (to-lower-char key) 113)
     (control-key-mask key-state))))
(define anthy-kana-toggle-key
  (lambda (key key-state)
    (and
     (= (to-lower-char key) 113)
     (not (modifier-key-mask key-state)))))
(define anthy-commit-as-opposite-kana-key
  (lambda (key key-state)
    (and
     (= (to-lower-char key) 113)
     (shift-key-mask key-state))))
(define anthy-begin-conv-key
  (lambda (key key-state)
    (= (to-lower-char key) 32)))
(define anthy-commit-key
  (lambda (key key-state)
    (generic-commit-key key key-state)))
(define anthy-extend-segment-key
  (lambda (key key-state)
    (or
     (and
      (control-key-mask key-state)
      (= (to-lower-char key) 111))
     (and
      (shift-key-mask key-state)
      (= key 'right)))))
(define anthy-shrink-segment-key
  (lambda (key key-state)
    (or
     (and
      (control-key-mask key-state)
      (= (to-lower-char key) 105))
     (and
      (shift-key-mask key-state)
      (= key 'left)))))
(define anthy-next-candidate-key
  (lambda (key key-state)
    (generic-next-candidate-key key key-state)))
(define anthy-prev-candidate-key
  (lambda (key key-state)
    (generic-prev-candidate-key key key-state)))
(define anthy-next-page-key
  (lambda (key key-state)
    (generic-next-page-key key key-state)))
(define anthy-prev-page-key
  (lambda (key key-state)
    (generic-prev-page-key key key-state)))
(define anthy-cancel-key
  (lambda (key key-state)
    (generic-cancel-key key key-state)))
(define anthy-backspace-key
  (lambda (key key-state)
    (generic-backspace-key key key-state)))
(define anthy-delete-key
  (lambda (key key-state)
    (generic-delete-key key key-state)))
(define anthy-kill-key
  (lambda (key key-state)
    (generic-kill-key key key-state)))
(define anthy-kill-backward-key
  (lambda (key key-state)
    (generic-kill-backward-key key key-state)))
(define anthy-go-left-key
  (lambda (key key-state)
    (generic-go-left-key key key-state)))
(define anthy-go-right-key
  (lambda (key key-state)
    (generic-go-right-key key key-state)))
(define anthy-beginning-of-preedit-key
  (lambda (key key-state)
    (generic-beginning-of-preedit-key key key-state)))
(define anthy-end-of-preedit-key
  (lambda (key key-state)
    (generic-end-of-preedit-key key key-state)))
(define anthy-next-segment-key
  (lambda (key key-state)
    (generic-go-right-key key key-state)))
(define anthy-prev-segment-key
  (lambda (key key-state)
    (generic-go-left-key key key-state)))

;; access
(define anthy-context-on
  (lambda (ac)
    (car (nthcdr 0 ac))))

(define anthy-context-set-on!
  (lambda (ac s)
    (set-car! (nthcdr 0 ac) s)))

(define anthy-context-state
  (lambda (ac)
    (car (nthcdr 1 ac))))

(define anthy-context-set-state!
 (lambda (ac st)
   (set-car! (nthcdr 1 ac) st)))

(define anthy-context-ac-id
  (lambda (ac)
    (car (nthcdr 2 ac))))

(define anthy-context-set-ac-id!
  (lambda (ac id)
    (set-car! (nthcdr 2 ac) id)))

(define anthy-context-left-string ;;preedit strings in the left of cursor
 (lambda (ac)
   (car (nthcdr 3 ac))))

(define anthy-context-set-left-string!
  (lambda (ac str)
    (set-car! (nthcdr 3 ac) str)))

(define anthy-context-right-string
 (lambda (ac)
   (car (nthcdr 4 ac))))

(define anthy-context-set-right-string!
  (lambda (ac str)
    (set-car! (nthcdr 4 ac) str)))

(define anthy-context-rkc
  (lambda (ac)
    (car (nthcdr 5 ac))))

(define anthy-context-set-rkc!
 (lambda (ac rkc)
   (set-car! (nthcdr 5 ac) rkc)))

(define anthy-context-index-list
  (lambda (ac)
    (car (nthcdr 6 ac))))
  
(define anthy-context-set-index-list!
 (lambda (ac lst)
   (set-car! (nthcdr 6 ac) lst)))

(define anthy-context-cur-seg
  (lambda (ac)
    (car (nthcdr 7 ac))))

(define anthy-context-set-cur-seg!
  (lambda (ac seg)
    (set-car! (nthcdr 7 ac) seg)))

(define anthy-context-candidate-window
  (lambda (ac)
    (car (nthcdr 8 ac))))

(define anthy-context-set-candidate-window!
  (lambda (ac f)
    (set-car! (nthcdr 8 ac) f)))

(define anthy-context-candidate-op-count
  (lambda (ac)
    (car (nthcdr 9 ac))))

(define anthy-context-set-candidate-op-count!
  (lambda (ac c)
    (set-car! (nthcdr 9 ac) c)))

(define anthy-context-wide-latin
  (lambda (ac)
    (car (nthcdr 10 ac))))

(define anthy-context-set-wide-latin!
  (lambda (ac c)
    (set-car! (nthcdr 10 ac) c)))

(define anthy-context-kana-mode
  (lambda (ac)
    (car (nthcdr 11 ac))))

(define anthy-context-set-kana-mode!
  (lambda (ac c)
    (set-car! (nthcdr 11 ac) c)))

(define anthy-context-commit-raw
  (lambda (ac)
    (car (nthcdr 12 ac))))

(define anthy-context-set-commit-raw!
  (lambda (ac c)
    (set-car! (nthcdr 12 ac) c)))

(define anthy-type-hiragana 0)
(define anthy-type-katakana 1)
(define anthy-type-hankana 2)

(define anthy-mode-direct 0)
(define anthy-mode-hiragana 1)
(define anthy-mode-katakana 2)
(define anthy-mode-wide-latin 3)
(define anthy-mode-hankana 4)

;; on/off state(compose,input) anthy-context-id string rkc index-list
;; cur-seg candidate-window
(define anthy-context-new
 (lambda ()
   (let ((c '())
	 (rkc (rk-context-new ja-rk-rule #t #f)))
     (set! c (copy-list '(() () () () () () () () () () () 0 #t #f)))
     (anthy-context-set-ac-id!
      c
      (if anthy-init-lib-ok?
	  (anthy-lib-alloc-context)
	  ()))
     (anthy-context-set-rkc! c rkc)
     (anthy-flush c)
     (anthy-context-set-on! c #f)
     c)))

(define anthy-commit-raw
  (lambda (ac id)
    (im-commit-raw id)
    (anthy-context-set-commit-raw! ac #t)))

(define anthy-context-kana-toggle
  (lambda (ac)
    (let ((kana (anthy-context-kana-mode ac)))
      (if (= kana anthy-type-hiragana)
	  (anthy-context-set-kana-mode!
	   ac anthy-type-katakana))
      (if (= kana anthy-type-katakana)
	  (anthy-context-set-kana-mode!
	   ac anthy-type-hiragana))
      (if (= kana anthy-type-hankana)
	  (anthy-context-set-kana-mode!
	   ac anthy-type-hiragana)))))

(define anthy-make-string
  (lambda (sl dir type)
    (let ((get-str-by-type 
	   (lambda (l)
	     (cond
	      ((= type anthy-type-hiragana)
	       (caar l))
	      ((= type anthy-type-katakana)
	       (car (cdar l)))
	      ((= type anthy-type-hankana)
	       (cadr (cdar l)))))))
      (if sl
	  (if dir
	      (string-append (anthy-make-string (cdr sl) dir type)
			     (get-str-by-type sl))
	      (string-append (get-str-by-type sl)
			     (anthy-make-string (cdr sl) dir type)))
	  ""))))

(define anthy-make-left-string
  (lambda (sl kana)
    (anthy-make-string sl #t kana)))

(define anthy-make-right-string
  (lambda (sl kana)
    (anthy-make-string sl #f kana)))

;(define anthy-get-candidate
;  (lambda (ac nth-seg)
;    (let ((id (anthy-context-ac-id ac))
;	  (idx (nth (anthy-context-index-list ac) nth-seg)))
;      ())))

(define anthy-init-handler
  (lambda (id arg)
    (let ((c (find-context id)))
      (set-context-data! c (anthy-context-new))
      (im-clear-mode-list id)
      (im-pushback-mode-list id "ľ")
      (im-pushback-mode-list id "Ҥ餬")
      (im-pushback-mode-list id "")
      (im-pushback-mode-list id "ѱѿ")
      (im-pushback-mode-list id "Ⱦѥ")
      (im-update-mode-list id)
      (im-update-mode id 0)
      (anthy-update-prop-list id)
      ())))

(define anthy-release-handler
  (lambda (id)
    (let* ((c (find-context id))
	   (ac (context-data c))
	   (ac-id (anthy-context-ac-id ac)))
      (anthy-lib-free-context ac-id))))

(define anthy-mode-handler
  (lambda (id mode)
    (let* ((c (find-context id))
	   (ac (context-data c)))
      (anthy-flush ac)
      (cond  ; `case' is not supported by uim
       ((= mode anthy-mode-direct)
        (anthy-context-set-on! ac #f)
        (anthy-context-set-wide-latin! ac #f))
       ((= mode anthy-mode-hiragana)
        (anthy-context-set-on! ac #t)
        (anthy-context-set-kana-mode! ac anthy-type-hiragana))
       ((= mode anthy-mode-katakana)
        (anthy-context-set-on! ac #t)
        (anthy-context-set-kana-mode! ac anthy-type-katakana))
       ((= mode anthy-mode-wide-latin)
        (anthy-context-set-on! ac #f)
        (anthy-context-set-wide-latin! ac #t))
       ((= mode anthy-mode-hankana)
        (anthy-context-set-on! ac #t)
        (anthy-context-set-kana-mode! ac anthy-type-hankana)))
      (anthy-update-preedit ac id))
    ()))

(define anthy-flush
  (lambda (ac)
    (rk-flush (anthy-context-rkc ac))
    (anthy-context-set-left-string! ac '())
    (anthy-context-set-right-string! ac '())
    (anthy-context-set-on! ac #t)
    (anthy-context-set-state! ac #f)
    (anthy-context-set-index-list! ac ())
    (anthy-context-set-candidate-window! ac #f)
    (anthy-context-set-candidate-op-count! ac 0)))

(define anthy-begin-input
  (lambda (ac)
    (anthy-context-set-on! ac #t)
    (rk-flush (anthy-context-rkc ac))
    (anthy-context-set-state! ac #f)))

(define anthy-update-preedit
  (lambda (ac id)
    (if (not (anthy-context-commit-raw ac))
	(if (anthy-context-on ac)
	    (if (anthy-context-state ac)
		(anthy-compose-state-preedit ac id)
		(anthy-input-state-preedit ac id))
	    (begin
	      (im-clear-preedit id)
	      (im-update-preedit id)))
	(anthy-context-set-commit-raw! ac #f))))
  
(define anthy-proc-raw-state
  (lambda (c key key-state)
    (let ((id (context-id c))
	  (ac (context-data c)))
      (if (anthy-on-key key key-state)
	  (begin
	    (anthy-begin-input ac)
	    (anthy-update-mode ac id)
	    (anthy-update-prop-label ac id))
	  (anthy-commit-raw ac id)))))

(define anthy-make-index-list-rec
  (lambda (n)
    (if (> n 0)
	(cons 0
	      (anthy-make-index-list-rec (- n 1)))
	'())))

(define anthy-make-index-list
  (lambda (n old-lst)
    (if (< n (length old-lst))
	(truncate-list old-lst n 1)
	(append old-lst
		(anthy-make-index-list-rec (- n
					      (length old-lst)))))))

(define anthy-append-string
  (lambda (ac str)
    (and
     str
     (if (not (string? (car str)))
	 (begin
	   (anthy-append-string ac (car str))
	   (anthy-append-string ac (cdr str))
	   #f)
	 #t)
     (anthy-context-set-left-string!
      ac (cons str (anthy-context-left-string ac))))))
    

(define anthy-begin-conv
  (lambda (ac)
    (let* ((ac-id (anthy-context-ac-id ac))
	   (rkc (anthy-context-rkc ac))
	   (kana (anthy-context-kana-mode ac))
	   (last "")
	   (res))
      ;; get resudiual 'n'
       (set! res (rk-push-key-last! rkc))
      (if res
	  (anthy-append-string ac res))
      ;;
      (anthy-lib-set-string
       ac-id
       (string-append
		(anthy-make-left-string (anthy-context-left-string ac)  anthy-type-hiragana)
		(anthy-make-right-string (anthy-context-right-string ac) anthy-type-hiragana)))
      (anthy-context-set-index-list!
       ac
       (anthy-make-index-list
		(anthy-lib-get-nr-segments ac-id)
		nil))
      (anthy-context-set-state! ac #t)
      (anthy-context-set-cur-seg! ac 0)
      (rk-flush (anthy-context-rkc ac)))))

(define anthy-proc-input-state-no-preedit
  (lambda (ac id key key-state)
    (let
	((rkc (anthy-context-rkc ac))
	 (direct (ja-direct (charcode->string key))))
      (and

       (if (anthy-wide-latin-key key key-state)
	   (begin
	     (anthy-flush ac)
	     (anthy-context-set-on! ac #f)
	     (anthy-context-set-wide-latin! ac #t)
	     (anthy-update-mode ac id)
	     (anthy-update-prop-label ac id)
	     #f)
	   #t)
       (if (anthy-latin-key key key-state)
	   (begin
	     (anthy-flush ac)
	     (anthy-context-set-on! ac #f)
	     (anthy-context-set-wide-latin! ac #f)
	     (anthy-update-mode ac id)
	     (anthy-update-prop-label ac id)
	     #f)
	   #t)
       (if (anthy-backspace-key key key-state)
	   (begin
	     (anthy-commit-raw ac id)
	     #f)
	   #t)
       (if (anthy-delete-key key key-state)
	   (begin
	     (anthy-commit-raw ac id)
	     #f)
	   #t)
       (if (anthy-hankaku-kana-key key key-state)
	   (begin 
	     (anthy-context-set-kana-mode! ac anthy-type-hankana)
	     (anthy-update-mode ac id)
	     (anthy-update-prop-label ac id)
	     #f)
	   #t)
       (if (anthy-kana-toggle-key key key-state)
	   (begin 
	     (anthy-context-kana-toggle ac)
	     (anthy-update-mode ac id)
	     (anthy-update-prop-label ac id)
	     #f)
	   #t)
       ;; modifiers (except shift) => ignore
       (if (and (modifier-key-mask key-state)
		(not (shift-key-mask key-state)))
	   (begin
	     (anthy-commit-raw ac id)
	     #f)
	   #t)
       ;; direct key => commit
       (if direct
	   (begin
	     (im-commit id direct)
	     #f)
	   #t)
       (set! key-str (charcode->string (to-lower-char key)))
       (if (string-find (rk-expect rkc) key-str)
	   (let ((res (rk-push-key! rkc key-str)))
	     (if res
		 (anthy-append-string ac res))
	     #f)
	   #t)
       (anthy-commit-raw ac id)))))

(define anthy-has-preedit?
  (lambda (ac)
    (or
     (> (length (anthy-context-left-string ac)) 0)
     (> (length (anthy-context-right-string ac)) 0)
     (> (length (rk-pending (anthy-context-rkc ac))) 0))))

(define anthy-proc-input-state-with-preedit
  (lambda (ac id key key-state)
    (let ((rkc (anthy-context-rkc ac))
	  (kana (anthy-context-kana-mode ac)))
      (and
       ;; begin conversion
       (if (and
	    (anthy-begin-conv-key key key-state)
	    anthy-init-lib-ok?)
	   (begin
	     (anthy-begin-conv ac)
	     #f)
	   #t)
       ;; backspace
       (if (anthy-backspace-key key key-state)
	   (begin
	     (if (not (rk-backspace rkc))
		 (if (anthy-context-left-string ac)
		     (anthy-context-set-left-string!
		      ac
		      (cdr (anthy-context-left-string ac)))))
	     #f)
	   #t)
       ;; delete
       (if (anthy-delete-key key key-state)
	   (begin
	     (if (not (rk-delete rkc))
		 (if (anthy-context-right-string ac)
		     (anthy-context-set-right-string!
		      ac
		      (cdr (anthy-context-right-string ac)))))
	     #f)
	   #t)
       ;; kill
       (if (anthy-kill-key key key-state)
	   (begin
	     (anthy-context-set-right-string! ac ())
	     #f)
	   #t)
       ;; kill-backward
       (if (anthy-kill-backward-key key key-state)
	   (begin
	     (rk-flush rkc)
	     (anthy-context-set-left-string! ac ())
	     #f)
	   #t)
       ;; Ҥ餬ʥ⡼ɤǥʤꤹ
       (if (anthy-commit-as-opposite-kana-key key key-state)
	   (begin
	     (im-commit
	      id
	      (string-append
	       (anthy-make-left-string (anthy-context-left-string ac)
				       (not kana))
	       (anthy-make-right-string (anthy-context-right-string ac)
					(not kana))))
	     (anthy-flush ac)
	     #f)
	   #t)
       ;; ߤΤʤ塢Ҥ餬/ʥ⡼ɤڤ괹
       (if (anthy-kana-toggle-key key key-state)
	   (begin
	     (im-commit
	      id
	      (string-append
	       (anthy-make-left-string (anthy-context-left-string ac)
				       kana)
	       (anthy-make-right-string (anthy-context-right-string ac)
					kana)))
	     (anthy-flush ac)
	     (anthy-context-kana-toggle ac)
	     (anthy-update-mode ac id)
	     (anthy-update-prop-label ac id)
	     #f)
	   #t)
       ;; cancel
       (if (anthy-cancel-key key key-state)
	   (begin
	     (anthy-flush ac)
	     #f)
	   #t)
       ;; commit
       (if (anthy-commit-key key key-state)
	   (begin
	     (im-commit
	      id
	      (string-append
		(anthy-make-left-string (anthy-context-left-string ac) kana)
		(rk-pending rkc)
		(anthy-make-right-string (anthy-context-right-string ac) kana)))
	     (anthy-flush ac)
	     #f)
	   #t)
       ;; left
       (if (anthy-go-left-key key key-state)
	   (begin
	     (if (anthy-context-left-string ac)
		 (let
		     ((c (car (anthy-context-left-string ac))))
		   (anthy-context-set-left-string!
		    ac (cdr (anthy-context-left-string ac)))
		   (anthy-context-set-right-string! ac
						    (cons c
							  (anthy-context-right-string ac)))))
	     #f)
	   #t)
       ;; right
       (if (anthy-go-right-key key key-state)
	   (begin
	     (if (anthy-context-right-string ac)
		 (let
		     ((c (car (anthy-context-right-string ac))))
		   (anthy-context-set-right-string!
		    ac (cdr (anthy-context-right-string ac)))
		   (anthy-append-string ac c)))
	     #f)
	   #t)
       ;; beginning-of-preedit
       (if (anthy-beginning-of-preedit-key key key-state)
	   (begin
	     (if (anthy-context-left-string ac)
		 (begin
		   (anthy-context-set-right-string!
		    ac
		    (append
		     (reverse (anthy-context-left-string ac))
		     (anthy-context-right-string ac)))
		   (anthy-context-set-left-string! ac ())))
	     #f)
	   #t)
       ;; end-of-preedit
       (if (anthy-end-of-preedit-key key key-state)
	   (begin
	     (if (anthy-context-right-string ac)
		 (begin
		   (anthy-context-set-left-string!
		    ac
		    (append
		     (reverse (anthy-context-right-string ac))
		     (anthy-context-left-string ac)))
		   (anthy-context-set-right-string! ac ())))
	     #f)
	   #t)
       ;; modifiers (except shift) => ignore
       (if (and (modifier-key-mask key-state)
		(not (shift-key-mask key-state)))
	   (begin
	     (anthy-commit-raw ac id)
	     #f)
	   #t)
;       (set! key (to-lower-char key))
       (let* ((key-str (charcode->string key))
	      (pend (rk-pending rkc))
	      (res (rk-push-key! rkc key-str)))
	 (if (and res (not (string-equal? (car res) "")))
	     (anthy-append-string ac res)
	     (if using-kana-table?
	     (begin
	       (anthy-append-string ac (list pend "" ""))
;	       (anthy-append-string ac (list (rk-pending rkc) "" "")
))))))))

(define anthy-proc-input-state
  (lambda (ac id key key-state)
    (if (anthy-has-preedit? ac)
	(anthy-proc-input-state-with-preedit ac id key key-state)
	(anthy-proc-input-state-no-preedit ac id key key-state))))

(define anthy-pushback-preedit-segment-rec
  (lambda (ac id idx nseg)
    (let ((ac-id (anthy-context-ac-id ac)))
      (if (< idx nseg)
	  (begin
	    (if (and
		 anthy-show-segment-separator?
		 (< 0 idx))
		(im-pushback-preedit
		 id
		 (bit-or preedit-separator
			 preedit-underline)
		 anthy-segment-separator))
	    (im-pushback-preedit
	     id
	     (if (= idx (anthy-context-cur-seg ac))
		 (+ preedit-reverse preedit-cursor)
		 preedit-underline)
	     (anthy-lib-get-nth-candidate
	      ac-id idx
	      (nth idx (anthy-context-index-list ac))))
	    (anthy-pushback-preedit-segment-rec ac id (+ idx 1) nseg))))))

(define anthy-compose-state-preedit
  (lambda (ac id)
    (im-clear-preedit id)
    (anthy-pushback-preedit-segment-rec
     ac id
     0 (length (anthy-context-index-list ac)))
    (im-update-preedit id)))

(define anthy-input-state-preedit
  (lambda (ac id)
    (let ((rkc (anthy-context-rkc ac))
	  (kana (anthy-context-kana-mode ac)))
      (im-clear-preedit id)
      (im-pushback-preedit
       id preedit-underline
       (anthy-make-left-string (anthy-context-left-string ac) kana))
      (im-pushback-preedit id preedit-underline
                           (rk-pending rkc))
      (if (anthy-has-preedit? ac)
	  (im-pushback-preedit id preedit-cursor ""))
      (im-pushback-preedit
       id preedit-underline
       (anthy-make-right-string (anthy-context-right-string ac) kana))
      (im-update-preedit id))))
  
(define anthy-get-commit-string
  (lambda (ac idx nseg)
    (let ((ac-id (anthy-context-ac-id ac)))
      (if (< idx nseg)
	  (string-append
	   (anthy-lib-get-nth-candidate
	    ac-id idx
	    (nth idx (anthy-context-index-list ac)))
	   (anthy-get-commit-string ac (+ idx 1) nseg))
	  ""))))

(define anthy-do-commit
  (lambda (ac id)
    (anthy-reset-candidate-window ac id)
    (im-commit id
	       (anthy-get-commit-string
		ac 0
		(length (anthy-context-index-list ac))))
    (anthy-commit-string
     ac 0
     (length (anthy-context-index-list ac)))
    (anthy-flush ac)))

(define anthy-commit-string
  (lambda (ac idx nseg)
    (let ((ac-id (anthy-context-ac-id ac)))
      (if (< idx nseg)
	  (begin
	    (anthy-lib-commit-segment
	     ac-id idx (nth idx (anthy-context-index-list ac)))
	    (anthy-commit-string ac
				 (+ idx 1) nseg))
	  nil))))

(define anthy-move-segment
  (lambda (ac dir)
    (let ((pos (+ (anthy-context-cur-seg ac) dir))
	  (nseg (length  (anthy-context-index-list ac))))
      (if (and
	   (> pos -1)
	   (< pos nseg))
	  (anthy-context-set-cur-seg! ac pos)))))

(define anthy-move-candidate
  (lambda (ac id off)
    (let* ((seg (anthy-context-cur-seg ac))
	   (n (nth seg (anthy-context-index-list ac)))
	   (ac-id (anthy-context-ac-id ac))
	   (max (anthy-lib-get-nr-candidates ac-id seg)))
      (set! n (+ n off))
      (if (>= n max)
	  (set! n 0))
      (if (< n 0)
	  (set! n (- max 1)))
      (set-car! (nthcdr seg (anthy-context-index-list ac)) n)
      (anthy-context-set-candidate-op-count!
       ac
       (+ 1 (anthy-context-candidate-op-count ac)))
      (if (and
	   (= (anthy-context-candidate-op-count ac)
	      anthy-candidate-op-count)
	   anthy-use-candidate-window?)
	  (begin
	    (anthy-context-set-candidate-window! ac #t)
	    (im-begin-candidate
	     id
	     max anthy-nr-candidate-max)))
      (if (anthy-context-candidate-window ac)
	  (im-update-candidate id n)))))

(define anthy-reset-candidate-window
  (lambda (ac id)
    (if (anthy-context-candidate-window ac)
	(begin
	  (im-end-candidate id ac)
	  (anthy-context-set-candidate-window! ac #f)))
    (anthy-context-set-candidate-op-count! ac 0)))

(define anthy-resize-segment
  (lambda (ac id cnt)
    (let
	((ac-id (anthy-context-ac-id ac)))
      (anthy-reset-candidate-window ac id)
      (anthy-lib-resize-segment
       ac-id (anthy-context-cur-seg ac) cnt)
      (anthy-context-set-index-list!
       ac
       (anthy-make-index-list
	(anthy-lib-get-nr-segments ac-id)
	(truncate-list
	 (anthy-context-index-list ac)
	 (anthy-context-cur-seg ac))))
      )))

(define anthy-proc-compose-state
  (lambda (ac id key key-state)
    (and
     (if (anthy-commit-key key key-state)
	 (begin
	   (anthy-do-commit ac id)
	   #f)
	 #t)
     (if (anthy-extend-segment-key key key-state)
	 (begin
	   (anthy-resize-segment ac id 1)
	   #f)
	 #t)
     (if (anthy-shrink-segment-key key key-state)
	 (begin
	   (anthy-resize-segment ac id -1)
	   #f)
	 #t)
     (if (anthy-next-segment-key key key-state)
	 (begin
	   (anthy-move-segment ac 1)
	   (anthy-reset-candidate-window ac id)
	   #f)
	 #t)
     (if (anthy-prev-segment-key key key-state)
	 (begin
	   (anthy-move-segment ac -1)
	   (anthy-reset-candidate-window ac id)
	   #f)
	 #t)
     (if (anthy-backspace-key key key-state)
	 (begin
	   (anthy-context-set-state! ac #f)
	   (anthy-reset-candidate-window ac id)
	   #f)
	 #t)
     (if (anthy-next-candidate-key key key-state)
	 (begin
	   (anthy-move-candidate ac id 1)
	   #f)
	 #t)
     (if (anthy-prev-candidate-key key key-state)
	 (begin
	   (anthy-move-candidate ac id -1)
	   #f)
	 #t)
     (if (anthy-cancel-key key key-state)
	 (begin
	   (anthy-context-set-state! ac #f)
	   (anthy-reset-candidate-window ac id)
	   #f)
	 #t)
     (if (anthy-prev-page-key key key-state)
	 (begin
	   (im-shift-page-candidate id #f)
	   #f)
	 #t)
     (if (anthy-next-page-key key key-state)
	 (begin
	   (im-shift-page-candidate id #t)
	   #f)
	 #t)
     (if (and (modifier-key-mask key-state)
	      (not (shift-key-mask key-state)))
	 #f
	 #t)
     (begin
       (anthy-do-commit ac id)
       (anthy-proc-input-state ac id key key-state)))
    ()))


(define anthy-proc-wide-latin
  (lambda (c key key-state)
    (let* ((w (ja-wide (charcode->string key)))
	   (id (context-id c))
	   (ac (context-data c)))
      (and
       (if (anthy-on-key key key-state)
	   (begin
	     (anthy-flush ac)
	     (anthy-update-mode ac id)
	     (anthy-update-prop-label ac id)
	     #f)
	   #t)
       (if (and (modifier-key-mask key-state)
		(not (shift-key-mask key-state)))
	   (begin
	     (anthy-commit-raw ac id)
	     #f)
	   #t)
       (if w
	   (im-commit id w)
	   (anthy-commit-raw ac id)))
      ())))

(define anthy-press-key-handler
  (lambda (id key key-state)
    (let* ((c (find-context id))
	   (ac (context-data c)))
      (if (and (number? key)
	       (< key 32))
	  (im-commit-raw id)
	  (if (anthy-context-on ac)
	      (if (anthy-context-state ac)
		  (anthy-proc-compose-state ac id key key-state)
		  (anthy-proc-input-state ac id key key-state))
	      (if (anthy-context-wide-latin ac)
		  (anthy-proc-wide-latin c key key-state)
		  (anthy-proc-raw-state c key key-state))))
      ;; preedit
      (anthy-update-preedit ac id))))


(define anthy-release-key-handler
  (lambda (id key key-state)
    (let* ((c (find-context id))
	   (ac (context-data c)))
      (if (and
	   (not (anthy-context-on ac))
	   (not (anthy-context-wide-latin ac))
	   (and (number? key) (< key 32)))
	  ;; don't eat key release event for apps
	  (anthy-commit-raw ac id)))))

(define anthy-reset-handler
  (lambda (id)
    ()))

(if (and
     (symbol-bound? 'anthy-lib-init)
     (anthy-lib-init))
    (set! anthy-init-lib-ok? #t))

(define anthy-get-candidate-handler
  (lambda (id idx accel-enum-hint)
    (let* ((c (find-context id))
	   (ac (context-data c))
	   (ac-id (anthy-context-ac-id ac))
	   (cand (anthy-lib-get-nth-candidate
		  ac-id (anthy-context-cur-seg ac) idx)))
      (list cand (digit->string (+ idx 1))))))

(define anthy-set-candidate-index-handler
  (lambda (id idx)
    (let* ((c (find-context id))
	   (ac (context-data c))
	   (seg (anthy-context-cur-seg ac))
	   (ac-id (anthy-context-ac-id ac)))
      (set-car! (nthcdr seg (anthy-context-index-list ac)) idx)
;      (anthy-reset-candidate-window ac id)
      (anthy-move-segment ac 1)
      (anthy-update-preedit ac id))))

(define anthy-prop-handler
  (lambda (id message)
    (let* ((c (find-context id))
	   (ac (context-data c)))
      (anthy-flush ac)
      (anthy-update-preedit ac id)
      (cond
       ((string-equal? message
		       "prop_anthy_hiragana")
	(begin
	  (anthy-context-set-on! ac #t)
	  (anthy-context-set-kana-mode! ac anthy-type-hiragana)))
       ((string-equal? message
		       "prop_anthy_katakana")
	(begin
	  (anthy-context-set-on! ac #t)
	  (anthy-context-set-kana-mode! ac anthy-type-katakana)))
       ((string-equal? message
		       "prop_anthy_hankana")
	(begin
	  (anthy-context-set-on! ac #t)
	  (anthy-context-set-kana-mode! ac anthy-type-hankana)))
       ((string-equal? message
		       "prop_anthy_direct")
	(begin
	  (anthy-context-set-on! ac #f)
	  (anthy-context-set-wide-latin! ac #f)))
       ((string-equal? message
		       "prop_anthy_zenkaku")
	(begin
	  (anthy-context-set-on! ac #f)
	  (anthy-context-set-wide-latin! ac #t)))
       ((string-equal? message
		       "prop_anthy_kana")
	(begin
	  (load-kana-table))))
      (anthy-update-mode ac id)
      (anthy-update-prop-label ac id))))

(define anthy-update-prop-label
  (lambda (ac id)
    (let ((str "")
	  (kana (anthy-context-kana-mode ac)))
      (set! str
	    (if (anthy-context-on ac)
		(cond
		 ((= kana anthy-type-hiragana)
		  "\tҤ餬\n")
		 ((= kana anthy-type-katakana)
		  "\t\n")
		  ((= kana anthy-type-hankana)
		   "\tȾѥ\n"))
		(if (anthy-context-wide-latin ac)
		    "\tѱѿ\n"
		    "a\tľ\n")))
      (set! str (string-append str "\tϥ⡼\n"))
      (im-update-prop-label id str))))

(define anthy-update-mode
  (lambda (ac id)
    (if (anthy-context-on ac)
	(let ((kana (anthy-context-kana-mode ac)))
	  (cond
	   ((= kana anthy-type-hiragana)
	    (im-update-mode id anthy-mode-hiragana))
	   ((= kana anthy-type-katakana)
	    (im-update-mode id anthy-mode-katakana))
	   ((= kana anthy-type-hankana)
	    (im-update-mode id anthy-mode-hankana))))
	(if (anthy-context-wide-latin ac)
	    (im-update-mode id anthy-mode-wide-latin)
	    (im-update-mode id anthy-mode-direct)))
    (anthy-update-prop-label ac id)))

(define anthy-update-prop-list
  (lambda (id) 
    (let* ((c (find-context id))
	   (ac (context-data c))
	   (str "branch\t"))
      (set! str (string-append str
			       (if (anthy-context-on ac)
				   "\tҤ餬\n"
				   (if (anthy-context-wide-latin ac)
				       "\tѱѿ\n"
				       "a\tľ\n"))))
      (set! str (string-append
		 str
		 "leaf\t\tҤ餬\tҤ餬ʤǤ\tprop_anthy_hiragana\n"
		 "leaf\t\t\tʤϤǤޤ\tprop_anthy_katakana\n"
		 "leaf\t\tȾѥ\tȾѥʤϤǤޤ\tprop_anthy_hankana\n"
		 "leaf\tA\tľ\t쥯ȤǤ\tprop_anthy_direct\n"
		 "leaf\t\tѱѿ\tѱѿ⡼\tprop_anthy_zenkaku\n"
		 "branch\t\t\n"
		 "leaf\t\t޻\tdesc\tprop_anthy_roma\n"
		 "leaf\t\t\t\tprop_anthy_kana\n"))
      (im-update-prop-list id str)
      )))

(register-im
 'anthy
 "ja"
 "EUC-JP"
 nil
 anthy-init-handler
 anthy-release-handler
 anthy-mode-handler
 anthy-press-key-handler
 anthy-release-key-handler
 anthy-reset-handler
 anthy-get-candidate-handler
 anthy-set-candidate-index-handler
 anthy-prop-handler
)
