#ifdef HAVE_CONFIG_H
#  include <uim/config.h>
#endif

#include <uim/gettext.h>
#include <gtk/gtk.h>

static void
delete_event(GtkWidget *widget, gpointer data)
{
  gtk_main_quit ();
}

static gboolean
button_press_event(GtkWidget *window, GdkEventButton *event, gpointer data)
{
  int x,y;
  gtk_window_get_position (GTK_WINDOW(window), &x, &y);

  gtk_window_begin_move_drag(GTK_WINDOW(window), event->button,
			     x + event->x, y + event->y, event->time);
  return FALSE;
}

int 
main (int argc, char *argv[])
{
  GtkWidget *toolbar;
  GtkWidget *window;

  gtk_set_locale();
  
  gtk_init( &argc, &argv );

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_window_set_type_hint(GTK_WINDOW(window), GDK_WINDOW_TYPE_HINT_DOCK);

  gtk_window_set_skip_taskbar_hint(GTK_WINDOW(window), TRUE);
  gtk_window_set_decorated (GTK_WINDOW(window), FALSE);
  gtk_window_stick(GTK_WINDOW(window));

  gtk_widget_add_events (window, GDK_BUTTON_PRESS_MASK);

  g_signal_connect (G_OBJECT (window), "delete_event",
		    G_CALLBACK (delete_event), NULL);

  g_signal_connect (G_OBJECT (window), "button-press-event",
		    G_CALLBACK (button_press_event), NULL);
  
  toolbar = (GtkWidget*)uim_helper_toolbar_new();

  gtk_container_add (GTK_CONTAINER (window), toolbar);  
  gtk_widget_show_all (GTK_WIDGET (window));

  gtk_main ();
  return 0;
}

