#include <uim/config.h>
#include <uim/uim.h>
#include <uim/uim-helper.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <glib/gprintf.h>
#include <stdlib.h>
#include <string.h>

#define NR_CANDIDATES 10 /* this should be configurable*/

typedef struct {
  GtkWidget *top_win;
  GtkWidget *clist;
  GtkWidget *numlabel;
  int nr_candidates;
  int candidate_index;
  int is_active;
  int layout_begin;
  int select_count;
  GdkRectangle cursor;
}candidate_window;

static candidate_window cwin;
static int read_tag;
static GtkWidget* m_window;
static GtkWidget* m_view;
static GtkListStore* m_store;   

void
select_candidate_cb(GtkWidget *clist,
		    gint row, gint column,
		    GdkEventButton *event,
		    gpointer data)
{
  if (cwin.select_count == 0) {
    int idx = row + cwin.layout_begin;
    
    if( idx >= cwin.nr_candidates ) {
      gtk_clist_select_row(GTK_CLIST(cwin.clist),
			   cwin.candidate_index - cwin.layout_begin,
			   0);
      return;
    }
    
    //    uim_set_candidate_index(ic->mUc, idx);
    cwin.candidate_index = idx;
  } else {
    cwin.select_count --;
  }
}

void
init_candidate_win(void)
{
  GtkListStore* store;
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *column; 
  
  GtkWidget* window;
  GtkWidget* scrw;
  GtkWidget* tree_view;
  
  GtkWidget *vbox;
  GtkWidget *numlabel;

  vbox = gtk_vbox_new(FALSE, 0);

  store = gtk_list_store_new(2, G_TYPE_UINT, G_TYPE_STRING);
  
  window = gtk_window_new(GTK_WINDOW_POPUP);
  gtk_container_set_border_width(GTK_CONTAINER(window), 1);
  gtk_window_set_default_size(GTK_WINDOW(window), 80, 150);
  
  scrw = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrw),
				 GTK_POLICY_NEVER,
				 GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(vbox), scrw, TRUE, TRUE, 0);
  
  tree_view = gtk_tree_view_new_with_model(GTK_TREE_MODEL(store));
  gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(tree_view), TRUE);
  gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(tree_view), FALSE);
  gtk_container_add(GTK_CONTAINER(scrw), tree_view);

  gtk_container_add(GTK_CONTAINER(window), vbox);
    
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("No",
						    renderer,
						    "text",
						    0,
						    NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree_view), column);
  
  renderer = gtk_cell_renderer_text_new();
  column = gtk_tree_view_column_new_with_attributes("Text",
						    renderer,
						    "text",
						    1,
						    NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(tree_view), column);
  
  numlabel = gtk_label_new("");

  gtk_box_pack_start(GTK_BOX(vbox), numlabel, FALSE, FALSE, 0);

  m_window = window;
  m_store = store;
  m_view = tree_view;
  cwin.numlabel = numlabel;

  cwin.is_active = 0;

  /*  g_signal_connect(G_OBJECT(cwin.clist), "select_row",
		   G_CALLBACK(select_candidate_cb),
		   NULL);*/
  gtk_widget_show(numlabel);
  gtk_widget_show_all(vbox);
}

void
candwin_begin(char **str)
{
  GtkListStore* store;
  gsize rbytes, wbytes;
  GtkTreeIter ti;
  int i,j = 1;
  char *utf8_str;

  store = m_store;
  gtk_list_store_clear(store);
  
  for(i = 2; str[i];i++) {

    if(strcmp(str[i], "") == 0) {
      break;
    }
    utf8_str = g_convert(str[i],
			 -1, 
			 "UTF-8",
			 "EUC-JP",
			 &rbytes, &wbytes, NULL);
    
    gtk_list_store_append(store, &ti);
    gtk_list_store_set(store, &ti,
		       0, j,
		       1, utf8_str,
		       -1);
    j++;
    g_free(utf8_str);
  }
  
  gtk_widget_show_all(m_window);
  cwin.nr_candidates = i - 2 ;
  cwin.is_active = 1;
}

void
candwin_update(char **str)
{
  int index;
  char idx[20];
  GtkTreePath* path;

  sscanf(str[1],"%d",&index);
  cwin.candidate_index = index;

  path = gtk_tree_path_new_from_indices(index, -1);
  gtk_tree_view_set_cursor(GTK_TREE_VIEW(m_view),
			   path, NULL, FALSE);
  gtk_tree_view_scroll_to_cell(GTK_TREE_VIEW(m_view),
			       path, NULL, FALSE, 0.0, 0.0);

  sprintf(idx, "%d / %d", cwin.candidate_index + 1 , cwin.nr_candidates); 
  
  gtk_label_set_text( GTK_LABEL(cwin.numlabel), idx);

}

void
candwin_move(char **str)
{
  int x,y;
  sscanf(str[1],"%d",&x);
  sscanf(str[2],"%d",&y);
  gtk_window_move(GTK_WINDOW(m_window), x, y );
  //  layout_candidate();
}


void
candwin_show(void)
{
  if(cwin.is_active)
    gtk_widget_show_all(m_window);
}

void
candwin_end(void)
{
  gtk_widget_hide(m_window);
  cwin.is_active = 0;
}

void str_parse(char *str)
{
  gchar **tmp;
  int i = 0;
  
  tmp = g_strsplit(str, "\n", 0);
  
  while(tmp[i]){
    
    if(strcmp("begin", tmp[i]) == 0){
      candwin_begin(tmp);
    } else if(strcmp("update", tmp[i]) == 0) {
      candwin_update(tmp);
    } else if(strcmp("show", tmp[i]) == 0) {
      candwin_show();
    } else if(strcmp("hide", tmp[i]) == 0) {
      gtk_widget_hide_all(m_window);
    } else if(strcmp("move", tmp[i]) == 0) {
      candwin_move(tmp);
    } else if(strcmp("end", tmp[i]) == 0) {
      candwin_end();
    }
    i++;
  }
  g_strfreev(tmp);
}

static void
read_cb(gpointer p, int fd, GdkInputCondition c)
{
  char *tmp = strdup("");
  char buf[1024];

  while (fgets (buf, sizeof(buf), stdin ) != NULL ) {
    if(strcmp( buf, "\n" ) == 0) {
       str_parse(tmp);
       free(tmp);
       return;
    }
    tmp = realloc(tmp, strlen(tmp) + strlen(buf) + 1);
    strcat(tmp, buf);
  }
  exit(-1);
}

int main (int argc, char *argv[])
{
  gtk_set_locale();
  gtk_init( &argc, &argv );

  init_candidate_win();

  read_tag = gdk_input_add(0, (GdkInputCondition)GDK_INPUT_READ,
			   read_cb, 0);
  gtk_main ();
  return 0;
}
