#ifdef HAVE_CONFIG_H
#  include <uim/config.h>
#endif

#include <stdlib.h>
#include <locale.h>
#include <panel-applet.h>
#include <gnome.h>
#include <libgnome/libgnome.h>
#include <uim/uim.h>

PanelApplet *uimapplet;


static void 
display_help_dialog (BonoboUIComponent *uic, gpointer data, const gchar *verbname);
static void
display_about_dialog(BonoboUIComponent *uic, gpointer data, const gchar *verbname);




static const BonoboUIVerb uim_menu_verbs [] = {
  BONOBO_UI_VERB ("UimHelp",       display_help_dialog),
  BONOBO_UI_VERB ("UimAbout",      display_about_dialog),
  BONOBO_UI_VERB_END
};


static const char uim_menu_xml [] =
        "<popup name=\"button3\">\n"
        "   <menuitem name=\"Help Item\" verb=\"UimHelp\" _label=\"Help\"\n"
        "             pixtype=\"stock\" pixname=\"gtk-help\"/>\n"
        "   <menuitem name=\"About Item\" verb=\"UimAbout\" _label=\"About ...\"\n"
        "             pixtype=\"stock\" pixname=\"gnome-stock-about\"/>\n"
        "</popup>\n";



/* Opens gnome help application
 */
static void 
display_help_dialog (BonoboUIComponent *uic, gpointer data, const gchar *verbname)
{
  GError *error = NULL;
  
  gnome_help_display("Uim", NULL, &error);

  if (error)
    {
      GtkWidget *dialog;
      dialog = gtk_message_dialog_new(NULL, 
				      GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
				      GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
				      error->message);
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      g_error_free (error);
      error = NULL;
    }
}

/* Just the about window... If it's already open, just focus it
 */
static void
display_about_dialog(BonoboUIComponent *uic, gpointer data, const gchar *verbname)
{
  /*	GdkPixbuf *icon;*/
  GtkWidget *dialog;
  const char *authors[] = 
    {"Yusuke TABATA <yusuke@cherubim.icw.co.jp> \nTOKUNAGA Hiroyuki <tkng@xem.jp>",NULL};
  
  /* Feel free to put your names here translators */
  char *translators = _("TRANSLATORS");
  
  /* icon = gdk_pixbuf_new_from_xpm_data(ICON_APPLET);*/
  
  dialog = GTK_WIDGET(gnome_about_new (_("Uim Helper Applet"), VERSION, "Copyright 2003 TOKUNAGA Hiroyuki",
				       _("Applet for indicate uim's status"),
				       (const char **) authors, NULL, 
				       strcmp("TRANSLATORS", translators) ? translators : NULL, 
				       NULL));
  
  gtk_widget_show(GTK_WIDGET(dialog));
}


static gboolean
uim_applet_new(PanelApplet *applet,
		 const gchar *iid,
		 gpointer     data)
{
  GtkWidget *toolbar;
  uimapplet = applet;
 
  if (strcmp (iid, "OAFIID:GNOME_UimApplet") != 0)
    return FALSE;

  toolbar = (GtkWidget*)uim_helper_toolbar_new();

  gtk_container_add (GTK_CONTAINER (applet), toolbar);  
  gtk_widget_show_all (GTK_WIDGET (applet));

  panel_applet_setup_menu(applet,
			  uim_menu_xml,
			  uim_menu_verbs,
			  toolbar);

  return TRUE;
}



PANEL_APPLET_BONOBO_FACTORY ("OAFIID:GNOME_UimApplet_Factory",
                             PANEL_TYPE_APPLET,
                             "uim gnome2 Applet",
                             "0",
                             (PanelAppletFactoryCallback)uim_applet_new,
                             NULL);
